package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCostCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanCostVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPopFeeVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanService.java, v 0.1 2015-08-12 15:02
 */
public interface PcsPoPlanService {

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsPoPlan buildFromVO(PcsPoPlanVO vo);

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsPoPlanVO buildFromModel(PcsPoPlan record);

    /**
     * 更新收货计划的收货时间
     * @param id
     * @param date
     * @return
     */
    boolean updatePcsPoPlanById(long id, String date);

    public boolean updatePcsPoPlanByPrimaryKey(PcsPoPlan pcsPoPlan);
    
    /**
     * 更新收货计划行的分货标识
     * @param id
     * @param sign
     * @return
     */
    boolean updatePcsPoPlanLineById(long id, Integer sign);
    
    /**
     * 更新加工单的分货标识
     * @param id
     * @param sign
     * @return
     */
    boolean updatePrdcJobById(long id, Integer sign);

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    PcsPoPlan create(PcsPoPlan record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsPoPlan record);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsPoPlan findPoPlanById(long id);

    /**
     * 根据主键查找实体VO
     *
     * @param code
     * @return
     */
    PcsPoPlan findPoPlanByCode(String code);

    /**
     * 根据状态查找实体
     * @param status
     * @return
     */
    List<PcsPoPlan> findPoPlanByStatus(Integer status);

    List<PcsPoPlanVO> findWasteAfterPopFinished(PcsPoPlanVO vo);

    void sendPopEmailByCond(PcsPoPlanVO vo);

    /**
     * 创建计划信息和计划行信息
     *
     * @param pcsPoPlan
     * @param pcsPoPlanLineList
     * @return
     */
    Boolean createPoPlanAndLine(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList)throws Exception;

    /**
     * 创建计划信息和计划行信息,并自动完成
     *
     * @param pcsPoPlan
     * @param pcsPoPlanLineList
     * @return
     */
    Boolean createPoPlanAndLineThenFinish(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList)throws Exception;

    /**
     * 根据采购单号查询所有收货计划
     *
     * @param poId
     * @return
     */
    List<PcsPoPlan> findPcsPoPlanByPoId(long poId);

    List<PcsPoPlanVO> findPopVOsByCond(PcsPoPlanCond cond);

    /**
     * 根据采购单号查询所有收货计划
     *
     * @param poIds
     * @return
     */
    List<PcsPoPlanVO> findPcsPoPlanByPoIds(List<Long> poIds,boolean cascade);

    List<PcsPoPlan> findPcsPoPlanByCond(PcsPoPlanCond cond);

    Map<Long,List<PcsPoPlanLineVO>> findPoPlanLineMap(List<Long> poPlanIds);

    /**
     * 同步仓库指令数据
     *
     * @param poPlan
     * @return
     */
    Boolean synPoPlanAndLine(PcsPoPlan poPlan);

    /**
     * 导出收货计划状态~待入库
     * @return
     */
    byte[] exportPoPlanStatusWaitingIn();

    /**
     * 导出采购订单明细
     * @return
     */
    byte[] exportPoInfomation();

    /**
     * 更新采购单收货计划
     *
     * @return 是否成功
     */
    public boolean updatePoPlan(PcsPoPlan po);

    /**
     * 更新采购单收货计划行；
     *
     * @return 是否成功
     */
    public boolean updatePoPlanLine(PcsPoPlanLine line);
    /**
     * 通过采购单查询采购单所有的采购计划单是否都是收货完成
     * @param poId
     * @return
     */
    public boolean isAllPoPlanFinished(Long poId);
    /**
     * 通过采购单查询采购单收货数据是否完成
     * @param poId
     * @return
     */
    public boolean isAllReceivePo(Long poId);

    /**
     * 关闭收货计划
     * @param poPlandId
     * @return
     */
    @Transactional
    public Boolean closePoPlanByPlanId(Long poPlandId);

    @Transactional
    public Boolean closePoPlanByPlanIdCheckCommand(Long poPlandId,Integer whCommandId);

    @Transactional
    int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost);

    @Transactional
    int batchCreatePoPlanFee(List<PcsPoPlanCost> pcsPoPlanCosts);

    /**
     * 获取收货计划下的所有费用列表
     * @param poPlanId
     * @return
     */
    List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId);

    List<PcsPoPlanCost> listPcsPoPlanCostByPopIds(List<Integer> popIds);

    Map<Integer,List<PcsPoPlanCost>> mapPcsPoPlanCost(List<Integer> popIds);

    List<PcsPoPlanCostVO> listPoPlanCostVOsByGroup(PcsPoPlanCostCond cond);

    List<PcsPoPlanCostVO> listPoPlanCostVOs(PcsPoPlanCostCond cond);

    Pagination<PcsPoPlanCostVO> pagePoPlanCostVOs(PcsPoPlanCostCond cond);

    /**
     * 获取采购单下的所有费用列表
     * @param poId
     * @return
     */
    List<PcsPoPlanCost> findPoCostDetails(Integer poId);

    /**
     * 更新进口采购单总价
     * @param pcsPoPlanCost
     * @return
     */
    int  updatePoTotalAmount(PcsPoPlanCost pcsPoPlanCost, int optType);
    
    
    int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType);

    /**
     * 根据费用id查询费用信息
     * @param costId
     * @return
     */
    public PcsPoPlanCost selectCostByCostId(Long costId);

    Integer closePopPlanEndMonth();

    boolean updatePcsPoPlanWarnFlagByIds(List<Long> ids);

    List<PcsPopFeeVO> calculatePopFee(List<Long> popIds);

    Map<Long, PcsPopFeeVO> mapPopFee(List<Long> popIds);

    int delPoPlanFee(Long poPlanFeeId);
    //逻辑删除POP费用
    int delPoPlanFeeByIds(List<Long> feeIds);
}