package com.thebeastshop.pegasus.service.purchase.service;

import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanLineCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.common.Pagination;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanLineService.java, v 0.1 2015-08-12 15:03
 */
public interface PcsPoPlanLineService {

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsPoPlanLine buildFromVO(PcsPoPlanLineVO vo);

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsPoPlanLineVO buildFromModel(PcsPoPlanLine record);

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    Long create(PcsPoPlanLine record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsPoPlanLine record);

    int update(List<PcsPoPlanLineVO> records);

    /**
     * 根据poPlanId(外键)查找实体
     *
     * @param poPlanId
     * @return
     */
    List<PcsPoPlanLine> findPoPlanLineByPoPlanId(long poPlanId);

    /**
     * 根据poPlanId(外键)查找实体VO
     *
     * @param poPlanId
     * @return
     */
    List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId);
    
    /**
     * 查找实体VO
     *
     * @return
     */
    List<PcsPoPlanLineVO> findPoPlanLineVO(boolean cascade);

    /**
     * 根据poPlanId(外键)查找实体VO
     *
     * @param poPlanIds
     * @return
     */
    List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanIds(List<Long> poPlanIds);

    /**
     * 根据poId(外键)查找实体
     *
     * @param poId
     * @return
     */
    List<PcsPoPlanLine> findPoPlanLineByPoId(long poId);

    Pagination<PcsPoPlanLineVO> pagePcsPoPlanLineVOByCond(PcsPoPlanLineCond cond);

    List<PcsPoPlanLineVO> listPcsPoPlanLineVOByCond(PcsPoPlanLineCond cond);

    /**
     * 根据pop状态和skucode 查询所有pop收货计划
     * @param params
     * @return
     */
    List<PcsPoPlanLineVO> findPcsPoPlanLineListByParams(Map<String,Object> params);


    int addPopLineHsCode(List<PcsPoPlanLineVO> popLines);

    List<PcsPoPlanLineVO> sumPopSkuTotalQuantity(List<Long> popIds);

    List<PcsPoPlanLineVO> listIncludeWaste(List<Long> poIds);
}