package com.thebeastshop.pegasus.service.purchase.service;


import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.service.purchase.cond.PoLogisticsBillCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLogisticsBill;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLogisticsBillVO;
import com.thebeastshop.pegasus.service.purchase.vo.PoLogisticsBillStatusTab;

import java.util.List;

/**
 * 采购单物流单管理
 * @author Gary
 * @create date  2018/09/14
 *
 */
public interface PcsPoLogisticsBillService {

    int savePopLogisticsBill(PcsPoPlanLogisticsBillVO logisticsBill);

    int savePopLogisticsBills(List<PcsPoPlanLogisticsBillVO> logisticsBills);

    PcsPoPlanLogisticsBill buildVO2DO(PcsPoPlanLogisticsBillVO logisticsBill);

    PcsPoPlanLogisticsBillVO buildDO2VO(PcsPoPlanLogisticsBill logisticsBill);


    PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillById(Integer billId);

    PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopCode(String popCode);

    PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopId(Long popId);

    PageInfo<PcsPoPlanLogisticsBillVO> listBillByCond(PoLogisticsBillCond cond);

    List<PoLogisticsBillStatusTab> countGroupByBillstatus(PoLogisticsBillCond cond);

    /**
     * 取消物流单
      * @param id
     * @return
     */
    int cancelPopLogisticsBill(Integer id);

    List<PcsPoPlanLogisticsBillVO> listLogisticsBillByPoId(Long poId);

    /**
     * 关闭POP，需要处理相关物流单
     * @param poPlandId
     * @return
     */
    Boolean closePoPlan(Long poPlandId);
}