/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoLineService.java, v 0.1 2015-08-10 11:00
 */
public interface PcsPoLineService {

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsPoLine buildFromVO(PcsPoLineVO vo);

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsPoLineVO buildFromModel(PcsPoLine record);

    List<PcsPoLineVO> buildFromModel(List<PcsPoLine> records);

    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    Long create(PcsPoLine record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsPoLine record);

    boolean update(PcsPoLineVO pcsPoLineVO);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsPoLine findPoLineById(long id);

    List<PcsPoLineVO> findPoLineByPoIds(List<Long> poIds);

    /**
     * 根据外键查找实体
     *
     * @param poId
     * @return
     */
    List<PcsPoLine> findPoLineByPoId(long poId);

    /**
     * 根据外键查找实体vo
     *
     * @param poId
     * @return
     */
    List<PcsPoLineVO> findPoLineVOByPoId(long poId);

    List<PcsPoLineVO> findPoLineVOByPoIdForExcel(long poId);

    /**
     * 根据外键查找实体vo
     *
     * @param id
     * @return
     */
    List<PcsPoLineVO> findPoLineVOById(long id);

    List<PcsPoLineVO> findPackageNumBySku(PcsPoLineVO pcsPpLinevo);

    List<PcsPoLineVO> findAutomaticTransferAllot(PcsPoPlan pcsPoPlan);

    List<PcsPoLineVO> findPoSkuByPoId(long poId);

    /**
     * 删除实体
     *
     * @param id
     * @return
     */
    Boolean deleteById(long id);

    List<PcsPoLineVO> findSkuByPoCode(String poCode);

    List<PcsPoLineVO> selectCanAutoCreatePopLines();
}
