package com.thebeastshop.pegasus.service.purchase.service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCapacityCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerRecipePlanCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDelivery;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryDate;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryRecipe;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacityLog;
import com.thebeastshop.pegasus.service.purchase.vo.*;

import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
/**
 * Created by jim.huang on 2017/2/8.
 */
public interface PcsFlowerDeliveryService {
    /**
     * 查询鲜花月送信息
     *
     * @param cond
     * @return
     */
    Pagination<PcsFlowerDeliveryVO> getFlowerDeliveryByCond(PcsFlowerDeliveryCond cond);

    /**
     * 根据skuCode查询配送信息
     *
     * @param cond
     * @return
     */
    public PcsFlowerDeliveryVO getFlowerDeliveryBySku(PcsFlowerDeliveryCond cond);

    /**
     * 根据ID查询配送日期详情
     *
     * @param id
     * @return
     */
    public PcsFlowerDeliveryRecipe getFlowerDeliveryRecipeById(Long id);

    /**
     * 只查询鲜花月送配送详情
     * @param cond
     * @return
     */
    List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryRecipeByCond(PcsFlowerDeliveryCond cond);

    /**
     * 查询鲜花月送详情列表
     * @param cond
     * @return
     */
    Pagination<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDetailByCond(PcsFlowerDeliveryCond cond);

    /**
     * 查询最近4周可用日期及库存
     *
     * @param skuCode
     * @return
     */
    List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDate(String skuCode);

    /**
     * 查询是否有库存，有库存返回配送时间
     * @param queryDTO
     * @param date
     * @param channelCode
     * @return
     */
    PcsFlowerDeliveryDate getFlowerStockAndDate(SFlowerMonthlyQueryDTO queryDTO, Date date, String channelCode);

    /**
     * 查询包裹可选择预计发货日期
     *
     * @param packageId
     * @param salesOrderId
     * @return
     */
    List<String> getPackageDeliveryDate(Long packageId, Long salesOrderId);

    /**
     * 保存鲜花月送规则和新增配送周期
     *
     * @param cond
     * @return
     */
    boolean saveFlowerDelivery(PcsFlowerDeliveryCond cond);

    /**
     * 根据条件查询所有配方
     *
     * @param recipeId
     * @return
     */
    List<PcsFlowerRecipeSkuVO> getFlowerRecipeSkuByCond(Long recipeId);

    /**
     * 保存配方耗材
     *
     * @param pcsRecipeSkuVO
     * @return
     */
    boolean addFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO);

    /**
     * 更新配方耗材
     *
     * @param pcsRecipeSkuVO
     * @return
     */
    boolean updateFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO);

    /**
     * 耗材统计接口
     *
     * @param startDate
     * @param endDate
     * @return
     */
    List<PcsFlowerSkuStatisticsVO> requiredSuppliesStatistics(String startDate, String endDate);

    /**
     * 根据ID更新配送日期信息
     *
     * @param pcsFlowerDeliveryRecipe
     * @return
     */
    boolean updateFlowerRecipeById(PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe);

    public boolean updateFlowerDeliveryById(PcsFlowerDelivery pcsFlowerDelivery);

    public boolean updateFlowerDeliveryUseableById(PcsFlowerDelivery pcsFlowerDelivery);

    /**
     * 查询所有当可售数量小于安全库存
     *
     * @return
     */
    List<PcsFlowerMerchantibleVO> getFlowerSellNumber();

    void importFlowerRecipeMaterial(List<FlowerRecipeMaterialVO> list, String skuCode, int isCycle, String effectDate);

    /**
     * 月送鲜花完成状态自动转换
     */
    void flowerFinishStateChange();

    /**
     * 月送鲜花完成状态自动转换
     */
    void updateFlowerFinishStateChange();

    /**
     * 更新天猫计划数
     * @param cond
     * @return
     * @throws Exception
     */
    boolean updateTmallFlowerPlanQuantity(PcsFlowerRecipePlanCond cond) throws Exception;

    /**
     * 更新天猫后台库存
     * @param skuCode
     * @param prePlanNumber
     * @param afterPlanNumber
     * @param referenceCode
     * @param operatorId
     * @return
     * @throws Exception
     */
    Boolean updateTmallMthFlowerStock(String skuCode, int prePlanNumber, int afterPlanNumber, String referenceCode,Long operatorId) throws Exception;

    List<String> findPhyWhFlowerMonthyCapacitySeted(String skuCode);

    PageInfo findCapacityByCond(PcsFlowerDeliveryCapacityCond cond);

    Map<Class<?>, List<?>> findFlowerDeliverySaleInfo(Long deliveryRecipeId, String skuCode);

    int saveOrUpdate(List<PcsFlowerMonCapaSettingVO> records) throws Exception;

    /**
     * 产能设置操作日志
     *
     * @param skuCode
     * @return
     */
    List<PcsFlowerMonCapaLogVO> findPcsFlowerMonCapaLogBySkuCode(String skuCode);

    /**
     * 按城市统计产能，可售，任务数量
     *
     * @param cond
     * @return
     */
    List<PcsFlowerMonCapaSettingVO> findCityCapacityByCond(PcsFlowerDeliveryCapacityCond cond);

    /**
     * 保存产能修改日志
     *
     * @param logs
     * @return
     */
    int saveCapacityChangeLogs(List<PcsFlowerMonthlyCapacityLog> logs);

    /**
     * 根据 多组 （skuCode 和 物理仓 联合索引） 批量查询产能
     *
     * @param conds
     * @return
     */
    List<PcsFlowerMonCapaSettingVO> findCapacityByUniqueIndex(List<PcsFlowerDeliveryCapacityCond> conds);

    /**
     * 查询当前已有任务
     * @return
     */
    Map<String, Integer> findCurrentTaskQuntity(String skuCode, List<Integer> cityIds, SFlowerProductionTypeEnum productionTypeEnum);

    List<PcsFlowerMonCapaSettingVO> findAllWhCapacityDataBySkucode(String skuCode);

    Map<String, PcsFlowerDeliveryDate> getFlowerStockAndDate(List<SFlowerMonthlyQueryDTO> queryDTO, Date payTime, String channelCode);
}
