package com.thebeastshop.pegasus.service.purchase.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTag;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagField;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagEditVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;

public interface PcsCertificateTagService {
	
	/**
	 * 查询sku对应合格证标签信息
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public PcsCertificateTagEditVO getTagAndSkuBySkuCode(String skuCode);
	
	/**
	 * 查询合格证对应字段
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 * @return
	 */
	public List<PcsCertificateTagFieldValueVO> getTagFieldsSkuBySkuCode(String skuCode);
	
	/**
	 * 新建标签
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public int saveCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag);
	
	/**
	 * 更新标签状态
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void updateCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag);
	
	
	/**
	 * 新建标签
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void saveCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField);
	
	/**
	 * 更新标签状态
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void updateCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField);
	
	/**
	 * 删除标签状态
	 * @author jim.huang
	 * @date 2016年5月30日
	 * @param skuCode
	 */
	public void deleteCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField);

	/**
	 * 新增合格证
	 * @author yu.bao
	 * @date 2016年5月31日
	 * @param cond
	 * @return
	 */
	@Transactional
	public boolean addPcsCertificateTag(PcsCertificateTagVO vo);
	
	/**
	 * 更新合格证
	 * @author yu.bao
	 * @date 2016年5月31日
	 * @param cond
	 * @return
	 */
	@Transactional
	public boolean updatePcsCertificateTag(PcsCertificateTagVO vo);
	
	/**
	 * 批量新增合格证
	 * @author yu.bao
	 * @date 2016年5月31日
	 * @param cond
	 * @return
	 */
	@Transactional
	public boolean addPcsCertificateTag(List<PcsCertificateTagVO> vos);
	

	/**
	 * 按id  list  查询对应字段列表
	 * @param ids
	 * @return
	 */
	public List<PcsCertificateFieldVO> getTagFieldsSkuByIds(List<Integer> ids);

	/**
	 * 根据sku查询
	 * @author ztq
	 * @param tag
	 * @return List<PcsCertificateTag> 
	 */
	public PcsCertificateTagVO searchTagBySkuCode(PcsCertificateTag tag);
	
	/**
	 * 根据sku查询 合格证
	 * @author 
	 * @param skucodes
	 * @return List<PcsCertificateTag> 
	 */
	public List<PcsCertificateTagVO> getCertificateTagBySkuCodes(List<String> skuCode);
	
	/**
	 * 根据sku,barcode查询 合格证
	 * @author 
	 * @return List<PcsCertificateTag> 
	 */
	public List<PcsCertificateTagVO> getTagBySkuCodeBarCode(PrintCerVO cond);
}
