/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.merchandise.vo.PcsSkuAuditRecordsVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableAllot;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableImportLog;
import com.thebeastshop.pegasus.service.purchase.model.FpcsSkuOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.FpcsConsumableAllotSummaryVO;
import com.thebeastshop.pegasus.service.purchase.vo.FpcsConsumableAllotVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuProductVO;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author jim.huang
 * @version $Id: FpcsSkuService.java, v 0.1 2015-08-03 下午06:13
 */
public interface FpcsSkuService {

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsSkuVO buildFromModel(PcsSku record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
     FpcsSkuOrder bulidFromVO(FlowerSkuVO vo);

    /**
     * 创建花sku
     *
     * @param record
     * @return
     */
    Long create(FpcsSkuOrder record);

    /**
     * 批量创建SKU
     * @param list
     * @return
     */
    List<Long> createSkus(List<FpcsSkuOrder> list);

    /**
     * 更新sku
     *
     * @param record
     * @return
     */
    boolean update(FpcsSkuOrder record);

    /**
     * 根据主键查找sku
     *
     * @param id
     * @return
     */
    PcsSku findById(long id);

    /**
     * 根据CODE查找sku
     *
     * @param code
     * @return
     */
    PcsSkuVO findByCode(String code);

    /**
     * 根据参数查找sku
     * @param arg0
     * @return
     */
    List<PcsSkuVO> findByNameOrCode(String arg0);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCond(PcsSkuCond cond);

    /**
     * 是否可以更新售价
     *
     * @param code
     * @return
     */
    Boolean canUpdateSalesPrice(String code);

    /**
     * 售价变更审批
     *
     * @param code
     * @param isPass
     * @return
     */
    Boolean auditSkuSalesPriceChange(String code, Boolean isPass);

    /**
     * 根据skucode查找 审批中的售价变更记录
     *
     * @param code
     * @return
     */
    PcsSkuAuditRecordsVO findSkuSalesPriceChangeByCodeAndProcessing(String code);

    /**
     * 根据CODE集合查找sku
     *
     * @param codes
     * @return
     */
    List<PcsSku> findSkuByCodes(List<String> codes);

    /**
     * 转换sku
     *
     * @param sku
     * @param skuCustomMadeId
     * @return
     */
    Boolean convertSku(PcsSku sku, long skuCustomMadeId);


    List<PcsSkuVO> findByCodes(List<String> codes);

    /**
     * 所有SKU信息
     *
     * @return
     */
    List<PcsSkuInfoVO> allSkuInfo();
    
    /**
     * 所有鲜花SKU信息
     *
     * @return
     */
    List<FpcsSkuOrder> getAllFlowerSkuInfo();

    /**
     * 鲜花SKU信息
     *
     * @return
     */
    List<FpcsSkuOrder> getFlowerSkuInfo(Map<String, Object> params);
    
    /**
     * 获取所有sku信息列表
     * @author jim.huang
     * @date 2016年4月10日
     * @return List<FpcsSkuOrder>
     * @throws Exception
     */
    public List<FpcsSkuOrder> getFlowerSkuByCondition(Date time, String code) throws Exception;

    /**
     * 所有SKU信息
     *
     * @return
     */
    PcsSkuInfoVO findStockByCode(String skuCode);
    
    /**
     * 通过is查询sku信息
     * @author jim.huang
     * @date 2016年4月14日
     * @param id
     * @return
     */
    FpcsSkuOrder findSkuById(long id);
    
    /**
     * 导入耗材数据
     * @author jim.huang
     * @date 2016年4月14日
     * @param consumableAllotList
     * @return
     */
    int saveConsumableAllot(List<FpcsConsumableAllot> consumableAllotList);
    
    /**
     * 查询所有耗材
     * @author jim.huang
     * @date 2016年4月14日
     * @return
     */
    public List<FpcsConsumableAllotVO> getAllConsumableList(List<String> warehouseCodeList);


    /**
     * 根据sku查询product对应信息
     * @param skuCodes
     * @return
     */
    List<PcsSkuProductVO> findProductInfoBySkuCodes(List<String> skuCodes);

    /**
     * 根据sku查询包含的 list
     * @param skuCodes
     * @return
     */
    List<String> findProductCodesBySkuCodes(@Param("skuCodes") List<String> skuCodes);

    /**
     * 根据sku查询各个门店对应的耗材调拨数量
     * @param type(1,本月  2：上个月)
     * @param skuCode
     * @param warehouseCodeList（可为空）
     * @return
     */
    List<FpcsConsumableAllotSummaryVO> findApplySummaryBySku(Integer type, String skuCode, List<String> warehouseCodeList);

    /**
     * 查询上一次导入的耗材数据
     * @return
     */
    List<FpcsConsumableImportLog>  findLastImportLogs();

    /**
     * 保存上一次导入的耗材
     * @param importDatas
     * @return
     */
    List<Integer> saveLastImportLogs(List<FpcsConsumableImportLog> importDatas);

    FpcsConsumableAllot findFpcsConsumableAllotBySkuCode(String skuCode);
}
