package com.thebeastshop.pegasus.service.purchase.flower.vo;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import javax.validation.constraints.NotNull;

/**
 * 实际采购导入Excel模板 - Sheet：门店明细
 *
 * @author gongjun
 * @since  2016-04-11 15:30
 */
@ExcelTemplate
@ExcelSheet("门店明细")
public class FpcsChannelExcelVO {

    @ExcelColumn(name="门店")
    @NotNull
    private String channelName;

    @ExcelColumn(name="渠道编号")
    @NotNull
    private String channelCode;

    @ExcelColumn(name="渠道仓库号")
    @NotNull
    private String warehouseCode;

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }
}
