package com.thebeastshop.pegasus.service.purchase.flower.service.impl;

import com.thebeastshop.pegasus.service.purchase.flower.dao.FpcsActualPurchaseMapper;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsActualPurchaseService;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelItemVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualExcelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsChannelQuantity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-04-12 12:04
 */
@Service("fpcsActualPurchaseService")
public class FpcsActualPurchaseServiceImpl implements FpcsActualPurchaseService {

    @Autowired
    private FpcsActualPurchaseMapper fpcsActualPurchaseMapper;

    @Override
    public List<FpcsActualExcelVO> queryActualPurchaseList(Map<String, Object> params) {
        return fpcsActualPurchaseMapper.queryActualPurchaseList(params);
    }

    @Override
    public List<FpcsChannelQuantity> queryActualPruchaseChannelList(Map<String, Object> params) {
        return fpcsActualPurchaseMapper.queryActualPruchaseChannelList(params);
    }

    @Override
    public List<FpcsActualChannelVO> queryActualChannelList(Map<String, Object> params) {
        return fpcsActualPurchaseMapper.queryActualChannelList(params);
    }

    @Override
    public List<FpcsActualChannelItemVO> queryActualChannelItemList(Map<String, Object> params) {
        return fpcsActualPurchaseMapper.queryActualChannelItemList(params);
    }

    @Override
    public Long addActualPurchaseLog(FpcsActualExcelVO actualExcelVO) {
        return fpcsActualPurchaseMapper.addActualPurchaseLog(actualExcelVO);
    }

    @Override
    public Long addActualPurhcaseChannel(FpcsChannelQuantity channelQuantity) {
        return fpcsActualPurchaseMapper.addActualPurhcaseChannel(channelQuantity);
    }
}
