package com.thebeastshop.pegasus.service.purchase.enums;

/**
 * 采购单成本中心枚举
 * @author jim.huang
 */
public enum PurchaseOrderCostEnum {
	FLOWER(1,"鲜花"),
	FLORICULTURE(2,"永生花艺"),
	FRAGRANCE(3,"香氛"),
	COSMECEUTICALS(4,"药妆"),
	HOME_TEXTILES(5,"家纺"),
	MASION(6,"家饰"),
	KICCHEN_FOOD(7,"餐厨美食"),
	GENERAL_MERCHANDISE(8,"日用百货"),
	JEWELRY_ACCES(9,"珠宝配饰"),
	LEISURE_WEAR(10,"家居服"),
	QITA(11,"其他（婴童产品，宠物等）");
	
	private Integer key;
	
	private String value;

	private PurchaseOrderCostEnum(Integer key, String value) {
		this.key = key;
		this.value = value;
	}

	public Integer getKey() {
		return key;
	}

	public void setKey(Integer key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
	
	
	public static String getCategoryName(Integer key){
		if(key == null) return null;
		PurchaseOrderCostEnum[] values = PurchaseOrderCostEnum.values();
		for (PurchaseOrderCostEnum purchaseOrderCostEnum : values) {
			if(key.intValue() == purchaseOrderCostEnum.getKey()){
				return purchaseOrderCostEnum.value;
			}
		}

		return null;
	}
	
}
