package com.thebeastshop.pegasus.service.purchase.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 采购单 贸易形式
 * @author Gary
 *
 */
public enum PoTradeFormEnum {

	CROSSBORDER(4, "跨境"),
	EXPRESS(3, "快件"),
	OWN_IMPORTED(2, "自进口（大贸）"),
	GENERAL_TRADE(1, "一般贸易");


	private final Integer enumKey;
	private final String enumDesc;

	public static final List<PoTradeFormEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PoTradeFormEnum(final Integer enumKey, final String enumDesc) {
		this.enumKey = enumKey;
		this.enumDesc = enumDesc;
	}

	 // 普通方法
	 public final static String getDesc(Integer status) {
		  if (status == null) {
        return "";
			}
			for (PoTradeFormEnum c : ALL) {
					if (c.enumKey == status) {
							return c.enumDesc;
					}
			}
			return "";
	}

	public final static PoTradeFormEnum getInstance(int enumKey) {
		for (PoTradeFormEnum c : ALL) {
			if (c.enumKey == enumKey) {
				return c;
			}
		}
		return null;
	}

	public Integer getEnumKey() {
		return enumKey;
	}

	public String getEnumDesc() {
		return enumDesc;
	}
}
