package com.thebeastshop.pegasus.service.purchase.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * PO状态
 * Created by Gary on 2017/5/23.
 */
public enum  PoStatusEnum {

  PURCHASE_ORDER_STATUS_DRAFT(1, "草稿"),
  PURCHASE_ORDER_STATUS_WAITING_AUDIT(2, "待品类经理审批"),
  PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL(6, "待planning审批"),
  PURCHASE_ORDER_STATUS_REJECT(3, "驳回"),
  PURCHASE_ORDER_STATUS_WAITING_RECEIVE(11, "收货中"),
  PURCHASE_ORDER_STATUS_ALREADY_FINISH(12, "已完成"),
  PURCHASE_ORDER_STATUS_WAIT_RECEIVE(5, "待收货");

  private Integer key;

  private String value;

  PoStatusEnum(Integer key, String value) {
    this.key = key;
    this.value = value;
  }

  public final static List<Map<String, Object>> listMap() {
    List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
    for (PoStatusEnum poStatusEnum : PoStatusEnum.values()) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("key", poStatusEnum.key);
      map.put("value", poStatusEnum.value);
      listMap.add(map);
    }
    return listMap;
  }

  public final static String getValueDesc(Integer key) {
    if (key == null) {
      return "";
    }
    for (PoStatusEnum poStatusEnum : PoStatusEnum.values()) {
      if (poStatusEnum.key == key) {
        return poStatusEnum.value;
      }
    }
    return "";
  }



  public Integer getKey() {
    return key;
  }


  public String getValue() {
    return value;
  }

}
