package com.thebeastshop.pegasus.service.purchase.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 采购单用印进度
 * Created by Gary on 2018/11/7
 */
public enum PoPrintProgressEnum {

  NOT_START((short)0, "未开始"),
  CATEGORY_MANAGER((short)1, "品类经理"),
  FINANCE((short)2, "财务"),
  LEGAL((short)3, "法务"),
  FINISHED((short)8, "完成");

  private Short key;

  private String value;

  PoPrintProgressEnum(Short key, String value) {
    this.key = key;
    this.value = value;
  }

  public final static List<Map<String, Object>> listMapPrintProgress() {
    List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
    for (PoPrintProgressEnum poPrintProgressEnum : PoPrintProgressEnum.values()) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("key", poPrintProgressEnum.key);
      map.put("value", poPrintProgressEnum.value);
      list.add(map);
    }
    return list;
  }


  public final static  String getVal(Short key) {
    for (PoPrintProgressEnum poPrintProgressEnum : PoPrintProgressEnum.values()) {
      if (poPrintProgressEnum.key == key) {
        return poPrintProgressEnum.value;
      }
    }
    return "";
  }

  public Short getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

}
