package com.thebeastshop.pegasus.service.purchase.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * PO 物流单 状态
 * @author jim.huang
 */
public enum PoLogisticsEnum {

	WAITING_SUBMIT(0, "待提交"),
	PENDING(1, "待处理"),
	PROCESSING(2, "处理中"),
	COMPLETED(8, "已完成"),
	CANCLE(-1, "取消");

	private Integer key;

	private String value;

	PoLogisticsEnum(Integer key, String value) {
		this.key = key;
		this.value = value;
	}

	public Integer getKey() {
		return key;
	}

	public void setKey(Integer key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
	
	
	public static String getStatusName(Integer key){
		if(key == null) return null;
		PoLogisticsEnum[] values = PoLogisticsEnum.values();
		for (PoLogisticsEnum poLogisticsEunm : values) {
			if(key.intValue() == poLogisticsEunm.getKey()){
				return poLogisticsEunm.value;
			}
		}
		return "";
	}

	@JsonValue
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<>();
		map.put("key", getKey());
		map.put("value", getValue());
		return map;
	}

	public final static List<Map<Integer, Object>> listMap() {
	  List<Map<Integer, Object>> list = new ArrayList<Map<Integer, Object>>();
	  for (PoLogisticsEnum poLogisticsEunm : PoLogisticsEnum.values()) {
		  Map<Integer, Object> map = new HashMap<Integer, Object>();
		  map.put(poLogisticsEunm.key, poLogisticsEunm.value);
		  list.add(map);
	  }
	  return list;
	}
	
}
