package com.thebeastshop.pegasus.service.purchase.enums;

/**
 * 采购单财务付款 支付方式
 */
public enum PoFinancePaymentModeEnum {
	payment(1,"付款"),
    refund(2,"退款"),
	credit_note(3,"Credit Note抵扣"),
	by_po_code(4,"转PO单");

	private Integer key;

	private String value;

	private PoFinancePaymentModeEnum(Integer key, String value) {
		this.key = key;
		this.value = value;
	}

	public Integer getKey() {
		return key;
	}

	public void setKey(Integer key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public static String getPoFinancePaymentModeName(Integer key){
		if(key == null) return null;
		PoFinancePaymentModeEnum[] values = PoFinancePaymentModeEnum.values();
		for (PoFinancePaymentModeEnum poFinancePaymentModeEnum : values) {
			if(key.intValue() == poFinancePaymentModeEnum.getKey()){
				return poFinancePaymentModeEnum.value;
			}
		}
		return null;
	}
	
}
