package com.thebeastshop.pegasus.service.purchase.enums;

/**
 * 采购单 扩展的费用类型
 */
public enum PoCostTypeExtEnum {
    // 1模具费、2制版费、3运费、4其它 from [t_pcs_purchase_order_cost] cost_type
    // 因此扩展从5开始, 扩展费用当前只有”货款“，其它费用从POP中动态获取 from [t_pcs_po_plan_cost]
    payment_for_goods(5, "货款");
    /*ocean_freight(6, "海运费"),
    air_freight(7, "空运费"),
    customs_clearance_fee(8, "清关费"),
    tariff(9, "关税"),
    added_value_tax(10, "增值税"),
    consumption_tax(11, "消费税"),
    other_cost(99, "其它费用");
    */

	private Integer key;

	private String value;

	private PoCostTypeExtEnum(Integer key, String value) {
		this.key = key;
		this.value = value;
	}

	public Integer getKey() {
		return key;
	}

	public void setKey(Integer key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public static String getPoFinanceCostTypeExtName(Integer key){
		if(key == null) return null;
		PoCostTypeExtEnum[] values = PoCostTypeExtEnum.values();
		for (PoCostTypeExtEnum poFinanceCostTypeExtEnum : values) {
			if(key.intValue() == poFinanceCostTypeExtEnum.getKey()){
				return poFinanceCostTypeExtEnum.value;
			}
		}
		return null;
	}
	
}
