package com.thebeastshop.pegasus.service.purchase.dao;

import com.thebeastshop.pegasus.merchandise.vo.PcsTagVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.cond.PcsTagCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuTag;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuWatermark;
import com.thebeastshop.pegasus.service.purchase.model.ProdTag;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

/**
 * @author gongjun
 * @since 2016-05-09
 */
public interface PcsTagMapper {

    int insert(PcsTagVO tagVO);

    int update(PcsTagVO tagVO);

    PcsTagVO findById(Long id);

    int insertProdTag(ProdTag prodTag);
    
    int insertSkuTag(PcsSkuTag skuTag);

    int updateProdTag(ProdTag prodTag);
    
    int updateSkuTag(PcsSkuTag skuTag);

    int countOfProdTag(ProdTag prodTag);
    
    int countOfSkuTag(PcsSkuTag skuTag);

    int deleteProdTagByIds(Map<String, Object> params);
    
    int updateProdTagActiveByIds(Map<String, Object> params);

    List<ProdTag> queryToDeleteProdTagList(Map<String, Object> params);

    List<PcsTagVO> queryTagList(Map<String, Object> params);

    List<String> querySkuCodeListByTagId(Long id);

	List<ProdSkuVO> queryProdTagListByTagCode(@Param("cond") PcsTagCond cond);

	List<ProdSkuVO> queryProdSkuListByTagParams(Map<String, Object> params);
    
}
