package com.thebeastshop.pegasus.service.purchase.dao;

import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoProgressTrackingDetailVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoProgressTrackingVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.model.OpFinanceBudget;
import com.thebeastshop.pegasus.service.purchase.model.PcsCostAdjust;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrderExample;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;

@Repository
public interface PcsPurchaseOrderMapper {
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int countByExample(PcsPurchaseOrderExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int deleteByExample(PcsPurchaseOrderExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int deleteByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int insert(PcsPurchaseOrder record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int insertSelective(PcsPurchaseOrder record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    List<PcsPurchaseOrder> selectByExample(PcsPurchaseOrderExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    PcsPurchaseOrder selectByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int updateByExampleSelective(@Param("record") PcsPurchaseOrder record, @Param("example") PcsPurchaseOrderExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int updateByExample(@Param("record") PcsPurchaseOrder record, @Param("example") PcsPurchaseOrderExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int updateByPrimaryKeySelective(PcsPurchaseOrder record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_pcs_purchase_order
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    int updateByPrimaryKey(PcsPurchaseOrder record);

    // self

    /**
     * 根据主键查找vo
     *
     * @param id
     * @return
     */
    PcsPurchaseOrderVO findPoVOById(long id);

    PcsPurchaseOrderVO findPoVOByCode(@Param("poCode") String poCode);

    /**
     * 根据采购单出入库指令code查询采购单信息
     *
     * @param commandCode
     * @return
     */
    PcsPurchaseOrderVO findPurchaseOrderByCommandCode(@Param("commandCode")String commandCode);

    /**
     * 根据条件查找vos
     *
     * @param cond
     * @return
     */
    List<PcsPurchaseOrderVO> pageQueryPOByCond(@Param("cond") PcsPurchaseOrderCond cond, PageRowBounds rowBounds);

    List<Map<String, Integer>> countPoGroupByStatus(@Param("cond") PcsPurchaseOrderCond cond);

    List<PcsPurchaseOrderVO> findPOVOByCond(@Param("cond") PcsPurchaseOrderCond cond);

    /**
     * 根据条件查找采购单付款信息
     *
     * @param cond
     * @return
     */
    List<PcsPurchaseOrderVO> findPoFinaceVOByCond(@Param("cond") PcsPurchaseOrderCond cond);
    
    long countByCond(@Param("cond") PcsPurchaseOrderCond cond);

    /**
     * 获取warehouseCode集合
     *
     * @return
     */
    List<String> findWarehouseCodeGroup();
    List<PcsPurchaseOrderVO> findPoInfoByWarehouseCodeGroup();

    List<PcsPurchaseOrderVO> findPOVOBySupplierId(@Param("supplierId") Long supplierId);

    /**
     *（财务预算专用）根据参数查询采购成本明细
     * @param params
     * @return
     */
    List<PcsPoLineVO> findFinancePoLineVOByParams(Map<String,Object> params);

    /**
     * 获取采购单费用明细
     * @param id
     * @return
     */
    List<PcsPurchaseOrderVO> findPoCostById(@Param("id") Long id);

    /**
     * 采购单费用调整
     * @param pcsCostAdjust
     * @return
     */
    boolean addPoCost(@Param("adjustCost") PcsCostAdjust pcsCostAdjust);

    // 以下为财务预算相关
    /**
     * 查询预算
     * @param params
     * @return
     */
    List<OpFinanceBudget> findOpFinanceBudgetByParams(Map<String,Object> params);

    /**
     * 新增预算
     * @param budgets
     */
    void insertOpFinanceBudget(OpFinanceBudget budget);

    /**
     * 更新预算（释放预算）
     * @param budget
     */
    void updateOpFinanceBudget(OpFinanceBudget budget);

    int closePO();

    List<PcsPurchaseOrder> findNeedToClosedPO();

    /**
     * 根据skuCode查询最近的采购单 以便找到采购单预计到货日期
     * @param skuCodes
     */
    List<PcsPurchaseOrderVO> findNearestPurchaseOrderBySkuCodes(@Param("skuCodes") List<String> skuCodes);

    List<PcsPoProgressTrackingVO> pageQueryTrackingProgressByCond(@Param("cond") PcsPurchaseOrderCond cond, PageRowBounds rowBounds);

    List<PcsPoProgressTrackingDetailVO> queryTrackingProgressDetailByCond(@Param("cond") PcsPurchaseOrderCond cond, PageRowBounds pageRowBounds);

    List<PcsPoProgressTrackingDetailVO> querySkuFirstOrder(@Param("cond") PcsPurchaseOrderCond cond);

    int withdrawApproval(PcsPurchaseOrderVO purchaseOrder);
}