/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.cond;

import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

import java.io.Serializable;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PrdcRecipeCond.java, v 0.1 2015-12-31 下午1:51
 */
public class PrdcRecipeCond extends BaseQueryCond implements Serializable {

    public PrdcRecipeCond() {
        super();
    }

    /**
     * 配方主键
     */
    private Long recipeId;

    private List<Long> recipeIds;

    private List<String> skuCodes;

    /**
     * 配方名称
     */
    private String recipeName;

    /**
     * 配方状态
     */
    private Integer recipeStatus;

    /**
     * 配方成品sku
     */
    private String recipeSkuCode;

    private String skuCode;

    /**
     * 创建人id
     */
    private String createUserId;

    private Integer customization;

    /**
     * 配方耗材sku
     */
    private String recipeMaterialSkuCode;

    // 获取配方耗材
    private boolean fetchMaterial;
    // 获取配方成品SKU图片
    private boolean fetchSkuImg;

    // auto generate
    public Long getRecipeId() {
        return recipeId;
    }

    public void setRecipeId(Long recipeId) {
        this.recipeId = recipeId;
    }

    public String getRecipeName() {
        return recipeName;
    }

    public void setRecipeName(String recipeName) {
        this.recipeName = recipeName;
    }

    public Integer getRecipeStatus() {
        return recipeStatus;
    }

    public void setRecipeStatus(Integer recipeStatus) {
        this.recipeStatus = recipeStatus;
    }

    public String getRecipeSkuCode() {
        return recipeSkuCode;
    }

    public void setRecipeSkuCode(String recipeSkuCode) {
        this.recipeSkuCode = recipeSkuCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getRecipeMaterialSkuCode() {
        return recipeMaterialSkuCode;
    }

    public void setRecipeMaterialSkuCode(String recipeMaterialSkuCode) {
        this.recipeMaterialSkuCode = recipeMaterialSkuCode;
    }

    public boolean isFetchMaterial() {
        return fetchMaterial;
    }

    public void setFetchMaterial(boolean fetchMaterial) {
        this.fetchMaterial = fetchMaterial;
    }

    public boolean isFetchSkuImg() {
        return fetchSkuImg;
    }

    public void setFetchSkuImg(boolean fetchSkuImg) {
        this.fetchSkuImg = fetchSkuImg;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public Integer getCustomization() {
        return customization;
    }

    public void setCustomization(Integer customization) {
        this.customization = customization;
    }

    public List<Long> getRecipeIds() {
        return recipeIds;
    }

    public void setRecipeIds(List<Long> recipeIds) {
        this.recipeIds = recipeIds;
    }
}
