/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.cond;

import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

import java.io.Serializable;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderCond.java, v 0.1 2015-08-10 10:13
 */
public class PcsPurchaseOrderCond extends BaseQueryCond implements Serializable {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

    private Long id;

	// self
    /**
     * 采购单号
     */
    private String poCode;

    /**
     * 采购单状态
     */
    private Integer poStatus;
    
    /**
     * 财务状态
     */
    private Integer financeStatus;

    /**
     * 采购单状态集
     */
    private List<Integer> poStatuList;
    
    /**
     * 供应商名称
     */
    private String supplierName;

    private Long supplierId;

    /**
     * 目标仓库名称
     */
    private String warehouseName;

    /**
     * 目标仓库CODE
     */
    private String warehouseCode;

    /**
     * 目标物理仓库CODE
     */
    private String physicalWarehouseCode;



    /**
     * 操作员名称
     */
    private String operatorName;

    /**
     * sku
     */
    private String sku;

    /**
     * 创建起始时间
     */
    private String createTimeBegin;

    /**
     * 创建结束时间
     */
    private String createTimeEnd;
    
    /**
     * 收货计划编号
     */
    private String planCode;
    
    private Integer type;

    private List<Long> poIds;

    // 需要导出的报表id项
    private String ids;
    
    private String sortField = "a.ID";
    
    private String sortType = "desc";

    private Long createUserId;

    private String whetherConsignment;

    // 导出全部
    private Integer exportAll;

    //当前登录用户ID
    private Long currentLoginUserId;

    //1:审批查询，0：采购单查询
    private short searchType = 1;
    private Integer purchaseOrderCostCenter;//成本中心
    private String externalWarehouseNo ;//外部进仓编号
    /**
     * 审批起始时间
     */
    private String approvalTimeBegin;

    /**
     * 审批结束时间
     */
    private String approvalTimeEnd;
    //审批人名称
    private String approverName;
    private String brandName;

  /**
   * 采购员名称
   */
  private String buyerName;

    /**
     * 获取采购单附属信息
     */
    // t_pcs_purchase_order_cost
    private boolean fetchPoCost;

    // t_pcs_po_line
    private boolean fetchPoLine;
  //是否OEM查询
  private boolean oemQuery;


    // t_pcs_po_plan
    private boolean fetchPop;

    // t_pcs_po_plan_line
    private boolean fetchPopLine;

    // t_pcs_po_plan_cost
    private boolean fetchPopCost;

  public short getSearchType() {
    return searchType;
  }

  public void setSearchType(short searchType) {
    this.searchType = searchType;
  }

  public Long getCurrentLoginUserId() {
    return currentLoginUserId;
  }

  public void setCurrentLoginUserId(Long currentLoginUserId) {
    this.currentLoginUserId = currentLoginUserId;
  }

    public Long getCreateUserId() {
		return createUserId;
	}

	public void setCreateUserId(Long createUserId) {
		this.createUserId = createUserId;
	}

	public String getSortField() {
		return sortField;
	}

	public void setSortField(String sortField) {
		this.sortField = sortField;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getPlanCode() {
		return planCode;
	}

	public void setPlanCode(String planCode) {
		this.planCode = planCode;
	}

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    // auto generate
    public String getPoCode() {
        return poCode;
    }

    public void setPoCode(String poCode) {
        this.poCode = poCode;
    }

    public Integer getPoStatus() {
        return poStatus;
    }

    public void setPoStatus(Integer poStatus) {
        this.poStatus = poStatus;
    }
    
    public Integer getFinanceStatus() {
		return financeStatus;
	}

	public void setFinanceStatus(Integer financeStatus) {
		this.financeStatus = financeStatus;
	}

	public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getCreateTimeBegin() {
        return createTimeBegin;
    }

    public void setCreateTimeBegin(String createTimeBegin) {
        this.createTimeBegin = createTimeBegin;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public String getWhetherConsignment() {
        return whetherConsignment;
    }

    public void setWhetherConsignment(String whetherConsignment) {
        this.whetherConsignment = whetherConsignment;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public List<Integer> getPoStatuList() {
		return poStatuList;
	}

	public void setPoStatuList(List<Integer> poStatuList) {
		this.poStatuList = poStatuList;
	}

    public String getIds() { return ids; }

    public void setIds(String ids) { this.ids = ids; }

    public List<Long> getPoIds() {
        return poIds;
    }

    public void setPoIds(List<Long> poIds) {
        this.poIds = poIds;
    }

    public Integer getExportAll() {
        return exportAll;
    }

    public void setExportAll(Integer exportAll) {
        this.exportAll = exportAll;
    }

    public Integer getPurchaseOrderCostCenter() {
        return purchaseOrderCostCenter;
    }

    public void setPurchaseOrderCostCenter(Integer purchaseOrderCostCenter) {
        this.purchaseOrderCostCenter = purchaseOrderCostCenter;
    }

    public String getExternalWarehouseNo() {
        return externalWarehouseNo;
    }

    public void setExternalWarehouseNo(String externalWarehouseNo) {
        this.externalWarehouseNo = externalWarehouseNo;
    }

    public String getApprovalTimeBegin() {
        return approvalTimeBegin;
    }

    public void setApprovalTimeBegin(String approvalTimeBegin) {
        this.approvalTimeBegin = approvalTimeBegin;
    }

    public String getApprovalTimeEnd() {
        return approvalTimeEnd;
    }

    public void setApprovalTimeEnd(String approvalTimeEnd) {
        this.approvalTimeEnd = approvalTimeEnd;
    }

    public String getApproverName() {
        return approverName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getBuyerName() {
    return buyerName;
  }

    public void setBuyerName(String buyerName) {
    this.buyerName = buyerName;
  }

    public boolean isFetchPoCost() {
        return fetchPoCost;
    }

    public void setFetchPoCost(boolean fetchPoCost) {
        this.fetchPoCost = fetchPoCost;
    }

    public boolean isFetchPoLine() {
        return fetchPoLine;
    }

    public void setFetchPoLine(boolean fetchPoLine) {
        this.fetchPoLine = fetchPoLine;
    }

    public boolean isFetchPop() {
        return fetchPop;
    }

    public void setFetchPop(boolean fetchPop) {
        this.fetchPop = fetchPop;
    }

    public boolean isFetchPopLine() {
        return fetchPopLine;
    }

    public void setFetchPopLine(boolean fetchPopLine) {
        this.fetchPopLine = fetchPopLine;
    }

    public boolean isFetchPopCost() {
        return fetchPopCost;
    }

    public void setFetchPopCost(boolean fetchPopCost) {
        this.fetchPopCost = fetchPopCost;
    }

  public boolean isOemQuery() {
    return oemQuery;
  }

  public void setOemQuery(boolean oemQuery) {
    this.oemQuery = oemQuery;
  }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
