/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase;


import com.github.pagehelper.PageInfo;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailAttachmentVO;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.*;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsOrderListForm;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsActualPurchaseService;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelItemVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualExcelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsChannelQuantity;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.*;
import com.thebeastshop.pegasus.service.purchase.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.importExcel.AdvancedParseExcelComponent;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.util.model.*;
import com.thebeastshop.pegasus.util.vo.CommDictionaryVO;
import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.wms.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Royan
 * @version $Id: PegasusPurchaseServiceFacade.java, v 0.1 2015-07-01 下午3:00
 */
public class PegasusPurchaseServiceFacade {

    private final static Logger log = LoggerFactory.getLogger(PegasusPurchaseServiceFacade.class);

    private static PegasusPurchaseServiceFacade instance;

    @Autowired
    private PcsClPsService pcsClPsService;

    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;

    @Autowired
    private PcsPoLineService pcsPoLineService;

    @Autowired
    private PcsPoPlanService pcsPoPlanService;

    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;

    @Autowired
    private PrdcRecipeService prdcRecipeService;

    @Autowired
    private PrdcRecipeSkuService prdcRecipeSkuService;

    @Autowired
    private PrdcJobService prdcJobService;

    @Autowired
    private PrdcJobLineService prdcJobLineService;

    @Autowired
    private FpcsPurchaseOrderService fpcsPurchaseOrderService;

    @Autowired
    private FpcsSkuService fpcsSkuService;

    @Autowired
    private FpcsActualPurchaseService fpcsActualPurchaseService;

    @Autowired
    private PcsCategoryCostCenterService pcsCategoryCostCenterService;

    @Autowired
    private PcsCertificateFieldService pcsCertificateFieldService;

    @Autowired
    private PcsCertificateTplService pcsCertificateTplService;

    @Autowired
    private PcsCertificateTplFieldService pcsCertificateTplFieldService;

    @Autowired
    private PcsSkuCertificateService pcsSkuCertificateService;

    @Autowired
    private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;

    //    @Autowired
    private AdvancedParseExcelComponent advancedParseExcelComponent;

    @Autowired
    private PcsCertificateTagService pcsCertificateTagService;

    @Autowired
    private PcsFinancePaymentService pcsFinancePaymentService;

    @Autowired
    private PcsCostCenterService pcsCostCenterService;

    @Autowired
    private PcsFlowerDeliveryService pcsFlowerDeliveryService;

    @Autowired
    private McPcsSkuService mcPcsSkuService;

    @Autowired
    private PcsCronService pcsCronService;

    @Autowired
    private PcsSkuCustomBckService pcsSkuCustomBckService;

    @Autowired
    private PcsSkuAutoApproveRuleService pcsSkuAutoApproveRuleService;

    @Autowired
    private PcsBaseTaxRateService pcsBaseTaxRateService;
    @Autowired
    private PcsPoLogisticsBillService pcsPoLogisticsBillService;
    @Autowired
    private PcsPurchaseFlowerService pcsPurchaseFlowerService;
    @Autowired
    private PurchaseFlowerPlanService purchaseFlowerPlanService;

    @Autowired
    private PcsPurchaseFlowerSupplierService pcsPurchaseFlowerSupplierService;

    @Autowired
    private PurchaseFlowerReceiveOrderService purchaseFlowerReceiveOrderService;

    @Autowired
    private PcsPurchaseFlowerAchievementService pcsPurchaseFlowerAchievementService;

    PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    private PegasusPurchaseServiceFacade() {

    }

    public static PegasusPurchaseServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusPurchaseServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-purchase/spring.xml");
                log.info("[fasade init finish] PegasusPurchaseServiceFacade");
            }
            instance = (PegasusPurchaseServiceFacade) SpringUtil.getBean("pegasusPurchaseServiceFacade");
        }
        return instance;
    }
    public PcsSkuVO fingPcsSkuByCode(String code){
        return  mcPcsSkuService.findByCode(code);
    }

    public static <T> T getBean(Class<T> requiredType) {
    	return SpringUtil.getBean(requiredType);
    }

    public AdvancedParseExcelComponent getAdvancedParseExcelComponent() {
        return advancedParseExcelComponent;
    }


    public Long addPcsPoCreditNoteVO(PcsPoCreditNoteVO vo){
        return pcsPurchaseOrderService.addPcsPoCreditNoteVO(vo);
    }
    public  void deletePcsPoCreditNoteVO(PcsPoCreditNoteVO vo) {
        pcsPurchaseOrderService.deletePcsPoCreditNoteVO(vo);
    }
    /**
     * 批量导入花SKU
     * @param list
     * @return
     */
    public List<Long> createFlowerSkus(List<FlowerSkuVO> list){
        List<FpcsSkuOrder> skuList = new ArrayList<>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return fpcsSkuService.createSkus(skuList);
    }

    /**
     * 批量插入耗材
     * @author jim.huang
     * @date 2016年4月13日
     * @param list
     * @return
     */
    public List<Long> createConsumableSkus(List<FlowerSkuVO> list){
        List<FpcsSkuOrder> skuList = new ArrayList<>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return fpcsSkuService.createSkus(skuList);
    }



    /**
     * 查找当前最大ID
     *
     * @return
     */
    public Long findPcsClPsMaxId() {
        return pcsClPsService.findMaxId();
    }

    /**
     * 添加
     * @param pcsClPs
     * @return
     */
    public int addClPs(PcsClPs pcsClPs) {
        return pcsClPsService.add(pcsClPs);
    }


    /**
     * 把 <= maxId 的数据 group by code,change_source
     *
     * @param maxId
     * @return
     */
    public List<PcsClPs> findPcsClPsByMaxId(Long maxId) {
        return pcsClPsService.findByMaxId(maxId);
    }

    /**
     * 清空 <= maxId
     *
     * @param maxId
     * @return
     */
    public boolean deletePcsClPsByMaxId(Long maxId) {
        return pcsClPsService.deleteByMaxId(maxId);
    }


    /**
     * 创建采购单包括行信息
     *
     * @param pcsPurchaseOrderVO
     * @return
     */
    public Long createPurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        /*
        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.buildFromVO(pcsPurchaseOrderVO);
        List<PcsPoLine> pcsPoLineList = new ArrayList<PcsPoLine>();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        Long id = pcsPurchaseOrderService.createPurchaseOrderAndLine(pcsPurchaseOrder, pcsPoLineList, pcsPurchaseOrderVO.isSaveDraft(),
                pcsPurchaseOrderVO.getOrderCostList());*/

        Long id = pcsPurchaseOrderService.createPurchaseOrderAndLine(pcsPurchaseOrderVO);
        pcsPurchaseOrderVO.setId(id);
        return id;
    }


    public void checkPurchaseOrderBeforeEdit(PcsPurchaseOrderVO editVO){
        pcsPurchaseOrderService.checkPurchaseOrderBeforeEdit(editVO);
    }

    public PcsPoFieldEditableInfoVO buildPoFieldEditableInfo(PcsPurchaseOrderVO info){
        return pcsPurchaseOrderService.buildPoFieldEditableInfo(info);
    }

    /**
     * 更新采购单包括行信息
     *
     * @param pcsPurchaseOrderVO
     * @return
     */
    public Boolean updatePurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        //PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.buildFromVO(pcsPurchaseOrderVO);
        List<PcsPoLine> pcsPoLineList = new ArrayList<PcsPoLine>();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        return pcsPurchaseOrderService.updatePurchaseOrderAndLine(pcsPoLineList,pcsPurchaseOrderVO);
    }
    /**
     * 更新采购单
     *
     * @param pcsPurchaseOrderVO
     * @return
     */
    public Boolean updatePurchaseOrder(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
    	PcsPurchaseOrder pcsPurchaseOrder = new PcsPurchaseOrder();
    	BeanUtils.copyProperties(pcsPurchaseOrderVO, pcsPurchaseOrder);
    	return pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }

    /**
     * 更新采购单
     *
     * @param pcsPurchaseOrder
     * @return
     */
    public Boolean updatePurchaseOrder(PcsPurchaseOrder pcsPurchaseOrder) {
    	return pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }

    /**
     * 根据主键查找采购单
     *
     * @param id
     * @return
     */
    public PcsPurchaseOrderVO findPoVOById(long id) {
        return pcsPurchaseOrderService.findPoVOById(id);
    }

    public PcsPurchaseOrderVO findPoVOByCode(String code) {
        return pcsPurchaseOrderService.findPoVOByCode(code);
    }

    public PcsPurchaseOrder findPoByPoCode(String poCode) {
        return pcsPurchaseOrderService.findPoByCode(poCode);
    }

    /**
     * 根据主键查找采购单
     *
     * @param commandCode
     * @return
     */
    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
        return pcsPurchaseOrderService.findPurchaseOrderByCommandCode(commandCode);
    }


    /**
     * 根据采购单号查找行信息
     *
     * @param poId
     * @return
     */
    public List<PcsPoLineVO> findPoLineVOByPoId(long poId) {
        return pcsPoLineService.findPoLineVOByPoId(poId);
    }

   public List<PcsPoLineVO> findPoLineVOByPoIdForExcel(long poId) {
        return pcsPoLineService.findPoLineVOByPoIdForExcel(poId);
    }
    /**
     * 根据采购单行ID查找行信息
     *
     * @param id
     * @return
     */
    public List<PcsPoLineVO> findPoLineVOById(long id) {
        return pcsPoLineService.findPoLineVOById(id);
    }

    /**
     * 查询关联的包裹
     *
     * @param pcsPpLinevo
     * @return
     */
    public List<PcsPoLineVO> findPackageNumBySku(PcsPoLineVO pcsPpLinevo) {
        return pcsPoLineService.findPackageNumBySku(pcsPpLinevo);
    }

    /**
     * 查询需要自动调拨的收货计划
     *
     * @param pcsPoPlan
     * @return
     */
    public List<PcsPoLineVO> findAutomaticTransferAllot(PcsPoPlan pcsPoPlan) {
        return pcsPoLineService.findAutomaticTransferAllot(pcsPoPlan);
    }

    /**
     * 查询采购单收货计划
     * @param poId
     * @return
     */
    public List<PcsPoLineVO> findPoSkuByPoId(long poId) {
    	return pcsPoLineService.findPoSkuByPoId(poId);
    }

    /**
     * 根据条件查找采购单
     *
     * @param cond
     * @return
     */
    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderService.findPOVOByCond(cond);
    }

    public PageInfo<PcsPurchaseOrderVO> pageQueryPOByCond(PcsPurchaseOrderCond cond) {
      return pcsPurchaseOrderService.pageQueryPOByCond(cond);
    }

    public Map<String,Integer> countPoGroupByStatus(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderService.countPoGroupByStatus(cond);
    }

    /**
     * 根据参数查询（财务预算）采购成本明细
     * @param params
     * @return
     */
    public List<PcsPoLineVO> findFinancePoLineVOByParams(Map<String,Object> params){
    	return pcsPurchaseOrderService.findFinancePoLineVOByParams(params);
    }

    /**
     * 关闭采购单,将状态置为已完成
     *
     * @param id
     * @return
     */
    public Boolean closePurchaseOrder(long id) {
        return pcsPurchaseOrderService.closePurchaseOrder(id);
    }

    /**
     * 获取t_pcs_purchase_order表的warehouseCode group
     *
     * @return
     */
    public List<String> findWarehouseCodeGroupFromPurchaseOrder() {
        return pcsPurchaseOrderService.findWarehouseCodeGroup();
    }

    public List<PcsPurchaseOrderVO> findPoInfoByWarehouseCodeGroup() {
        return pcsPurchaseOrderService.findPoInfoByWarehouseCodeGroup();
    }

    /**
     * 审核采购单
     *
     * @param id
     * @param isPass
     * @return
     */
    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        return pcsPurchaseOrderService.auditPurchaseOrder(id, isPass, type);
    }
    
    /**
     * 新增收货计划
     *
     * @param pcsPoPlanVO
     * @return
     * @throws Exception 
     */
    public PcsPoPlanVO createPoPlanAndLine(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        List<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList<PcsPoPlanLine>();
        excludeZeroLine(pcsPoPlanVO);
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        boolean result = pcsPoPlanService.createPoPlanAndLine(pcsPoPlan, pcsPoPlanLineList);
        if(result){
            pcsPoPlanVO.setId(pcsPoPlan.getId());
            pcsPoPlanVO.setCode(pcsPoPlan.getCode());
            if(EmptyUtil.isNotEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())){
                for(PcsPoPlanLineVO poPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()){
                    for (PcsPoPlanLine poPlanLine : pcsPoPlanLineList){
                        if(poPlanLine.getSkuCode().equals(poPlanLineVO.getSkuCode())){
                            poPlanLineVO.setId(poPlanLine.getId());
                            break;
                        }
                    }
                }
            }
        }
        return pcsPoPlanVO;
    }

    private void excludeZeroLine(PcsPoPlanVO pcsPoPlanVO) {
      List<PcsPoPlanLineVO> pcsPoPlanLineVOList = pcsPoPlanVO.getPcsPoPlanLineVOList();
      List<PcsPoPlanLineVO> newPcsPoPlanLineVOList = new ArrayList<PcsPoPlanLineVO>();
      for (PcsPoPlanLineVO planLineVO : pcsPoPlanLineVOList) {
        if (planLineVO.getQpb() > 0) {
          newPcsPoPlanLineVOList.add(planLineVO);
        }
      }
      pcsPoPlanVO.setPcsPoPlanLineVOList(newPcsPoPlanLineVOList);
    }
  /**
     * 新增收货计划并自动完成
     *
     * @param pcsPoPlanVO
     * @return
     * @throws Exception 
     */
    public Boolean createPoPlanAndLineThenFinish(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        List<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList<PcsPoPlanLine>();
        excludeZeroLine(pcsPoPlanVO);
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        return pcsPoPlanService.createPoPlanAndLineThenFinish(pcsPoPlan, pcsPoPlanLineList);
    }

    /**
     * 根据采购单号查询所有收货计划
     *
     * @param poId
     * @return
     */
    public List<PcsPoPlanVO> findPcsPoPlanVOByPoId(long poId) {
        List<PcsPoPlan> recordList = pcsPoPlanService.findPcsPoPlanByPoId(poId);
        List<PcsPoPlanVO> vos = new ArrayList<PcsPoPlanVO>(recordList.size());
        for (PcsPoPlan record : recordList) {
            PcsPoPlanVO vo = pcsPoPlanService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsPoPlanVO> findPopVOsByCond(PcsPoPlanCond cond) {
        return pcsPoPlanService.findPopVOsByCond(cond);
    }

    /**
     * 根据采购单号查询所有收货计划
     *
     * @return
     */
    public List<PcsPoPlanVO> findPcsPoPlanVOByPoIds(List<Long> poIds,boolean cascade) {
        return pcsPoPlanService.findPcsPoPlanByPoIds(poIds,cascade);
    }

    public List<PcsPoPlan> findPcsPoPlanByCond(PcsPoPlanCond cond) {
        return pcsPoPlanService.findPcsPoPlanByCond(cond);
    }

    /**
     * 更新收货计划的收货时间
     * @param id
     * @param date
     * @return
     */
    public boolean updatePcsPoPlanById(long id, String date){
        return pcsPoPlanService.updatePcsPoPlanById(id, date);
    }

    public boolean updatePcsPoPlanByPrimaryKey(PcsPoPlan pcsPoPlan){
        return pcsPoPlanService.updatePcsPoPlanByPrimaryKey(pcsPoPlan);
    }

    public boolean updatePcsPoPlanLineByPrimaryKey(PcsPoPlanLineVO pcsPoPlanLineVO){
    	PcsPoPlanLine pcsPoPlanLine = pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
        return pcsPoPlanLineService.update(pcsPoPlanLine);
    }

    public boolean updatePcsPoPlanVO(PcsPoPlanVO pcsPoPlanVO){
        boolean result = this.updatePcsPoPlanByPrimaryKey(BeanUtil.buildFrom(pcsPoPlanVO, PcsPoPlan.class));
        if (result && CollectionUtils.isNotEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())){
            pcsPoPlanVO.getPcsPoPlanLineVOList().forEach(popLine -> {
                this.updatePcsPoPlanLineByPrimaryKey(popLine);
            });
        }
        return true;
    }

    public boolean updatePcsPoPlanVOs(List<PcsPoPlanVO> pcsPoPlanVOs){
        for (PcsPoPlanVO poPlanVO : pcsPoPlanVOs){
            if (EmptyUtil.isNotEmpty(poPlanVO.getBillOfLading())){
                PcsPoPlan poPlan = new PcsPoPlan();
                poPlan.setId(poPlanVO.getId());
                poPlan.setBillOfLading(poPlanVO.getBillOfLading());

                // 用于记录提单号修改日志
                PcsPoPlan oldPop = findPcsPoPlanById(poPlanVO.getId());
                if (!poPlanVO.getBillOfLading().equals(oldPop.getBillOfLading())){
                    poPlanVO.setOldBillOfLading(oldPop.getBillOfLading());
                    // 更新提单号
                    updatePcsPoPlanByPrimaryKey(poPlan);
                }else{
                    // 提单号相等，无需更新数据，相应的日志也无需记录
                    poPlanVO.setBillOfLading(null);
                }
                batchCreatePoPlanFee(poPlanVO.getPcsPoPlanCosts());
            }else{
                batchCreatePoPlanFee(poPlanVO.getPcsPoPlanCosts());
            }
        }
        return true;
    }

    /**
     * 更新收货计划行的分货标识
     * @param id
     * @param sign
     * @return
     */
    public boolean updatePcsPoPlanLineById(long id, Integer sign){
        return pcsPoPlanService.updatePcsPoPlanLineById(id, sign);
    }

    /**
     * 更新加工单分货标识
     * @param id
     * @param sign
     * @return
     */
    public boolean updatePrdcJobById(long id, Integer sign){
        return pcsPoPlanService.updatePrdcJobById(id, sign);
    }

    /**
     * 删除采购单行信息
     *
     * @param poId
     * @param pcsPoLineId
     * @return
     */
    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        return pcsPurchaseOrderService.deletePcsPoLine(poId, pcsPoLineId);
    }

    /**
     * 批量更新采购单行信息
     * @param pcsPoLineVOs
     * @return
     */
    public Boolean batchUpdatePcsPoLine(PcsPurchaseOrderVO pcsPoLineVOs,Long operatorId) {
        return pcsPurchaseOrderService.batchUpdatePcsPoLine(pcsPoLineVOs,operatorId);
    }

    /**
     * 更新采购单行信息
     * @param pcsPoPlanLine
     * @return
     */
    public Boolean update(PcsPoPlanLine pcsPoPlanLine) {
        return pcsPoPlanLineService.update(pcsPoPlanLine);
    }

    /**
     * 根据收货计划ID查找行信息
     *
     * @param poPlanId
     * @return
     */
    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId) {
        return pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlanId);
    }

    public Pagination<PcsPoPlanLineVO> pagePcsPoPlanLineVOByCond(PcsPoPlanLineCond cond) {
        return pcsPoPlanLineService.pagePcsPoPlanLineVOByCond(cond);
    }

    public List<PcsPoPlanLineVO> listPcsPoPlanLineVOByCond(PcsPoPlanLineCond cond) {
        return pcsPoPlanLineService.listPcsPoPlanLineVOByCond(cond);
    }

    /**
     * 查找PoPlanLine行需要自动分拨的POP
     *
     * @return
     */
    public List<PcsPoPlanLineVO> findPoPlanLineVO() {
        return pcsPoPlanLineService.findPoPlanLineVO(true);
    }

    /**
     * 查找PrdcJob需要自动分拨的PJ
     *
     * @return
     */
    public List<PrdcJobVO> findPrdcJobVO() {
        return prdcJobService.findPrdcJobVO(true);
    }

    /**
     * 创建配方
     *
     * @param vo
     * @return
     */
    public Long createRecipe(PrdcRecipeVO vo){
        return prdcRecipeService.create(vo);
    }

    /**
     * 更新配方
     * @param vo
     * @return
     */
    public Boolean updateRecipe(PrdcRecipeVO vo){
        return prdcRecipeService.update(vo);
    }
    /**
     * 更新配方基本信息
     * @param vo
     * @return
     */
    public Boolean updateRecipeHour(PrdcRecipeVO vo){
        return prdcRecipeService.updateRecipeHour(vo);
    }

    /**
     * 根据主键查找配方
     * @param id
     * @return
     */
    public PrdcRecipeVO findRecipeVOById(Long id){
        return prdcRecipeService.findRecipeVOById(id);
    }

    /**
     * 根据条件查找配方
     * @param cond 条件
     * @param cascade 是否级联
     * @return
     */
    public List<PrdcRecipeVO> findRecipeVOByCond(PrdcRecipeCond cond,Boolean cascade){
        return prdcRecipeService.findRecipeVOByCond(cond, cascade);
    }

    public List<PrdcRecipeVO> findRecipeVOByCond(String skuCode,Boolean cascade){
        return prdcRecipeService.findRecipeVOBySkuCode(skuCode, cascade);
    }

    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOBySkuCode(String skuCode, Boolean cascade){
        return prdcRecipeService.findRecipeMaterialVOBySkuCode(skuCode, cascade);
    }

    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOByCond(PrdcRecipeMaterialCond cond, Boolean cascade){
        return prdcRecipeService.findRecipeMaterialVOByCond(cond, cascade);
    }

    /**
     * 删除配方行数据
     * @param recipeId
     * @param recipeMaterialId
     * @return
     */
    public Boolean deleteRecipeMaterial(Long recipeId,Long recipeMaterialId){
        return prdcRecipeService.deleteRecipeMaterial(recipeId, recipeMaterialId);
    }

    /**
     * 创建配方成品SKU图片
     *
     * @param vo
     * @return
     */
    public Long createRecipeSku(PrdcRecipeSkuVO vo){
        return prdcRecipeSkuService.create(vo);
    }

    /**
     * 更新配方成品SKU图片
     * @param vo
     * @return
     */
    public Boolean updateRecipeSku(PrdcRecipeSkuVO vo){
        return prdcRecipeSkuService.update(vo);
    }

    /**
     * 根据主键查找配方成品SKU图片
     * @param id
     * @return
     */
    public PrdcRecipeSkuVO findRecipeSkuVOById(Long id){
        return prdcRecipeSkuService.findRecipeSkuVOById(id);
    }

    /**
     * 根据条件查找配方成品SKU图片
     * @param cond 条件
     * @return
     */
    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(PrdcRecipeSkuCond cond){
        return prdcRecipeSkuService.findRecipeSkuVOByCond(cond);
    }

    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(String skuCode,Long recipeId){
        return prdcRecipeSkuService.findRecipeSkuVOByCond(skuCode,recipeId);
    }

    /**
     * 删除配方成品SKU图片数据
     * @param skuCode
     * @param recipeId
     * @return
     */
    public Boolean deleteRecipeSku(String skuCode,Long recipeId){
        return prdcRecipeSkuService.deleteRecipeSku(skuCode, recipeId);
    }

    public Boolean deleteRecipeSku(Long id){
        return prdcRecipeSkuService.deleteRecipeSku(id);
    }

    /**
     * 创建任务
     *
     * @param vo
     * @return
     */
    public Long createJob(PrdcJobVO vo){
        return prdcJobService.create(vo);
    }
    public Long createPrdcPreJob(PrdcPreJob vo){
        return prdcJobService.createPrdcPreJob(vo);
    }
    public Integer updatePrdcPreJobByKey(PrdcPreJob prdcPreJob){
        return prdcJobService.updatePrdcPreJobByKey(prdcPreJob);
    }
    /**
     * 批量创建人物
     * @param list
     * @return
     */
    public List<Long> batchCreate(List<PrdcJobVO> list) {
    	return prdcJobService.batchCreate(list);
    }

    /**
     * 批量创建人物
     * @param list
     * @return
     */
    public List<Long> batchCreateForCustomization(List<PrdcJobVO> list,String allotCode) {
        if(EmptyUtil.isNotEmpty(list)){
            List<String> skuCodes = new ArrayList<>();
            for(PrdcJobVO jobVO : list){
                if(EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())){
                    skuCodes.add(jobVO.getSkuCode());
                }
            }
            Map<String,PrdcRecipeVO> recipeVOMap = getRecipeMap(skuCodes);
            for(PrdcJobVO jobVO : list){
                if(EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())){
                    PrdcRecipeVO recipeVO = recipeVOMap.get(jobVO.getSkuCode());
                    if(NullUtil.isNull(recipeVO)){
                        throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,String.format("[%s]配方不存在",jobVO.getSkuCode()));
                    }
                    prdcJobService.bulidJobLine(jobVO,recipeVO);
                }
            }
        }
        return prdcJobService.batchCreate(list,allotCode);
    }

    //整托商品到店自动拆分 生成加工单
    public List<Long> batchCreateForCustomizationForKafka(List<PrdcJobVO> list) throws Exception {
        if(EmptyUtil.isNotEmpty(list)){
            List<String> skuCodes = new ArrayList<>();
            for(PrdcJobVO jobVO : list){
                if(EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())){
                    skuCodes.add(jobVO.getSkuCode());
                }
            }
            Map<String,PrdcRecipeVO> recipeVOMap = getRecipeMap(skuCodes);
            for(PrdcJobVO jobVO : list){
                if(EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())){
                    PrdcRecipeVO recipeVO = recipeVOMap.get(jobVO.getSkuCode());
                    if(NullUtil.isNull(recipeVO)){
                        throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING,String.format("[%s]配方不存在",jobVO.getSkuCode()));
                    }
                    prdcJobService.bulidJobLine(jobVO,recipeVO);
                }
            }
        }
        return prdcJobService.batchCreateAndFinishForKafka(list);
    }


    public boolean createAllotOrPrdcJob(List<WhPackageInvVO> packageInvList) throws Exception{
        final List<PrdcJobVO> jobList = new ArrayList<>();
        final List<WhAllotRcdVO> allotList = new ArrayList<>();
        prdcJobService.buildAllotOrPrdcJob(packageInvList,jobList,allotList);
        try{
            return prdcJobService.batchCreatePrdcJobOrAllot(jobList,allotList);
        }catch (Exception e){
            if(e instanceof RuntimeException){
                RuntimeException re = (RuntimeException)e;
                if(EmptyUtil.isNotEmpty(re.getMessage()) && re.getMessage().contains("库存不足")){
                    //库存不足,发送通知邮件re
                    prdcJobService.sendCusShortMailEmail(packageInvList,re.getMessage());
                }
            }
            throw e;
        }
    }

    public Map<String,PrdcRecipeVO> getRecipeMap(List<String> skuCodes){
        Map<String,PrdcRecipeVO> recipeVOMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(skuCodes)){
            PrdcRecipeCond cond = new PrdcRecipeCond();
            cond.setSkuCodes(skuCodes);
            List<PrdcRecipeVO> recipeVOList = prdcRecipeService.findRecipeVOByCond(cond,true);
            if(EmptyUtil.isNotEmpty(recipeVOList)){
                for(PrdcRecipeVO recipeVO : recipeVOList){
                    recipeVOMap.put(recipeVO.getSkuCode(),recipeVO);
                }
            }
        }
        return recipeVOMap;
    }
    /**
     * 退回修改任务
     *
     * @param vo
     * @return
     */
    public Boolean returnModifyJob(PrdcJobVO vo){
        return prdcJobService.returnModify(vo);
    }

    /**
     * 根据主键查找任务
     * @param id
     * @return
     */
    public PrdcJobVO findJobVOById(Long id){
        return prdcJobService.findJobVOById(id);
    }
    /**
     * 根据jobCode查找任务
     * @param code
     * @return
     */
    public PrdcJobVO findJobVOByCode(String code) {
        return prdcJobService.findJobVOByCode(code);
    }

    public Map<String, WhRecipeInvVO> caculateRecipeAmountForAssemble(List<String> skuCodes, String warehouseCode){
        return prdcJobService.caculateRecipeAmountForAssemble(skuCodes,warehouseCode);
    }

    /**
     * 根据条件查找任务
     * @param cond 条件
     * @param cascade 是否级联
     * @return
     */
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond,Boolean cascade){
        return prdcJobService.findJobVOByCond(cond, cascade);
    }

    public Pagination<PrdcJobVO> findJobVOByCondPage(PrdcJobCond cond){
        return prdcJobService.findJobVOByCondPage(cond);
    }

    public PrdcJobCountInfo countPrdcJobByCond(PrdcJobCond cond){
        return prdcJobService.countPrdcJobByCond(cond);
    }

    public List<PrdcPreJobVO> findPreJobListByCond(PrdcJobCond cond){
        return prdcJobService.findPreJobListByCond(cond);
    }
    public List<PrdcPreJobLineVO> findPreJobListListByPreJobId(Long preJobId){
        return prdcJobService.findPreJobListListByPreJobId(preJobId);
    }
    public List<PrdcPreJobDownloadVO> findPreJobDownListByCond(PrdcJobCond cond){
        return prdcJobService.findPreJobDownListByCond(cond);
    }
    public Long processPrdcPreJob(PrdcPreJobVO vo){
        return prdcJobService.processPrdcPreJob(vo);
    }
    /**
     * 根据条件查找任务(查询优化)
     * @param cond 条件
     * @param 
     * @return
     */
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond){
    	return prdcJobService.findJobVOByCond(cond);
    }

    /**
     * 删除任务行数据
     * @param jobId
     * @param jobLineId
     * @return
     */
    public Boolean deleteJobLine(Long jobId,Long jobLineId){
        return prdcJobService.deleteJobLine(jobId, jobLineId);
    }

    /**
     * 退回修改_取消任务
     *
     * @param jobId
     * @return
     */
    public Boolean cancelJobForStatusReturnModify(Long jobId){
        return prdcJobService.cancelJobForStatusReturnModify(jobId);
    }



    /**
     * 根据外键查询jobline
     * @param id
     * @return
     */
    public List<PrdcJobLine> getPrdcJobLine(Long id){return prdcJobLineService.getPrdcJobLineByJobId(id); }

    /**
     * 检查后占用库存并更新job
     * @param jobVO
     * @return
     */

    public Boolean startProduction(PrdcJobVO jobVO){return prdcJobService.startProduction(jobVO);}

    /**
     * 更新生产任务状态
     * @param jobVO
     * @return
     */
    public Boolean updateJobVO(PrdcJobVO jobVO){return prdcJobService.updateJobVO(jobVO);}

    /**
     * 更新生产任务分配完成标识
     * @param jobVO
     * @return
     */
    public Boolean updatePjJobVO(PrdcJobVO jobVO){return prdcJobService.updatePjJobVO(jobVO);}

    /**
     * 更新收货计划行的分货标识
     * @param id
     * @param sign
     * @return
     */
    public boolean updateProdJobById(long id, Integer sign){

        return prdcJobService.updateProdJobById(id, sign);
    }

    public boolean updateJobConfirmToWmsReturnModify(String jobCode){
        return prdcJobService.updateJobConfirmToWmsReturnModify(jobCode);
    }

    /**
     * 释放占用资源并更新JOB
     * @param jobVO
     * @param whReleaseOccupationVOList
     */
    public Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO,List<WhReleaseOccupationVO> whReleaseOccupationVOList){
        return prdcJobService.releaseJobLineOccupyAndUpdate(jobVO, whReleaseOccupationVOList);
    }





    /**
     * 释放后创建指令并完成后更新JOB
     * @param jobVO
     * @param whCommands
     * @param whReleaseOccupationVOList
     * @return
     * @throws Exception 
     */
    public Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO,List<WhCommandVO> whCommands,
                                                                 List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception{
        return prdcJobService.createCommandsAfterReleaseThenFinishAndUpdate(jobVO, whCommands, whReleaseOccupationVOList);
    }

    /**
     * 获取配送仓库名称
     *
     * @return
     */
    public String getWarehouseName(String warehouseCode){return prdcJobService.getWarehouseName(warehouseCode);}

    /**
     * 获取仓库名称/编码键值对
     * @return
     */
    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList){return prdcJobService.getWarehouseList(warehouseCodeList);}

    /**
     * 建立库存占用whOccupy
     * @param prdcJob
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    
    public List<WhInvOccupyVO> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType){
        return prdcJobService.buildWhOccupy(prdcJob,prdcJobLineList, warehouseCode, occupyType);
    }

    /**
     * 建立释放库存需要的WhReleaseOccupationVO
     * @param prdcJobLineList
     * @param occupyType
     */

    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob,List<PrdcJobLine> prdcJobLineList, Integer occupyType) {
        return prdcJobService.buildWhRelease(prdcJob,prdcJobLineList, occupyType);
    }


    /**
     * 创建出库,仓库指令需要的参数
     * @param jobVO
     * @return whCommandList
     */
    public List<WhCommandVO> buildPrdcCommands(PrdcJobVO jobVO) {
        return prdcJobService.buildPrdcCommands(jobVO);
    }

    /**
     * 导出收货计划状态~待入库
     * @return
     */
    public byte[] exportPoPlanStatusWaitingIn(){
        return pcsPoPlanService.exportPoPlanStatusWaitingIn();
    }

    public byte[] exportPoInfomation(){
        return pcsPoPlanService.exportPoInfomation();
    }
    
    
    public List<FpcsPurchaseOrder> selectFpcsPurchaseOrder(FpcsPurchaseOrder example) {
        return fpcsPurchaseOrderService.select(example);
    }
    /**
     * 获取所有sku信息列表
     * @author jim.huang
     * @date 2016年4月10日
     * @return List<FpcsSkuOrder>
     * @throws Exception
     */
    public List<FpcsSkuOrder> getAllFlowerSkuInfo() throws Exception{

        return fpcsSkuService.getAllFlowerSkuInfo();
    }

    /**
     * 获取sku信息列表
     * @param params
     * @return
     */
    public List<FpcsSkuOrder> getFlowerSkuInfo(Map<String, Object> params) {
        return fpcsSkuService.getFlowerSkuInfo(params);
    }


    /**
     * 获取所有sku信息列表
     * @author jim.huang
     * @date 2016年4月10日
     * @return List<FpcsSkuOrder>
     * @throws Exception
     */
    public List<FpcsSkuOrder> getFlowerSkuByCondition(Date time, String code) throws Exception{

        return fpcsSkuService.getFlowerSkuByCondition(time, code);
    }
	

    public int sumitOrder(FpcsOrderListForm example) {
        return fpcsPurchaseOrderService.sumitOrder(example);
    }
    public  List<FpcsPurchaseOrder> findPurchaseOrderList(FpcsPurchaseOrder cond) {
        return fpcsPurchaseOrderService.getPurchaseOrderList(cond);
    }
    public  List<FpcsPurchaseOrder> getCacheSkuOrderList(List<FpcsPurchaseOrder> fpcsPurchaseOrderList) {
        return fpcsPurchaseOrderService.getCacheSkuOrderList(fpcsPurchaseOrderList);
    }
    public  Map<String, Object> detailPurchaseOrder(long id) {
        return fpcsPurchaseOrderService.getDetailPurchaseOrder(id);
    }

    public  void acceptOrder(FpcsPurchaseOrder cond) {
        fpcsPurchaseOrderService.acceptOrder(cond);
    }
    public Map<String,List<List<String>>>  exportPurchaseOrder(FpcsPurchaseOrder example) {
        return fpcsPurchaseOrderService.exportPurchaseOrder(example);
    }

    public List<FpcsActualExcelVO> queryActualPurchaseList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualPurchaseList(params);
    }

    public List<FpcsChannelQuantity> queryActualPruchaseChannelList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualPruchaseChannelList(params);
    }

    public Long addActualPurchaseLog(FpcsActualExcelVO actualExcelVO) {
        Long ret = fpcsActualPurchaseService.addActualPurchaseLog(actualExcelVO);
        if (ret > 0) {
            List<FpcsChannelQuantity> channelQuantityList = actualExcelVO.getChannelQuantitiyList();
            for (int i = 0, len = channelQuantityList.size(); i < len; i++) {
                FpcsChannelQuantity channelQuantity = channelQuantityList.get(i);
                if (channelQuantity.getQuantity() == null ||
                        channelQuantity.getQuantity() == 0 ||
                        channelQuantity.getSkuCode() == null) {
                    continue;
                }
                channelQuantity.setActualPurchaseId(actualExcelVO.getId());
                fpcsActualPurchaseService.addActualPurhcaseChannel(channelQuantity);
            }
        }
        return ret;
    }

    public List<FpcsActualChannelVO> queryActualChannelList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualChannelList(params);
    }

    public List<FpcsActualChannelItemVO> queryActualChannelItemList(Map<String, Object> params) {
        return fpcsActualPurchaseService.queryActualChannelItemList(params);
    }

    public int saveConsumableAllot(List<PcsSkuVO> skuList, List<MaterailSkuVO> codeCategory){

        int i = 0;
        if(skuList!=null){
            List<FpcsConsumableAllot> consumableAllotList = new ArrayList<FpcsConsumableAllot>();
            for (PcsSkuVO pcsSkuVO : skuList) {
                FpcsConsumableAllot fpcsConsumableAllot = new FpcsConsumableAllot();
                fpcsConsumableAllot.setCreatTime(new Date());
                fpcsConsumableAllot.setSkuCode(pcsSkuVO.getCode());
                fpcsConsumableAllot.setSkuName(pcsSkuVO.getName());
                fpcsConsumableAllot.setMaterial(pcsSkuVO.getMaterial());
                fpcsConsumableAllot.setSpecification(pcsSkuVO.getSpecification());
                fpcsConsumableAllot.setSize(pcsSkuVO.getSize());
                fpcsConsumableAllot.setMaxApplyNumber(pcsSkuVO.getStock());
                fpcsConsumableAllot.setApplyNumber(0);
                if(!CollectionUtils.isEmpty(codeCategory)){
                    for (MaterailSkuVO materailSkuVO : codeCategory) {
                        if(pcsSkuVO.getCode().endsWith(materailSkuVO.getSkuCode())){
                            fpcsConsumableAllot.setCategory(materailSkuVO.getCategory());
                            fpcsConsumableAllot.setCanApply(materailSkuVO.getCanApply());
                            fpcsConsumableAllot.setWhetherQuantityControl(materailSkuVO.getWhetherQuantityControl());
                            fpcsConsumableAllot.setMinApplyNumber(materailSkuVO.getMinApplyNumber());
                        }
                    }
                }
                consumableAllotList.add(fpcsConsumableAllot);
            }
            i = fpcsSkuService.saveConsumableAllot(consumableAllotList);
        }
        return i;
    }

    public List<FpcsConsumableAllotVO> getAllConsumableList(List<String> warehouseCodeList){
        return fpcsSkuService.getAllConsumableList(warehouseCodeList);
    }




    /**
     * 更新采购单收货计划
     *
     * @return 是否成功
     */
    public boolean updatePoPlan(PcsPoPlan po){
        return  pcsPoPlanService.updatePoPlan(po);
    }

    /**
     * 更新采购单收货计划行；
     *
     * @return 是否成功
     */
    public boolean updatePoPlanLine(PcsPoPlanLine line){
        return  pcsPoPlanService.updatePoPlanLine(line);
    }


    /**
     * 获取生产订单单个耗材实际消耗数
     * @param id
     * @param skuCode
     * @return
     */
    public Integer getJobLineRealConsumeAmount(Long id,String skuCode) {
        return prdcJobLineService.getJobLineRealConsumeAmount(id,skuCode);
    }

    /**
     * 获取单张生产订单最大可启动子任务数
     * @param vo
     * @return
     */
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return prdcJobService.getPrdcJobMaxTask(vo);
    }

    /**
     * 子任务完成是更新加工订单状态
     * @param vo
     * @return
     */
    public boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo) {
        return prdcJobService.updatePrdcJobWhenTaskFinish(vo);
    }

    /**
     * 定时更新加工订单信息
     * 每1分钟执行一次
     * 不是使用,移到corn
     */
    //@Scheduled(cron = "0 0/1 * * * ?")
    public void updatePrdcJobWhenTaskFinish(){
        final CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("prdcJobFinishCheck");
        if(config == null){
            return;
        }

        String value = config.getConfigValue();
        if(!StringUtils.isEmpty(value) && "1".equals(value)){
            prdcJobService.updatePrdcJobWhenTaskFinish(null);
        }

    }

    public List<PcsPoPlanLine> findPoPlanLineByPoPlanId(Long poPlandId){
        return pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlandId);
    }

    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanIds(List<Long> poPlandIds){
        return pcsPoPlanLineService.findPoPlanLineVOByPoPlanIds(poPlandIds);
    }

    /**
     * 通过采购单查询采购单所有的采购计划单是否都是收货完成
     * @param poId
     * @return
     */
    public boolean isAllPoPlanFinished(Long poId){
        return pcsPoPlanService.isAllPoPlanFinished(poId);
    };

    /**
     * 通过采购单查询采购单收货数据是否完成
     * @param poId
     * @return
     */
    public boolean isAllReceivePo(Long poId){
        return pcsPoPlanService.isAllReceivePo(poId);
    }
    public PcsPoPlan findPcsPoPlanByKey(Long id){
        return pcsPoPlanService.findPoPlanById(id);
    }

    public PcsPoPlan findPcsPoPlanById(Long id){
        return pcsPoPlanService.findPoPlanById(id);
    }
    public boolean updatePcsPurchaseOrderById(PcsPurchaseOrder pcsPurchaseOrder){
        return  pcsPurchaseOrderService.update(pcsPurchaseOrder);
    }
    public PcsPurchaseOrder findPcsPurchaseOrderById(Long id){
        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(id);
        return  pcsPurchaseOrder;
    }

    public List<PcsPoCreditNoteVO> listPcsPoCreditNoteVOByCond(PcsPoCreditNoteCond cond){
        List<PcsPoCreditNoteVO> creditNoteVOs = pcsPurchaseOrderService.listPcsPoCreditNoteVOByCond(cond);
        if (cond.isFetchAttachment() && CollectionUtils.isNotEmpty(creditNoteVOs)){
            List<String> refCodes = creditNoteVOs.stream().map(vo -> vo.getId().toString()).collect(Collectors.toList());
            CommFileRef commFileRefCond = new CommFileRef();
            commFileRefCond.setReferenceCodes(refCodes);
            commFileRefCond.setRefType(CommFileRef.CONTRACT_TYPE_CREDIT_NOTE);
            List<CommFileRef> commFileRefs = listCommFileRefs(commFileRefCond);
            buildAttachmentsCreditNote(creditNoteVOs, commFileRefs);
        }
        return creditNoteVOs;
    }

    public List<CommFileRef> listCommFileRefs(CommFileRef cond){
        return pegasusUtilFacade.findCommFileRefByCond(cond);
    }

    private void buildAttachmentsCreditNote(List<PcsPoCreditNoteVO> creditNoteVOs, List<CommFileRef> commFileRefs) {
        if (CollectionUtils.isNotEmpty(creditNoteVOs) && CollectionUtils.isNotEmpty(commFileRefs)){
            Map<String, List<CommFileRef>> map = commFileRefs.stream().collect(Collectors.groupingBy(CommFileRef::getReferenceCode));
            creditNoteVOs.forEach(cn -> {
                if (map.get(cn.getId().toString()) != null){
                    cn.setAttachmentList(map.get(cn.getId().toString()));
                }
            });
        }
    }

    public List<PcsPoCreditNote> listPcsPoCreditNoteByCond(PcsPoCreditNoteCond cond){
        return pcsPurchaseOrderService.listPcsPoCreditNoteByCond(cond);
    }

    public List<PcsPoCreditNoteVO> listSumPoCreditNoteVOByCond(PcsPoCreditNoteCond cond){
        return pcsPurchaseOrderService.listSumPoCreditNoteVOByCond(cond);
    }

    public List<PcsPoCreditNoteVO> listSumPoCreditNoteVOByPoCode(String poCode){
        PcsPoCreditNoteCond cond = new PcsPoCreditNoteCond();
        cond.setPoCode(poCode);
        return listSumPoCreditNoteVOByCond(cond);
    }

    public Boolean closePoPlanByPlanId(Long poPlandId){
        return  pcsPoPlanService.closePoPlanByPlanId(poPlandId);
    }

    public PcsPoPlan findPcsPoPlanByCode(String code){
        return pcsPoPlanService.findPoPlanByCode(code);
    }

    public void processReceicePlan(String poPlanCode ,Map<String,Integer> liangpinMap, Map<String,Integer> canciMap){
        pcsPurchaseOrderService.processReceicePlan(poPlanCode,liangpinMap,canciMap);
    }

    /**
     * 创建标签
     * */
    public boolean createPcsCertificateField(PcsCertificateField field){
        return pcsCertificateFieldService.create(field);
    }

    /**
     * 编辑标签
     * */
    public boolean updatePcsCertificateField(PcsCertificateField field){
        return pcsCertificateFieldService.update(field);
    }

    /**
     * 删除标签
     * 逻辑删除
     * */
    public boolean deletePcsCertificateFieldById(int id){
        return pcsCertificateFieldService.deleteById(id);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond){
        return pcsCertificateFieldService.findPcsCertificateField(cond);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond,boolean cascade ){
        return pcsCertificateFieldService.findPcsCertificateField(cond,cascade);
    }

    public PcsCertificateFieldVO findPcsCertificateFieldById(int id){
        return pcsCertificateFieldService.findPcsCertificateFieldById(id);
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuField(){
        return pcsCertificateSkuFieldService.findAll();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSku(){
        return pcsCertificateSkuFieldService.findAllSkuField();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSys(){
        return pcsCertificateSkuFieldService.findAllSysField();
    }

    /**
     * 根据field,skuCode
     * 获取字段值
     * */
    public String getFieldValueBySkuCode(PcsCertificateSkuFieldVO field,String skuCode){
        return pcsCertificateSkuFieldService.getFieldValueBySkuCode(field, skuCode);
    }

    /**
     * 新增合格证
     * @author yu.bao
     * @date 2016年5月31日
     * @param vo
     * @return
     */
    public boolean addPcsCertificateTag(PcsCertificateTagVO vo){
        return pcsCertificateTagService.addPcsCertificateTag(vo);
    }

    /**
     * 批量新增合格证
     * @author yu.bao
     * @date 2016年5月31日
     * @param vos
     * @return
     */
    public boolean addPcsCertificateTag(List<PcsCertificateTagVO> vos){
        return pcsCertificateTagService.addPcsCertificateTag(vos);
    }

    // certificate tpl start
    /**
     * 获取所有模板
     * 不包含字段
     * */
    public List<PcsCertificateTplVO> findAllCerTpl(){
        return pcsCertificateTplService.findAll();
    }

    /**
     * 获取模板
     * 包含字段
     * */
    public PcsCertificateTplVO findCerTplById(Long cerTplId,boolean cascade){
        return pcsCertificateTplService.findById(cerTplId,cascade);
    }

    public PcsCertificateTplVO findCerTplVOByCond(PcsCertificateTplVO tplVO) {
        return pcsCertificateTplService.findCerTplVOsByCond(tplVO);
    }

    public List<PcsCertificateTplVO> listCerTplVOsByCond(PcsCertificateTplVO tplVO) {
        return pcsCertificateTplService.listCerTplVOsByCond(tplVO);
    }

    /**
     * 获取模板
     * 包含字段
     * */
    public PcsCertificateTplVO findCerTplByCategoryId(Long categoryId,boolean cascade){
        return pcsCertificateTplService.findByCategoryId(categoryId,cascade);
    }

    /**
     * 获取模板
     * 包含字段
     * */
    public PcsCertificateTplVO findCommonUseTpl(boolean cascade){
        return pcsCertificateTplService.findCommonUseTpl(cascade);
    }

    /**
     * 获取已关联模板的类目
     * */
    public List<Long> findUsedCategoryIds(){
        return pcsCertificateTplService.findUsedCategoryIds();
    }

    /**
     * 更新模板
     * */
    public void updateCerTpl(PcsCertificateTplVO cerTplVO){
        pcsCertificateTplService.update(cerTplVO);
    }

    /**
     * 新增模板
     * */
    public void addCerTpl(PcsCertificateTplVO cerTplVO){
        pcsCertificateTplService.save(cerTplVO);
    }

    public void copyCerTpl(PcsCertificateTplVO cerTplVO){
        pcsCertificateTplService.copyCerTpl(cerTplVO);
    }

    public void fullCerTplDefaultValue(PcsCertificateTplVO cerTplVO, String skuCode){
        pcsCertificateTplService.fullCerTplDefaultValue(cerTplVO,skuCode);
    }

    /**
     * 查找模板字段
     * */
    public PcsCertificateTplFieldVO findTplFieldVO(Long tplId,Long tplFieldId){
        return pcsCertificateTplFieldService.findTplFieldVO(tplId,tplFieldId);
    }

    /**
     * 更新模板字段
     * */
    public void saveOrUpdateTplFieldVO(PcsCertificateTplFieldVO tplFieldVO){
        pcsCertificateTplFieldService.saveOrUpdate(tplFieldVO);
    }

    /**
     * 删除模板字段
     * */
    public void deleteTplFieldVOById(Long tplFieldId){
        pcsCertificateTplFieldService.deleteByTplFieldId(tplFieldId);
    }

    /**
     * 查找模板字段-字典
     * */
    public List<PcsCertificateTplFieldDicVO> findAllCerTplFieldDic(){
        return pcsCertificateTplFieldService.findAllCerTplFieldDic();
    }

    public PcsCertificateTplFieldDicVO findTplFieldDicById(Long tplFieldDicId){
        return pcsCertificateTplFieldService.findTplFieldDicById(tplFieldDicId);
    }

    //certificate tpl end

    //certificate start

    /**
     * 查询sku 合格证相关信息
     * */
    public List<PcsSkuCertificateVO> findSkuCerByCond(SkuCerCond cond){
        return pcsSkuCertificateService.findSkuCerByCond(cond);
    }

    public List<PcsSkuCertificateVO> findRecipeCerVOByCond(SkuCerCond cond){
        return pcsSkuCertificateService.findRecipeCerVOByCond(cond);
    }

    public List<PcsSkuCerInfoExcelVO> findSkuCerExportInfoByCond(SkuCerCond cond){
        return pcsSkuCertificateService.findSkuCerExportInfoByCond(cond);
    }

    /**
     * 查询合格证
     * */
    public PcsSkuCertificateVO findCerBySkuCode(String skuCode){
        return pcsSkuCertificateService.findBySkuCode(skuCode);
    }

    /**
     * 查询合格证
     * */
    public PcsSkuCertificateVO findCerBySkuCode(String skuCode,boolean cascade){
        return pcsSkuCertificateService.findBySkuCode(skuCode,cascade);
    }

    /**
     * 查询合格证
     * */
    public List<PcsSkuCertificateVO> findCerBySkuCodes(List<String> skuCodeList,boolean cascade){
        return pcsSkuCertificateService.findBySkuCodes(skuCodeList,cascade);
    }

    /**
     * 查询打印合格证数据
     * */
    public List<PrintSkuCerVO> getPrintCerBySkuCodeBarCode(PrintCerVO cond){
        return pcsSkuCertificateService.getPrintCerBySkuCodeBarCode(cond);
    }

    public void saveOrUpdateCer(PcsSkuCertificateVO cerVO){
        pcsSkuCertificateService.saveOrUpdate(cerVO);
    }

    public boolean saveOrUpdateSkuCer(PcsSkuCertificateVO cerVO){
        return pcsSkuCertificateService.saveOrUpdateSkuCer(cerVO);
    }

    public void saveOrUpdateCer(List<PcsSkuCertificateVO> cerList){
        pcsSkuCertificateService.saveOrUpdate(cerList);
    }

    /**
     * 更新合格证状态
     * */
    public void saveOrUpdateCerStatus(PcsSkuCertificateVO cerVO){
        pcsSkuCertificateService.saveOrUpdateStatus(cerVO);
    }


    public boolean saveSkuCerMpCode(String skuCode,String mpCodeUrl){
        return pcsSkuCertificateService.saveSkuCerMpCode(skuCode,mpCodeUrl);
    }

    public boolean batchSaveSkuCerMpCode(Map<String,String> skuCode_mpCodeUrl){
        return pcsSkuCertificateService.batchSaveSkuCerMpCode(skuCode_mpCodeUrl);
    }

    public String findSkuCerMpCode(String skuCode){
        return pcsSkuCertificateService.findSkuCerMpCode(skuCode);
    }

    public Map<String,String> findSkuCerMpCodeMap(List<String> skuCodes){
        return pcsSkuCertificateService.findSkuCerMpCodeMap(skuCodes);
    }

    public List<String> findSkuCerWithSalesPriceField(List<String> skuCodes){
        return pcsSkuCertificateService.findSkuCerWithSalesPriceField(skuCodes);
    }

    public List<String> findSkuSalesPriceChangePreDay(){
        return pcsSkuCertificateService.findSkuSalesPriceChangePreDay();
    }

    public Integer insertOrUpdateByExampleSelective(PcsSkuCertificate record, PcsSkuCertificateExample example){
        return pcsSkuCertificateService.insertOrUpdateByExampleSelective(record,example);
    }

    //certificate end

    /**
     * 建立释放库存需要的WhReleaseOccupationVO
     * @param prdcJobLineVOList
     * @param occupyType
     */
    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType) {
        return prdcJobService.buildWhRelease(prdcJobLineVOList, occupyType);
    }
    /**
     * 建立库存占用whOccupy
     * @param prdcJobLineVOList
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    public List<WhInvOccupyVO> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType){
        return prdcJobService.buildWhOccupy(prdcJobLineVOList, warehouseCode, occupyType);
    }
    /**
     * 检查后占用库存并更新job
     * @param jobVO
     * @return
     */
    public Boolean checkOccupyAndUpdate(PrdcJobVO jobVO,List<WhInvOccupyVO> whInvOccupyList){return prdcJobService.checkOccupyAndUpdate(jobVO, whInvOccupyList);}

    /**
     * 查询sku对应合格证标签信息
     * @author jim.huang
     * @date 2016年5月30日
     * @param skuCode
     */
    public PcsCertificateTagEditVO getTagAndSkuBySkuCode(String skuCode){
        return pcsCertificateTagService.getTagAndSkuBySkuCode(skuCode);
    }

    /**
     * 查询合格证对应字段
     * @author jim.huang
     * @date 2016年5月30日
     * @param skuCode
     * @return
     */
    public List<PcsCertificateTagFieldValueVO> getTagFieldsSkuBySkuCode(String skuCode){
        return pcsCertificateTagService.getTagFieldsSkuBySkuCode(skuCode);
    }

    /**
     * 新建标签
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public int saveCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag){
        return pcsCertificateTagService.saveCertificateTagBySkuCode(pcsCertificateTag);
    }

    /**
     * 更新标签状态
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void updateCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag){
        pcsCertificateTagService.updateCertificateTagBySkuCode(pcsCertificateTag);
    }

    /**
     * 根据sku查询 合格证
     * @author yu.bao
     * @param
     * @return List<PcsCertificateTag>
     */
    public List<PcsCertificateTagVO> getCertificateTagBySkuCodes(List<String> skuCodes){
        return pcsCertificateTagService.getCertificateTagBySkuCodes(skuCodes);
    }

    /**
     * 根据sku,barCode查询 合格证
     * @author yu.bao
     * @param
     * @return List<PcsCertificateTag>
     */
    public List<PcsCertificateTagVO> getTagBySkuCodeBarCode(PrintCerVO cond){
        return pcsCertificateTagService.getTagBySkuCodeBarCode(cond);
    }


    /**
     * 新建标签
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void saveCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
        pcsCertificateTagService.saveCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    /**
     * 更新标签状态
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void updateCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
        pcsCertificateTagService.updateCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    /**
     * 删除标签状态
     * @author jim.huang
     * @date 2016年5月30日
     * @param
     */
    public void deleteCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField){
        pcsCertificateTagService.deleteCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public List<PcsCertificateFieldVO> getTagFieldsSkuByIds(List<Integer> ids) {
        return pcsCertificateTagService.getTagFieldsSkuByIds(ids);
    }

    /**
     * 根据sku查询
     * @author ztq
     * @date 2016年6月1日
     * @param
     */
    public PcsCertificateTagVO searchTagBySkuCode(PcsCertificateTag pcsCertificateTag){
        return pcsCertificateTagService.searchTagBySkuCode(pcsCertificateTag);
    }
    
    
    
	public List<PrdcJob> findSkuReportJobVO() { 
		return prdcJobService.findSkuReportJobVO();
	}
	
	/**
	 * 根据skucodes查询合格正信息
     * @return
     */
    public List<PcsCertificateTagFieldValueVO> getTagsBySkuCode(List<String> skuCodes) {
		List<PcsCertificateTagFieldValueVO> list = pcsCertificateFieldService.getTagsBySkuCode(skuCodes);
		return list;
	}

	public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
		return pcsPoPlanService.createPoPlanFee(pcsPoPlanCost);
	}

    public int batchCreatePoPlanFee(List<PcsPoPlanCost> pcsPoPlanCosts) {
		return pcsPoPlanService.batchCreatePoPlanFee(pcsPoPlanCosts);
	}
	
	public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
		return pcsPoPlanService.selectCostByPoPlanId(poPlanId);
	}

    public Pagination<PcsPoPlanCostVO> pagePoPlanCostVOs(PcsPoPlanCostCond cond) {
		return pcsPoPlanService.pagePoPlanCostVOs(cond);
	}

    public List<PcsPoPlanCostVO> listPoPlanCostVOsByGroup(PcsPoPlanCostCond cond) {
		return pcsPoPlanService.listPoPlanCostVOsByGroup(cond);
	}

    public List<PcsPoPlanCostVO> listPoPlanCostVOs(PcsPoPlanCostCond cond) {
		return pcsPoPlanService.listPoPlanCostVOs(cond);
	}

    public List<PcsPoPlanCost> findPoCostDetails(Integer poId) {
        return pcsPoPlanService.findPoCostDetails(poId);
    }

    public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
        return pcsPoPlanService.updatePoPlanFee(pcsPoPlanCost, optType);
    }

	public List<PcsFinancePaymentVO> findPoFinaceVOByPoId(long poId) {
        return findPoFinaceVOByPoId(poId, null);
	}

    public List<PcsFinancePaymentVO> findPoFinaceVOByPoId(long id, Integer type){
        List<PcsFinancePayment> list = pcsFinancePaymentService.findPoFinaceVOByPoId(id,type);
        return BeanUtil.buildListFrom(list,PcsFinancePaymentVO.class);
    }

    public List<PcsFinancePaymentVO> findPcsFinancePaymentVOByPoId(long poId, Integer type){
        PcsFinancePaymentCond cond = new PcsFinancePaymentCond();
        cond.setExternalId(poId);
        cond.setType(type);
        return findPcsFinancePaymentVOByCond(cond);
    }

    public List<PcsFinancePaymentVO> findPcsFinancePaymentVOByCond(PcsFinancePaymentCond cond){
        List<PcsFinancePaymentVO> financePaymentVOs = pcsFinancePaymentService.findPcsFinancePaymentVOByCond(cond);
        buildFinancePaymentCostTypeName(financePaymentVOs);
        return financePaymentVOs;
    }

    /**
     * 获取付款费用类型名称
     * @param financePaymentVOs
     */
    public void buildFinancePaymentCostTypeName(List<PcsFinancePaymentVO> financePaymentVOs){
        Map<String, Map<Integer, String>> allPoCostMap = mapAllPoCostMap();
        if (CollectionUtils.isNotEmpty(financePaymentVOs)){
            financePaymentVOs.forEach(fp -> {
                if (EmptyUtil.isNotEmpty(allPoCostMap.get(fp.getPoCostTypeFlag()))){
                    fp.setPoCostTypeName(allPoCostMap.get(fp.getPoCostTypeFlag()).get(fp.getPoCostType()));
                }
            });
        }
    }

    private Map<String, Map<Integer, String>> mapAllPoCostMap(){
        Map<String, Map<Integer, String>> allPoCostMap = new HashMap<>();

        // pop费用
        List<CommDictionary> allShipmentType = pegasusUtilFacade.findDictionaryByType(CommDictionaryVO.DICT_TYPE_SHIPMENT_TYPE);
        Map<Integer, String> shipmentTypeMap = convertListToMap(allShipmentType);
        allPoCostMap.put(CommDictionaryVO.DICT_TYPE_SHIPMENT_TYPE, shipmentTypeMap);

        List<CommDictionary> allTaxType = pegasusUtilFacade.findDictionaryByType(CommDictionaryVO.DICT_TYPE_TAX_TYPE);
        Map<Integer, String> taxTypeMap = convertListToMap(allTaxType);
        allPoCostMap.put(CommDictionaryVO.DICT_TYPE_TAX_TYPE, taxTypeMap);

        List<CommDictionary> allOtherFeeType = pegasusUtilFacade.findDictionaryByType(CommDictionaryVO.DICT_TYPE_OTHER_FEE_TYPE);
        Map<Integer, String> otherFeeTypeMap = convertListToMap(allOtherFeeType);
        allPoCostMap.put(CommDictionaryVO.DICT_TYPE_OTHER_FEE_TYPE, otherFeeTypeMap);

        // po费用
        allPoCostMap.put(PcsFinancePaymentVO.PO_COST_TYPE_FLAG_PO, PcsPurchaseOrderCostVO.PO_COST_TYPE_MAP);

        // po扩展费用
        allPoCostMap.put(PcsFinancePaymentVO.PO_COST_TYPE_FLAG_PO_EXT, PcsPurchaseOrderCostVO.PO_COST_TYPE_EXT_MAP);

        return allPoCostMap;
    }

    private Map<Integer, String> convertListToMap(List<CommDictionary> commDictionaries){
        /**
         * List -> Map
         * 需要注意的是：
         * toMap 如果集合对象有重复的key，会报错Duplicate key ....
         *  可以用 (k1,k2)->k1 来设置，如果有重复的key,则保留key1,舍弃key2
         */
        // return commDictionaries.stream().collect(Collectors.toMap(CommDictionary::getDictValue, a -> a.getDictName(),(k1, k2)->k1));
        Map<Integer ,String> map = new HashMap<>();
        for (CommDictionary cd : commDictionaries){
            map.put(Integer.parseInt(cd.getDictValue()), cd.getDictName());
        }
        return map;
    }

	public Long createFinancePayment(PcsFinancePaymentVO pcsFinancePaymentVO) {
		PcsFinancePayment pcsFinancePayment = pcsFinancePaymentService.buildFromModel(pcsFinancePaymentVO);
		return pcsFinancePaymentService.createFinancePayment(pcsFinancePayment);
	}
	
	/**
     * 更新采购单财务信息
     *
     * @param pcsFinancePaymentVO
     * @return
     */
    public Boolean updateFinancePayment(PcsFinancePaymentVO pcsFinancePaymentVO) {
    	PcsFinancePayment pcsFinancePayment = new PcsFinancePayment();
    	BeanUtils.copyProperties(pcsFinancePaymentVO, pcsFinancePayment);
    	return pcsFinancePaymentService.updateFinancePayment(pcsFinancePayment);
    }

    /**
     * 统计当前编号下的已付款量
     * @param externalId
     * @return
     */
	public Map<String, BigDecimal> getTotalPaymentAmount(Long externalId) {
		return pcsFinancePaymentService.getTotalPaymentAmount(externalId);
	}

	public PcsFinancePayment findByPrimaryKey(Long id) {
		return pcsFinancePaymentService.findByPrimaryKey(id);
	}

	public Long createPurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft)throws Exception {
		return pcsPurchaseOrderService.createPurchaseReturnAndLine(pcsPurchaseReturn, returnSkuVOList, saveDraft);
	}

	public Boolean updatePurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft)throws Exception {
		return  pcsPurchaseOrderService.updatePurchaseReturnAndLine(pcsPurchaseReturn, returnSkuVOList, saveDraft);
	}

	public List<PcsPurchaseReturnVO> findPRVOByCond(PcsPurchaseReturnCond cond) {
		return pcsPurchaseOrderService.findPRVOByCond(cond);
	}

	public Integer countPRVOByCond(PcsPurchaseReturnCond cond) {
		return pcsPurchaseOrderService.countPRVOByCond(cond);
	}
	public PcsPurchaseReturnVO findPRVOById(Long id, boolean withLine)  {
		return pcsPurchaseOrderService.findPRVOById(id, withLine);
	}

	public Boolean auditPurchaseReturn(CommAudit commAudit) throws Exception {
		return pcsPurchaseOrderService.auditPurchaseReturn(commAudit);
	}

	public Boolean closePurchaseReturn(Long id) {
		return pcsPurchaseOrderService.closePurchaseReturn(id);
	}

	public List<PcsPurchaseReturnSkuVO> findPrLineByCond(PcsPurchaseReturnSku cond) {
		return pcsPurchaseOrderService.findPrLineByCond(cond);
	}

	public List<PcsPurchaseOrderVO> findPOVOBySupplierId(Long supplierId) {
		return pcsPurchaseOrderService.findPOVOBySupplierId(supplierId);
	}

    public List<PcsSkuProductVO> findProductInfoBySkuCodes(List<String> skuCodes){
        return fpcsSkuService.findProductInfoBySkuCodes(skuCodes);
    }

    public List<String> findProductCodesBySkuCodes(List<String> skuCodes){
        return fpcsSkuService.findProductCodesBySkuCodes(skuCodes);
    }
    /**
     * 获取所有二级成本中心
     * @return
     */
    public List<PcsCostCenter> getAllSecondPcsCostCenters() {
        List<PcsCostCenter> date = pcsCostCenterService.getAllSecondPcsCostCenters();
        return date;
    }
    public List<PcsCostCenter> queryPcsCostCenterByParams(Map<String, Object> params) {
    	return pcsCostCenterService.queryPcsCostCenterByParams(params);
    }

	public List<PcsPurchaseOrderVO> findPoCostById(Long id) {
        return pcsPurchaseOrderService.findPoCostById(id);
    }

    public boolean batchUpdatePcsPoCost(PcsPoPlanCostVO pcsPoCostVO,Long operatorId) {
        return pcsPurchaseOrderService.batchUpdatePcsPoCost(pcsPoCostVO,operatorId);
    }

    public List<PcsCostAdjust> findCostAjustByCostIds(List<Long> costIds,Integer costType){
        return pcsPurchaseOrderService.findCostAjustByCostIds(costIds,costType);
    }


    public long getPurchaseOrderCount(PcsPurchaseOrderCond cond) {
    	return pcsPurchaseOrderService.countByCond(cond);
    }

    /**
     * 根据条件查找进销存报表
     * @param cond
     * @return
     */
    public List<PurchaseSellStockReportVO> findPssReportByCond(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderService.findPssReportByCond(cond);
    }


    public List<PurchaseSellStockReportVO> findPssReportByIds(List<Long> reportIds) {
        return pcsPurchaseOrderService.findPssReportByIds(reportIds);
    }

    public Pagination<PcsFlowerDeliveryVO> getFlowerDeliveryByCond(PcsFlowerDeliveryCond cond) {
        return pcsFlowerDeliveryService.getFlowerDeliveryByCond(cond);
    }

    public PcsFlowerDeliveryVO getFlowerDeliveryBySku(PcsFlowerDeliveryCond cond) {
        return pcsFlowerDeliveryService.getFlowerDeliveryBySku(cond);
    }

    public PcsFlowerDeliveryRecipe getFlowerDeliveryRecipeById(Long recipeId) {
        return pcsFlowerDeliveryService.getFlowerDeliveryRecipeById(recipeId);
    }

    public Map<Class<?>, List<?>> findFlowerDeliverySaleInfo(Long deliveryRecipeId, String skuCode){
        return pcsFlowerDeliveryService.findFlowerDeliverySaleInfo(deliveryRecipeId,skuCode);
    }

    public List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryRecipeByCond(PcsFlowerDeliveryCond cond) {
        return pcsFlowerDeliveryService.getFlowerDeliveryRecipeByCond(cond);
    }

    public Pagination<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDetailByCond(PcsFlowerDeliveryCond cond) {
        return pcsFlowerDeliveryService.getFlowerDeliveryDetailByCond(cond);
    }

    public boolean saveFlowerDelivery(PcsFlowerDeliveryCond cond) {
        return pcsFlowerDeliveryService.saveFlowerDelivery(cond);
    }

    public List<String> getPackageDeliveryDate(Long packageId, Long salesOrderId) {
    	return pcsFlowerDeliveryService.getPackageDeliveryDate(packageId, salesOrderId);
    }

    public List<PcsFlowerRecipeSkuVO> getFlowerRecipeSkuByCond(Long recipeId) {
        return pcsFlowerDeliveryService.getFlowerRecipeSkuByCond(recipeId);
    }

    public boolean addFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        return pcsFlowerDeliveryService.addFlowerRecipeSku(pcsRecipeSkuVO);
    }

    public boolean updateFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        return pcsFlowerDeliveryService.updateFlowerRecipeSku(pcsRecipeSkuVO);
    }

    public boolean updateFlowerRecipeById(PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe) {
        return pcsFlowerDeliveryService.updateFlowerRecipeById(pcsFlowerDeliveryRecipe);
    }

    public boolean updateFlowerDeliveryById(PcsFlowerDelivery pcsFlowerDelivery) {
        return pcsFlowerDeliveryService.updateFlowerDeliveryById(pcsFlowerDelivery);
    }

    public boolean updateFlowerDeliveryUseableById(PcsFlowerDelivery pcsFlowerDelivery) {
        return pcsFlowerDeliveryService.updateFlowerDeliveryUseableById(pcsFlowerDelivery);
    }

    public String createFlowerPrdcPreJob(PcsPreAllotVO vo){
        return prdcJobService.createFlowerPrdcPreJob(vo);
    }
    
    public boolean isSplitBySkuCode(String skuCode){
    	return prdcJobService.isSplitBySkuCode(skuCode);
    }

    /**
     * 官网和天猫鲜花月送下单判断库存接口
     * @param monthlyQueryDTO
     * @param date
     * @param channelCode
     * @return
     */
    public PcsFlowerDeliveryDate getFlowerStockAndDate(SFlowerMonthlyQueryDTO monthlyQueryDTO, Date date, String channelCode){
    	 return pcsFlowerDeliveryService.getFlowerStockAndDate(monthlyQueryDTO, date, channelCode);
    }

    /**
     * 查询所有鲜花月送SKU可售数量小于安全库存
     * @return
     */
    List<PcsFlowerMerchantibleVO> getFlowerSellNumber() {
        return pcsFlowerDeliveryService.getFlowerSellNumber();
    }
    
    public List<PcsFlowerSkuStatisticsVO> requiredSuppliesStatistics(String startDate, String endDate) {
    	return pcsFlowerDeliveryService.requiredSuppliesStatistics(startDate, endDate);
    }

    public void importFlowerRecipeMaterial(List<FlowerRecipeMaterialVO> list, String skuCode, int isCycle, String effectDate) {
        pcsFlowerDeliveryService.importFlowerRecipeMaterial(list, skuCode, isCycle, effectDate);
    }

    public Boolean updateFlowerPlanQuantity(PcsFlowerRecipePlanCond cond) throws Exception{
        return pcsFlowerDeliveryService.updateTmallFlowerPlanQuantity(cond);
    }

    /**
     * 根据费用id查询费用信息
     * @param costId
     * @return
     */
    public PcsPoPlanCost selectCostByCostId(Long costId){
    	return pcsPoPlanService.selectCostByCostId(costId);
    }
    public int delPoPlanFee(Long poPlanFeeId) {
      return pcsPoPlanService.delPoPlanFee(poPlanFeeId);
    }
    public List<FpcsConsumableAllotSummaryVO> findApplySummaryBySku(Integer type, String skuCode, List<String> warehouseCodeList) {
        return  fpcsSkuService.findApplySummaryBySku(type, skuCode, warehouseCodeList);
    }

    public List<FpcsConsumableImportLog> findLastImportLogs() {
        return  fpcsSkuService.findLastImportLogs();
    }

    public List<Integer> saveLastImportLogs(List<FpcsConsumableImportLog> importDatas) {
        return  fpcsSkuService.saveLastImportLogs(importDatas);
    }


    /**
	 * 根据登陆的Id查询其对应的成本中心（二级品类）
	 * 登陆id若是查询多个买手账号则取并集
	 * （isFindAll:为true时买手关联的商业品类要是没有则查询所有的成本中心，否则查询为空）
	 * @param loginUserId
	 * @param isFindAll
	 * @return
	 */
    public List<PcsCostCenter> selectPcsCategoryCostCenterByLoginId(Long loginUserId, Boolean isFindAll) {
    	return pcsCategoryCostCenterService.selectPcsCategoryCostCenterByLoginId(loginUserId, isFindAll);
    }

    public Integer closePopPlanEndMonth () {
        return pcsPoPlanService.closePopPlanEndMonth();
    }

    /**
     * 根据pop状态和skucode 查询所有pop收货计划
     * @param params
     * @return
     */
    public List<PcsPoPlanLineVO> findPcsPoPlanLineListByParams(Map<String,Object> params){
    	return pcsPoPlanLineService.findPcsPoPlanLineListByParams(params);
    }

    /**
     * 查询采购单收货计划
     * @param poId
     * @return
     */
    public List<PcsPoLineVO> findPoSkuByPoId1(long poId) {
        return pcsPoLineService.findPoSkuByPoId(poId);
    }
    /**
     * 通过采购单编号查找sku
     * @param poCode
     * @return
     */
    public List<PcsPoLineVO> findSkuByPoCode(String poCode) {
        return pcsPoLineService.findSkuByPoCode(poCode);
    }

    public boolean updatePcsPoPlanWarnFlagByIds(List<Long> ids){
        return pcsPoPlanService.updatePcsPoPlanWarnFlagByIds(ids);
    }

    public int reopenPurchaseOrder(Long poId, Date askDeliveryDate) {
        return  pcsPurchaseOrderService.reopenPurchaseOrder(poId, askDeliveryDate);
    }

    public void closePop() {
        pcsCronService.closePop();
    }

    public List<Long> closePurchaseOrder(){
        return pcsCronService.closePurchaseOrder();
    }

    public List<Long> closePoAndPopOnEveryDayTiming(List<PcsPoPlan> poPlanList) {
        return pcsCronService.closePoAndPopOnEveryDayTiming(poPlanList);
    }

    public List<PcsPurchaseOrder> findNeedToClosedPO() {
        return  pcsPurchaseOrderService.findNeedToClosedPO();
    }

    public List<PcsPurchaseOrderVO> findNearestPurchaseOrderBySkuCodes(List<String> skuCodes) {
        return pcsPurchaseOrderService.findNearestPurchaseOrderBySkuCodes(skuCodes);
    }

   public FpcsConsumableAllot findFpcsConsumableAllotBySkuCode(String skuCode) {
        return  fpcsSkuService.findFpcsConsumableAllotBySkuCode(skuCode);
    }

    public void cronSendApprovalEmail() {
        log.info("[定时发送待审核信息]PcsPoPlanCron.cron begin at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        System.out.println("[定时发送待审核信息]PcsPoPlanCron.cron begin at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        pcsCronService.cronSendApprovalEmail();
        log.info("[定时发送待审核信息]PcsPoPlanCron.cron end at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
    }

    public void flowerStockWarning() {
        pcsCronService.flowerStockWarning();
    }

    public void flowerFinishStateChange() {
        pcsCronService.flowerFinishStateChange();
    }

    public void autoUpdateServiceLevel() {
        log.info("[定时更新sku重要等级]PcsCron.cron begin at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        mcPcsSkuService.autoUpdateServiceLevel();
        log.info("[定时更新sku重要等级]PcsCron.cron end at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
    }
    public void cronSynPoPlanAndLine() {
        log.debug("[同步采购单收货信息]PcsPoPlanCron.cron begin at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        pcsCronService.cronSynPoPlanAndLine();
        log.debug("[同步采购单收货信息]PcsPoPlanCron.cron end at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
    }

    public void updatePrdcJobWhenTaskFinishCron(){
        final CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("prdcJobFinishCheck");
        if(config == null){
            return;
        }
        String value = config.getConfigValue();
        if(!StringUtils.isEmpty(value) && "1".equals(value)){
            prdcJobService.updatePrdcJobWhenTaskFinish(null);
        }
    }

    public void autoCreatePrdcJobByPreJob(){
        PrdcJobCond cond = new PrdcJobCond();
        cond.setPagenum(999999);
        List<Integer> statusList = new ArrayList<>();
        statusList.add(PrdcPreJob.PRE_JOB_STATUS_INIT);
        statusList.add(PrdcPreJob.PRE_JOB_STATUS_PROCESSING);
        cond.setPlanStatusList(statusList);
        List<PrdcPreJobVO> prdcPreJobVOs = prdcJobService.findPreJobListByCond(cond);
        Long prdcId = null;
        if(prdcPreJobVOs != null && prdcPreJobVOs.size() > 0){
            for(int i = prdcPreJobVOs.size() -1;i >= 0;i--){
                try{
                    PrdcPreJobVO vo = prdcPreJobVOs.get(i);
                    prdcId = prdcJobService.processPrdcPreJob(vo);
                    if (!NumberUtil.isNullOrZero(prdcId)){
                        // 保存日志
                        saveScmEntityOperationLog("系统自动创建加工单", "PrdcJob", prdcId+"");
                    }
                }catch (Exception e){
                    e.getMessage();
                }
            }
        }
    }
    public void saveScmEntityOperationLog(String operationDesc, String entityClazz, String entityId) {
        Integer operationType = CommEntityOpRcd.TYPE_ADD;
        Long operatorId = 1L;
        String operatorName = "系统";
        CommEntityOpRcd commEntityOpRcd = new CommEntityOpRcd();
        commEntityOpRcd.setOperatorId(operatorId);
        commEntityOpRcd.setOperatorName(operatorName);
        commEntityOpRcd.setOperationType(operationType);
        commEntityOpRcd.setOperationDesc(operationDesc);
        commEntityOpRcd.setEntityName(entityClazz);
        commEntityOpRcd.setEntityId(entityId);
        pegasusUtilFacade.insertEntityOperationRcd(commEntityOpRcd);
    }

    public void sendPreJobDiffAlertDataToEmail() {
        log.info("[发送预加工单差异提醒]PcsPrdcJobCron.sendPreJobDiffAlertDataToEmail begin at "
                + DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        PrdcJobCond cond = new PrdcJobCond();
        // 查询 昨天0点到23点 预计完成的加工单
        String preDay = DateUtil.format(DateUtil.addDay(DateUtil.getNow(),-1),DateUtil.DEFAULT_DATE_FORMAT);
        cond.setEstDoneDateBegin(preDay);
        cond.setEstDoneDateEnd(preDay);
        cond.setPlanStatus(PrdcPreJob.PRE_JOB_STATUS_FINISH);
        List<PrdcPreJobVO> prdcPreJobVOs = prdcJobService.findPreJobListByCond(cond);
        if (CollectionUtils.isNotEmpty(prdcPreJobVOs)){
            for (PrdcPreJobVO preAllotRcdVO : prdcPreJobVOs){
                // 预加工单 预计日期关闭[即状态完成]，且预计生产数量与实际生产数量有差额时，发邮件通知预加工单创建人
                if (preAllotRcdVO.getEstQuantity() != preAllotRcdVO.getFinishedQuantity()){
                    preAllotRcdVO.setSendMailFlag(true);
                }else{
                    preAllotRcdVO.setSendMailFlag(false);
                }
            }
        }

        // 组装需要发送的邮件数据
        Map<Long,List<PrdcPreJobVO>> preAllotDiffAlertDatas = new HashMap<>();
        if (CollectionUtils.isNotEmpty(prdcPreJobVOs)) {
            for (PrdcPreJobVO preAllotRcdVO : prdcPreJobVOs) {
                if (preAllotRcdVO.getSendMailFlag() && EmptyUtil.isNotEmpty(preAllotRcdVO.getCreateOperatorId())) {
                    // 预计生产数量与实际生产数量有差额
                    preAllotRcdVO.setQuantityDiff(((preAllotRcdVO.getEstQuantity() == null ? 0 : preAllotRcdVO.getEstQuantity()) -
                            (preAllotRcdVO.getFinishedQuantity() == null ? 0 : preAllotRcdVO.getFinishedQuantity())));
                    if (CollectionUtils.isNotEmpty(preAllotDiffAlertDatas.get(preAllotRcdVO.getCreateOperatorId()))) {
                        preAllotDiffAlertDatas.get(preAllotRcdVO.getCreateOperatorId()).add(preAllotRcdVO);
                    } else {
                        List<PrdcPreJobVO> voList = new ArrayList<>();
                        voList.add(preAllotRcdVO);
                        preAllotDiffAlertDatas.put(preAllotRcdVO.getCreateOperatorId(), voList);
                    }
                }
            }
        }
        if (EmptyUtil.isNotEmpty(preAllotDiffAlertDatas)){
            for (Map.Entry<Long, List<PrdcPreJobVO>> entry : preAllotDiffAlertDatas.entrySet()) {
                EmailVO emailVO = buildPreJobDiffAlertDataEmail(entry.getValue(),entry.getKey());
                if(EmptyUtil.isEmpty(emailVO)){
                    log.info("预加工单差异提醒 :没有要发送的内容");
                }else{
                    boolean tf = EmailUtil.getInstance().send(emailVO);
                    log.info("预加工单差异提醒  发送: " + tf);
                }
                log.info("[发送预加工单差异提醒]PcsPrdcJobCron.sendPreJobDiffAlertDataToEmail end at "
                        + DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
            }
        }
    }

    private EmailVO buildPreJobDiffAlertDataEmail(List<PrdcPreJobVO> preJobDiffAlertDatas,Long createUserId){
        if(CollectionUtils.isEmpty(preJobDiffAlertDatas)){
            return null;
        }
        String email = prdcJobService.findScmOperatorEmailByOperatorId(createUserId);
        if (EmptyUtil.isEmpty(email)){
            return null;
        }
        List<List<String>> lines = new ArrayList<>();
        List<String> head = new ArrayList<>();
        head.add("预加工单号");
        head.add("生产加工仓");
        head.add("加工类型");
        head.add("成品SKU");
        head.add("预计加工数量");
        head.add("已加工数量");
        head.add("差额");
        lines.add(head);
        for(PrdcPreJobVO preJobRcdVO : preJobDiffAlertDatas){
            List<String> row = new ArrayList<>();
            row.add(preJobRcdVO.getCode());
            row.add(preJobRcdVO.getWarehouseName());
            row.add(preJobRcdVO.getJobTypeStr());
            row.add("["+preJobRcdVO.getSkuCode()+"]"+preJobRcdVO.getSkuName());
            row.add(preJobRcdVO.getEstQuantity()+"");
            row.add(preJobRcdVO.getFinishedQuantity()+"");
            row.add(preJobRcdVO.getQuantityDiff()+"");
            lines.add(row);
        }
        byte[] bytes = ExcelUtil.write("预加工单差异提醒", lines, true);
        EmailVO emailVO = new EmailVO();

        // 创建人SCM账号—邮箱
        emailVO.setToAddressList(Arrays.asList(email));
        // 抄送人
        emailVO.setToCopyList(Arrays.asList(PegasusUtilFacade.getInstance().
                findConfigByKey("sendPreJobDiffAlertDataToEmail.copyAddress").getConfigValue().split(",")));

        String todayStr = DateUtil.format(DateUtil.getNow(), DateUtil.DEFAULT_DATETIME_FORMAT);
        emailVO.setSubject("预加工单差异提醒-"+todayStr);
        emailVO.setContent("预加工单差异提醒-"+todayStr);
        List<EmailAttachmentVO> attachmentList = new ArrayList<>();
        attachmentList.add(new EmailAttachmentVO("预加工单差异提醒-"+todayStr+".xls", bytes));
        emailVO.setAttachmentList(attachmentList);
        return emailVO;
    }

    public void autoSubmitCertificate(){
        log.info("[sku标签自动提交]PcsSkuCertificateCron.autoSubmitCertificate begin at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        List<String> skuCodes = pcsSkuCertificateService.findSkuCodeNeedAutoSubmit();
        if(com.thebeastshop.common.utils.EmptyUtil.isEmpty(skuCodes)){
            return;
        }
        PcsSkuCertificateVO  defaultCerVO = buildEmptyCerSubmit();
        for(String skuCode : skuCodes){
            try{
                defaultCerVO.setSkuCode(skuCode);
                pcsSkuCertificateService.save(defaultCerVO);
            }catch (Exception e){
                e.printStackTrace();
                log.info(String.format("[%s]简易标签生成失败！",skuCode));
            }
        }
        log.info("[sku标签自动提交]PcsSkuCertificateCron.autoSubmitCertificate end at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
    }

    private PcsSkuCertificateVO buildEmptyCerSubmit(){
        PcsCertificateTplVO simpleTpl = pcsCertificateTplService.findById(16L,true);//简易模板
        if(NullUtil.isNull(simpleTpl)){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,"简易模板不存在！");
        }
        if(com.thebeastshop.common.utils.EmptyUtil.isEmpty(simpleTpl.getAvaliableSize())|| !simpleTpl.getAvaliableSize().contains(PrintSkuCerVO.DEFAULT_CER_SIZE)){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,"简易模板不支持18*48尺寸！");
        }
        PcsCertificateTplFieldVO tplField = getSkuNameCerField(simpleTpl);
        PcsSkuCertificateVO cerVO = new PcsSkuCertificateVO();
        Date now = DateUtil.getNow();
        cerVO.setIsHasTag(PcsSkuCertificateVO.HAS_TAG_NO);
        cerVO.setCheckStatus(PcsSkuCertificateVO.CHECK_STATUS_NOT_AUDITED);
        cerVO.setIsSubmit(PcsSkuCertificateVO.SUBMIT_STATUS_NOT_SUBMIT);
        cerVO.setNeedProdDate(PcsSkuCertificateVO.NEED_PROD_DATE_NO);
        cerVO.setCerType(PcsSkuCertificateVO.CER_TYPE_SIMPLE);
        cerVO.setCreateUserId(1L);//system
        cerVO.setCreateTime(now);
        cerVO.setLastUpdateUserId(null);
        cerVO.setLastUpdateTime(null);
        cerVO.setCertificateSize(PrintSkuCerVO.DEFAULT_CER_SIZE);
        cerVO.setCerTplId(simpleTpl.getId());
        List<PcsSkuCertificateFieldVO> cerFields = new ArrayList<>();
        PcsSkuCertificateFieldVO cerField = new PcsSkuCertificateFieldVO();
        cerField.setCerTplFieldId(tplField.getId());
        cerField.setSortOrder(tplField.getSortOrder());
        cerField.setValue(null);
        cerFields.add(cerField);
        cerVO.setFieldList(cerFields);
        return cerVO;
    }

    //获取品名字段
    private PcsCertificateTplFieldVO getSkuNameCerField(PcsCertificateTplVO tplVO){
        PcsCertificateTplFieldVO skuNameCerField = null;
        if(com.thebeastshop.common.utils.EmptyUtil.isEmpty(tplVO.getTplFieldVOList())){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,"简易模板字段为空！");
        }
        for(PcsCertificateTplFieldVO cerField : tplVO.getTplFieldVOList()){
            if("品名".equals(cerField.getName())){
                skuNameCerField = cerField;
                break;
            }
        }
        if(NullUtil.isNull(skuNameCerField)){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,"品名字段不存在！");
        }
        return skuNameCerField;
    }

    public void cronSendEmailByWasteAterPopFinished () {
        pcsCronService.cronSendEmailByWasteAterPopFinished();
    }

    public void sendPopEmailByCond (PcsPoPlanVO cond) {
        pcsPoPlanService.sendPopEmailByCond(cond);
    }

    public List<PcsPoPlanVO> findWasteAfterPopFinished(PcsPoPlanVO cond){
        return pcsPoPlanService.findWasteAfterPopFinished(cond);
    }

    public List<PrdcRecipeMaterialSimpleVO> findBottomMaterialByRecipeSkuCodes(List<String> skuCodes) {
        return  prdcRecipeService.findBottomMaterialByRecipeSkuCodes(skuCodes);
    }

    public List<String> findPhyWhFlowerMonthyCapacitySeted(String skuCode){
        return pcsFlowerDeliveryService.findPhyWhFlowerMonthyCapacitySeted(skuCode);
    }

    public PageInfo findCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        return pcsFlowerDeliveryService.findCapacityByCond(cond);
    }

    public int saveOrUpdate(List<PcsFlowerMonCapaSettingVO> records)throws Exception {
        return pcsFlowerDeliveryService.saveOrUpdate(records);
    }

    public List<PcsFlowerMonCapaLogVO> findPcsFlowerMonCapaLogBySkuCode(String skuCode) {
        return pcsFlowerDeliveryService.findPcsFlowerMonCapaLogBySkuCode(skuCode);
    }

    public List<PcsFlowerMonCapaSettingVO> findCityCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        return pcsFlowerDeliveryService.findCityCapacityByCond(cond);
    }
    public int saveCapacityChangeLogs(List<PcsFlowerMonthlyCapacityLog> logs) {
        return pcsFlowerDeliveryService.saveCapacityChangeLogs(logs);
    }

    public List<PcsFlowerMonCapaSettingVO> findCapacityByUniqueIndex(List<PcsFlowerDeliveryCapacityCond> conds) {
        return  pcsFlowerDeliveryService.findCapacityByUniqueIndex(conds);
    }

    public Map<String, Integer> findCurrentTaskQuntity(String skuCode, List<Integer> cityIds, SFlowerProductionTypeEnum productionTypeEnum) {
        return pcsFlowerDeliveryService.findCurrentTaskQuntity(skuCode, cityIds, productionTypeEnum);
    }
    public List<PcsFlowerMonCapaSettingVO> findAllWhCapacityDataBySkucode(String skuCode) {
        return pcsFlowerDeliveryService.findAllWhCapacityDataBySkucode(skuCode);
    }

    public Map<String, PcsFlowerDeliveryDate> getFlowerStockAndDate(List<SFlowerMonthlyQueryDTO> queryList, Date date, String channelCode) {
        return  pcsFlowerDeliveryService.getFlowerStockAndDate(queryList, date, channelCode);
    }

    public int batchInsert(List<PcsBaseTaxRateVO> taxRateList, List<PcsBaseTaxRateVO> newTaxRateList) {
        return pcsBaseTaxRateService.batchInsert(taxRateList, newTaxRateList);
    }

    public PageInfo<PcsBaseTaxRateVO> findPageBaseTaxRateByCond(PcsBaseTaxRateCond taxRateCond) {
        return pcsBaseTaxRateService.findPageBaseTaxRateByCond(taxRateCond);
    }

    /**
     * 根据参数查询税率
     * @param nameCode
     * @return
     */
    public List<PcsBaseTaxRateVO> findBaseTaxRateByNameOrCode(String nameCode){
    	return pcsBaseTaxRateService.findBaseTaxRateByNameOrCode(nameCode);
    }

    public PcsBaseTaxRateVO findPcsBaseTaxRateById(String id) {
        return pcsBaseTaxRateService.findPcsBaseTaxRateById(id);
    }

    public PcsBaseTaxRateVO findBaseTaxRateByTaxId(String taxId) {
        return pcsBaseTaxRateService.findBaseTaxRateByTaxId(taxId);
    }

    public List<String> findAllTaxId() {
        return  pcsBaseTaxRateService.findAllTaxId();
    }

    public Pagination<PcsSkuCustomBckVO> findPcsSkuCustomBckByCond(PcsSkuCustomBckCond cond) {
        return pcsSkuCustomBckService.findByCond(cond);
    }

    public Integer countByCond (PcsSkuCustomBckCond cond) {
        return pcsSkuCustomBckService.countByCond(cond);
    }

    public Integer approveOrRefuseSkuCustomBck(Integer id,Integer status,String customBckCode,String remark) {
        return pcsSkuCustomBckService.approveOrRefuseSkuCustomBck(id,status,customBckCode,remark);
    }
    public Integer insertWhenNotExist(PcsSkuCustomBck pcsSkuCustomBck) {
        return pcsSkuCustomBckService.insertWhenNotExist(pcsSkuCustomBck);
    }

    public int savePopLogisticsBill(PcsPoPlanLogisticsBillVO logisticsBill) {
      return pcsPoLogisticsBillService.savePopLogisticsBill(logisticsBill);
    }
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillById(Integer billId) {
      return pcsPoLogisticsBillService.getPcsPoPlanLogisticsBillById(billId);
    }
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopCode(String popCode) {
        return  pcsPoLogisticsBillService.getPcsPoPlanLogisticsBillByPopCode(popCode);
    }

    public PageInfo<PcsPoPlanLogisticsBillVO> listBillByCond(PoLogisticsBillCond cond) {
        return  pcsPoLogisticsBillService.listBillByCond(cond);
    }

    public int savePopLogisticsBills(List<PcsPoPlanLogisticsBillVO> logisticsBills) {
        return pcsPoLogisticsBillService.savePopLogisticsBills(logisticsBills);
    }
    public List<PoLogisticsBillStatusTab> countGroupByBillstatus(PoLogisticsBillCond cond) {
        return  pcsPoLogisticsBillService.countGroupByBillstatus(cond);
    }
    public int cancelPopLogisticsBill(Integer id) {
       return pcsPoLogisticsBillService.cancelPopLogisticsBill(id);
    }

   public List<PcsPoPlanLogisticsBillVO> listLogisticsBillByPoId(Long poId) {
        return pcsPoLogisticsBillService.listLogisticsBillByPoId(poId);
    }

    public Map<String, PrdcRecipeVO> mapRecipeVOBySkuCode(List<String> skuCodes) {
        return prdcRecipeService.mapRecipeVOBySkuCode(skuCodes);
    }

    public List<PrdcJobVO> findNearestJobBySkuCodes(List<String> skuCodes) {
        return prdcJobService.findNearestJobBySkuCodes(skuCodes);
    }

   public PageInfo<PcsPoProgressTrackingVO> pageQueryTrackingProgressByCond(PcsPurchaseOrderCond cond) {
     return pcsPurchaseOrderService.pageQueryTrackingProgressByCond(cond);
    }

   public List<PcsPoLineVO> findPoLineByPoIds(final List<Long> poIds) {
     return pcsPoLineService.findPoLineByPoIds(poIds);
   }

   public List<PcsPoPlanLineVO> sumPopSkuTotalQuantity(List<Long> popIds) {
     return  pcsPoPlanLineService.sumPopSkuTotalQuantity(popIds);
    }

    public List<PcsPoProgressTrackingDetailVO> queryTrackingProgressDetailByCond(PcsPurchaseOrderCond cond) {
      return pcsPurchaseOrderService.queryTrackingProgressDetailByCond(cond);
    }

    //门店鲜花采购---------start
    //鲜花基础信息
    public Integer addOrEditPurchaseFlower(PcsPurchaseFlowerVO pcsPurchaseFlower) {
        return pcsPurchaseFlowerService.addOrEditPurchaseFlower(pcsPurchaseFlower);
    }

    public Pagination<PcsPurchaseFlowerVO> findByCond(PcsPurchaseFlowerCond cond) {
        return pcsPurchaseFlowerService.findByCond(cond);
    }

    public PcsPurchaseFlowerVO findById(Integer id) {
        return pcsPurchaseFlowerService.findById(id);
    }

    public List<PcsPurchaseFlowerVO> findByCondForExport(PcsPurchaseFlowerCond cond) {
        return pcsPurchaseFlowerService.findByCondForExport(cond);
    }

    public Integer updateByExample(PcsPurchaseFlowerVO pcsPurchaseFlowerVO) {
        return pcsPurchaseFlowerService.updateByExample(pcsPurchaseFlowerVO);
    }

    public Integer batchUpdateByCode(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        return pcsPurchaseFlowerService.batchUpdateByCode(pcsPurchaseFlowers);
    }
    public Integer batchInsertPurchaseFlower(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        return pcsPurchaseFlowerService.batchInsert(pcsPurchaseFlowers);
    }

    public List<PcsPurchaseFlowerVO> findPurchaseFlowerByNameOrCodeLike (String channelCode,String nameOrCode,Integer unitConfigId) {
        return pcsPurchaseFlowerService.findPurchaseFlowerByChannelCodeAndCodeOrName(channelCode,nameOrCode,unitConfigId);
    }


    //供应商信息
    public Pagination<PcsPurchaseFlowerSupplierVO> findPurchaseFlowerSupplierByCond(PcsPurchaseFlowerSupplierCond cond) {
        return pcsPurchaseFlowerSupplierService.findByCond(cond);
    }

    public Integer addOrEditPurchaseFlowerSupplier(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerSupplierVO) {
        return pcsPurchaseFlowerSupplierService.addOrEditPurchaseFlowerSupplier(pcsPurchaseFlowerSupplierVO);
    }

    public PcsPurchaseFlowerSupplierVO findPurchaseFlowerSupplierById(Integer id) {
        return pcsPurchaseFlowerSupplierService.findById(id);
    }

    public List<PcsPurchaseFlowerSupplierVO> findPurchaseFlowerSupplierByCondForExport(PcsPurchaseFlowerSupplierCond cond) {
        return pcsPurchaseFlowerSupplierService.findByCondForExport(cond);
    }

    public Integer updatePurchaseFlowerSupplierByExample(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerSupplierVO) {
        return pcsPurchaseFlowerSupplierService.updateByExample(pcsPurchaseFlowerSupplierVO);
    }

    public Integer batchUpdatePurchaseFlowerSupplierByCode(List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowerSuppliers) {
        return pcsPurchaseFlowerSupplierService.batchUpdateByCode(pcsPurchaseFlowerSuppliers);
    }
    public Integer batchInsertPurchaseFlowerSupplier (List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowerSuppliers) {
        return pcsPurchaseFlowerSupplierService.batchInsert(pcsPurchaseFlowerSuppliers);
    }

    public List<PcsPurchaseFlowerSupplierVO> findAllSupplier() {
        return pcsPurchaseFlowerSupplierService.findAllSupplier();
    }
    public List<PcsPurchaseFlowerSupplierVO> findSupplierByNameOrCodeLike(String term) {
        return pcsPurchaseFlowerSupplierService.findByNameOrCodeLike(term);
    }

    public Pagination<PurchaseFlowerPlanVO> findByCond(PurchaseFlowerPlanCond cond){
        return purchaseFlowerPlanService.findByCond(cond);
    }

    public List<PurchaseFlowerPlanVO> findByCondForExportExcel(PurchaseFlowerPlanCond cond){
        return purchaseFlowerPlanService.findByCondForExportExcel(cond);
    }

    public Integer addOrEditPurchaseFlowerPlan(PurchaseFlowerPlanVO purchaseFlowerPlanVO){
        return purchaseFlowerPlanService.addOrEditPurchaseFlowerPlan(purchaseFlowerPlanVO);
    }

    public PurchaseFlowerPlanVO findPurchaseFlowerPlanById(Integer id) {
        return  purchaseFlowerPlanService.findById(id);
    }

    public Pagination<PcsPurchaseFlowerReceiveOrderVO> findPurchaseFlowerReceiveOrderByCond(PurchaseFlowerReceiveOrderCond cond) {
        return purchaseFlowerReceiveOrderService.findByCond(cond);
    }

    public List<PcsPurchaseFlowerReceiveOrderVO> findByCondForExportExcel(PurchaseFlowerReceiveOrderCond cond) {
        return purchaseFlowerReceiveOrderService.findByCondForExportExcel(cond);
    }

    public Integer addOrEditPurchaseFlowerReceiveOrder(PcsPurchaseFlowerReceiveOrderVO vo) {
        return purchaseFlowerReceiveOrderService.addOrEditPurchaseFlowerReceiveOrder(vo);
    }

    public PcsPurchaseFlowerReceiveOrderVO findPurchaseFlowerReceiveOrderById(Integer id) {
        return purchaseFlowerReceiveOrderService.findById(id);
    }

    public Pagination<PurchaseFlowerReportVO> findPurchaseFlowerAchievementReportByCond(PurchaseFlowerAchievementReportCond cond) {
        return pcsPurchaseFlowerAchievementService.findPurchaseFlowerAchievementReportByCond(cond);
    }

    public Integer checkInAchievement(PcsPurchaseFlowerAchievement pcsPurchaseFlowerAchievement) {
        return pcsPurchaseFlowerAchievementService.checkInAchievement(pcsPurchaseFlowerAchievement);
    }

    public Pagination<PurchaseFlowerSupplierReportVO> findSupplierReportByCond(PurchaseFlowerSupplierReportCond cond) throws ParseException {
        return purchaseFlowerReceiveOrderService.findSupplierReportByCond(cond);
    }

    public String getOrCreateSkuCerMpCode(String skuCode) {
      return pcsSkuCertificateService.getOrCreateSkuCerMpCode(skuCode);
    }

    public boolean addOrEditPcsSkuAutoApproveRule(PcsSkuFinanceAutoApproveRuleVO ruleVO) {
        return pcsSkuAutoApproveRuleService.addOrEdit(ruleVO);
    }

    public PcsSkuFinanceAutoApproveRuleVO findPcsSkuFinanceAutoApproveRuleVO(PcsSkuFinanceAutoApproveRuleCond cond){
        return pcsSkuAutoApproveRuleService.findPcsSkuFinanceAutoApproveRuleVO(cond);
    }

    public Map<Integer, BigDecimal> getPcsSkuFinanceAutoApproveRuleForCostRiseUnder(){
        return pcsSkuAutoApproveRuleService.getPcsSkuFinanceAutoApproveRuleForCostRiseUnder();
    }

    public List<PcsSkuAutoApproveBgmVO> listAllPcsSkuAutoApproveBgmVO(){
        return pcsSkuAutoApproveRuleService.listAllPcsSkuAutoApproveBgmVO();
    }

    public List<PcsSkuAutoApproveBgm> listPcsSkuAutoApproveBgmByCond(PcsSkuAutoApproveBgmCond cond){
        return pcsSkuAutoApproveRuleService.listPcsSkuAutoApproveBgmByCond(cond);
    }

    public List<PcsSkuAutoApproveBgmVO> listAllFirstCategoryBgmVO(){
        return pcsSkuAutoApproveRuleService.listAllFirstCategoryBgmVO();
    }

    public List<PcsSkuAutoApproveBgmVO> listCategoryBgmVOByCond(PcsSkuAutoApproveBgmCond cond){
        return pcsSkuAutoApproveRuleService.listCategoryBgmVOByCond(cond);
    }

    public boolean batchAddPcsSkuAutoApproveBgm(List<PcsSkuAutoApproveBgm> list, Boolean needEmpty){
        return pcsSkuAutoApproveRuleService.batchAddPcsSkuAutoApproveBgm(list, needEmpty);
    }
    public int withdrawApproval(Long poId) {
      return pcsPurchaseOrderService.withdrawApproval(poId);
    }

    public List<PcsPoLineVO> findPoApprovalRecordLine(Long poId) {
      return pcsPurchaseOrderService.findPoApprovalRecordLine(poId);
    }
    public PcsPurchaseOrderVO findPoVOById(long id, boolean cascadeLine) {
      return pcsPurchaseOrderService.findPoVOById(id, cascadeLine);
    }
    public List<PcsPurchaseOrderVO> listPoVOByIds(List<Long> ids, boolean cascadeLine) {
        return pcsPurchaseOrderService.listPoVOByIds(ids, cascadeLine);
    }
    public PcsPurchaseOrderVO findPoVOForApprovalById(long id, boolean cascadeLine) {
      return pcsPurchaseOrderService.findPoVOForApprovalById(id, cascadeLine);
    }

    public PcsPurchaseOrderVO findPoVOByCond(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderService.findPoVOByCond(cond);
    }

    public Map<String, Integer> computeRealityGoodQuantityByPoId(Long poId){
        return pcsPurchaseOrderService.computeRealityGoodQuantityByPoId(poId);
    }

    public List<Long> findCanAutoCreatePopPoIds() {
      return pcsPurchaseOrderService.findCanAutoCreatePopPoIds();
    }
    public int savePopLines(List<PcsPoPlanLineVO> lineList) {
      return pcsPoPlanLineService.update(lineList);
    }

    public Map<String, Integer> mapRefundedGoodQuantityByPoIdAndSkuCode(Long poId) {
        return pcsPurchaseOrderService.mapRefundedGoodQuantityByPoIdAndSkuCode(poId);
    }

    public List<PcsFinancePaymentVO> selectNotNotifyPoPaymentInfo() {
        return pcsFinancePaymentService.selectNotNotifyPoPaymentInfo();
    }

    public int updatePoPaymentNotifyStatus(List<Integer> ids) {
        return pcsFinancePaymentService.updatePoPaymentNotifyStatus(ids);
    }

    public List<PcsPoPlanLineVO> listPopLineIncludeWaste(List<Long> poIds) {
        return pcsPoPlanLineService.listIncludeWaste(poIds);
    }

}