package com.thebeastshop.pegasus.report.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class LongUrlToShort {
	
/*
	public static String longUrl2Short(String longUrl) {
		 //创建HttpClientBuilder
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        //HttpClient
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();

        HttpPost httpPost = new HttpPost("http://dwz.cn/create.php");
        List<NameValuePair> params = new ArrayList<NameValuePair>();  
        params.add(new BasicNameValuePair("url", longUrl));  
			
        //System.out.println(httpGet.getRequestLine());
        try {
        	 httpPost.setEntity(new UrlEncodedFormEntity(params,"UTF-8"));
            //执行get请求
            HttpResponse httpResponse = closeableHttpClient.execute(httpPost);
            //获取响应消息实体
            HttpEntity entity = httpResponse.getEntity();
            //响应状态
            System.out.println("status:" + httpResponse.getStatusLine());
            //判断响应实体是否为空
            if (entity != null) {
                //System.out.println("contentEncoding:" + entity.getContentEncoding());
               // System.out.println("response content:" + EntityUtils.toString(entity, "GBK"));
            	 JSONObject rootJsonObject = (JSONObject) JSON.parse(EntityUtils.toString(entity, "UTF-8"));
            	 int status = rootJsonObject.getIntValue("status");
            	 //失败
            	 if(status != 0) {
            		 return null;
            	 } else { //成功
            		 System.out.println(rootJsonObject.getString("tinyurl"));
            		 return rootJsonObject.getString("tinyurl");
            	 }
                 
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                //关闭流并释放资源
                closeableHttpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
	}
*/


    public static String longUrl2Short(String token, String baseUrl, String longUrl) {

        //创建HttpClientBuilder
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        //HttpClient
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        String sign =  DigestUtils.md5Hex(token);

        String urlParam = "";
        try {
            urlParam = URLEncoder.encode(longUrl, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpGet httpGet = new HttpGet(baseUrl + "/qrCode/getShortUrl?sign=" + sign + "&longUrl=" + urlParam);

        //System.out.println(httpGet.getRequestLine());
        try {
            //执行get请求
            HttpResponse httpResponse = closeableHttpClient.execute(httpGet);
            //获取响应消息实体
            HttpEntity entity = httpResponse.getEntity();
            //响应状态
            System.out.println("status:" + httpResponse.getStatusLine());
            //判断响应实体是否为空
            if (entity != null) {
                //System.out.println("contentEncoding:" + entity.getContentEncoding());
                // System.out.println("response content:" + EntityUtils.toString(entity, "GBK"));
                JSONObject rootJsonObject = (JSONObject) JSON.parse(EntityUtils.toString(entity, "GBK"));
                boolean status = rootJsonObject.getBoolean("success");
                //失败
                if(status) {
                    return rootJsonObject.getString("shortUrl");
                } else { //成功
                    return null;
                }

            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                //关闭流并释放资源
                closeableHttpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }


}
