package com.thebeastshop.pegasus.report.shorturl;

import com.alibaba.fastjson.JSONObject;
import com.dahantc.api.commons.EncryptUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.io.IOException;

public class DahanSanTongShortUrlClient {
    @Value("${scm.activity.dahansantong.short.url}")
    private static String DA_HAN_SAN_TONG_SHORT_URL = "http://www.dh3t.com/json/sms/GetShortUrl";
    @Value("${scm.activity.dahansantong.short.account}")
    private static String DA_HAN_SAN_TONG_SHORT_ACCOUNT = "dh27592";
    @Value("${scm.activity.dahansantong.short.pwd}")
    private static String DA_HAN_SAN_TONG_SHORT_PWD = "HR8P0Ge3";
    private final static Logger logger = LoggerFactory.getLogger(DahanSanTongShortUrlClient.class);

    public static String getShortUrl(String orgUrl){
        String shortUrl = null;

        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();

        try{
            HttpPost httpPost = new HttpPost(DA_HAN_SAN_TONG_SHORT_URL);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("account",DA_HAN_SAN_TONG_SHORT_ACCOUNT);
            jsonObj.put("password", EncryptUtil.MD5Encode(DA_HAN_SAN_TONG_SHORT_PWD));
            jsonObj.put("url",orgUrl);
            jsonObj.put("days",180);
            httpPost.setEntity(new StringEntity(jsonObj.toString(),"UTF-8"));
            HttpResponse httpResponse = HttpClient.execute(httpPost);
            HttpEntity entity = httpResponse.getEntity();
            if(!ObjectUtils.isEmpty(entity)){
                /*result	该次请求提交结果；说明请参照：提交响应错误码
                desc	结果描述
                shortUrl	长地址对应的短地址，只有result为0时才有值*/
                byte[] bytes = EntityUtils.toByteArray(entity);
                String ss = new String(bytes,"UTF-8");
                logger.info("getShortUrl:resp data={}",ss);
                JSONObject resp = JSONObject.parseObject(ss);
                if("0".equals(String.valueOf(resp.get("result")))){
                    shortUrl = resp.getString("shortUrl");
                }else{
                    logger.error("getShortUrl:---error={}----",resp.get("desc"));
                }

            }
        }catch (IOException e) {
            e.printStackTrace();
            return null;

        }catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return shortUrl;
    }

}
