package com.thebeastshop.pegasus.report.shorturl;

import org.forest.annotation.DataParam;
import org.forest.annotation.Request;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * 百度短链接API
 * @author gongjun[dt_flys@hotmail.com]
 * @since 2017-02-15 12:04
 */
public interface BaiduShortUrlClient {

    /**
     * 百度短链接API
     * @param url
     * @return
     */
    @Request(
            url = "http://api.weibo.com/2/short_url/shorten.json",
            type = "get",
            dataType = "json"
    )
    String getShortUrl(@DataParam("source") String source,@DataParam("url_long") String url);
    
    /**
     * 短链接API
     * @param url
     * @return
     */
    @Request(
            url = "http://suo.im/api.php",
            type = "get",
            dataType = "json"
    )
    String getNewShortUrl(@DataParam("url") String url);

}
