package com.thebeastshop.pegasus.report.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.report.service.ShortUrlService;
import com.thebeastshop.pegasus.report.shorturl.BaiduShortUrlClient;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * @author gongjun[dt_flys@hotmail.com]
 * @since 2017-02-15 12:11
 */
@Service("shortUrlServiceImpl")
public class ShortUrlServiceImpl implements ShortUrlService {

    @Autowired
    private BaiduShortUrlClient baiduShortUrlClient;



    @Override
    public String getShortUrl(String url) {
//      String result = baiduShortUrlClient.getShortUrl("3235337692",url);
    	String urlEncode = URLEncoder.encode(url);
    	
        try {
            HttpClient client = new DefaultHttpClient();
            //发送get请求
            HttpGet request = new HttpGet("http://suo.im/api.php?url=" + urlEncode);
            HttpResponse response = client.execute(request);

            /**请求发送成功，并得到响应**/
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                /**读取服务器返回过来的json字符串数据**/
                String strResult = EntityUtils.toString(response.getEntity());
                /**把json字符串转换成json对象**/
                return strResult;
            } else {
//                logger.error("get请求提交失败:" + url);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}
