package com.thebeastshop.pegasus.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.report.UrlConfig;
import com.thebeastshop.pegasus.report.dao.OpActivityChannelMapper;
import com.thebeastshop.pegasus.report.model.OpActivityChannel;
import com.thebeastshop.pegasus.report.service.OpActivityChannelService;
import com.thebeastshop.pegasus.report.service.ShortUrlService;
import com.thebeastshop.pegasus.report.shorturl.DahanSanTongShortUrlClient;
import com.thebeastshop.pegasus.report.vo.OpActivityChannelCond;
import com.thebeastshop.pegasus.util.comm.Base64Util;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;

@Service("opActivityChannelService")
@Transactional
public class OpActivityChannelServiceImpl implements OpActivityChannelService {

    @Autowired
    private OpActivityChannelMapper opActivityChannelMapper;

    public final static Integer ACCESS_SHORT_URL = 0;

    public final static Integer ACCESS_QR_CODE = 1;

    @Autowired
    private UrlConfig urlConfig;

    @Autowired
    private ShortUrlService shortUrlService;

    private final static Logger logger = LoggerFactory.getLogger(OpActivityChannelService.class);

    @Value("${scm.activity.channel.applet.toke.url}")
    private  String SCM_ACTIVITY_CHANNEL_APPLET_TOKEN_URL;

    @Override
    public Long create(OpActivityChannel record) {
        Integer accessType = record.getAccessType();
        record.setDeleteFlag(OpActivityChannel.DELETE_FLAG_0);
        this.opActivityChannelMapper.insertSelective(record);
        generateActivityCode(record);
        if("2".equals(record.getLinkType())){
            //小程序
            String accessToken = getAppletToken();
            System.out.println("accessToken:" + accessToken);
            generateTargetUrl(record);
            String normalQrCodeUrl = createwxaqrcode(record.getId(),record.getTargetUrl(),"1",accessToken);
            String specialQrCodeUrl = createwxaqrcode(record.getId(), record.getTargetUrl(), "0", accessToken);
            record.setQrCodeUrl(normalQrCodeUrl + "," + specialQrCodeUrl);
            String schemeUrl = createH5ShorLink(record.getId(), record.getTargetUrl(), accessToken);
            record.setSchemeUrl(schemeUrl);
            String shortUrl = DahanSanTongShortUrlClient.getShortUrl(schemeUrl);
            record.setShortUrl(shortUrl);
        }else{
            if (accessType == ACCESS_SHORT_URL) {
                String targetUrl = generateTargetUrl(record);
                String shortUrl = DahanSanTongShortUrlClient.getShortUrl(targetUrl);
                record.setShortUrl(shortUrl);
            }
            if (accessType == ACCESS_QR_CODE) {
                record.setQrCodeUrl(getQrCodeUrl(record));
            }
        }
        record.setCreateTime(new Date());
        this.opActivityChannelMapper.updateByPrimaryKeySelective(record);
        return 1L;
    }

    @Override
    public boolean create(List<OpActivityChannel> records) {
        for(OpActivityChannel record : records){
            create(record);
        }
        return true;
    }

    private String generateTargetUrl(OpActivityChannel record) {
        logger.info("record.getLinkType()",record.getLinkType());
        StringBuffer spliceUrl = new StringBuffer();
        if("2".equals(record.getLinkType())) {
            spliceUrl.append(record.getLongUrl());
            if(record.getLongUrl().indexOf("?") >= 0){
                spliceUrl.append("&_w="  + record.getCode());
            }else{
                spliceUrl.append("?_w="  + record.getCode());
            }
            spliceUrl.append("&utm_source="  + record.getCode());
        }
        else{
            try {
                URL url = new URL(record.getLongUrl());
                String protocol = url.getProtocol();
                String authority = url.getAuthority();
                String path = url.getPath();
                String query = url.getQuery();
                String androidTdHash = record.getAndroidTdHash();
                String iosTdHash = record.getIosTdHash();
                spliceUrl.append(protocol);
                spliceUrl.append("://");
                spliceUrl.append(authority);
                spliceUrl.append(path);

                String acParam = record.getCode().trim();
                String aParam = androidTdHash.trim();
                String iParam = iosTdHash.trim();
                try {
                    acParam = URLEncoder.encode(acParam, "UTF-8");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    iParam = URLEncoder.encode(iParam, "UTF-8");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    aParam = URLEncoder.encode(aParam, "UTF-8");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }

                    spliceUrl.append("?");
                    spliceUrl.append("_ac=" + acParam);
                    spliceUrl.append("&utm_source="  + acParam);
                    if (StringUtils.isNotBlank(iParam)) {
                        spliceUrl.append("&_i=" + iParam);
                    }
                    if (StringUtils.isNotBlank(aParam)) {
                        spliceUrl.append("&_a=" + aParam);
                    }
                    if (StringUtils.isNotEmpty(query)) {
                        spliceUrl.append("&" + query);
                    }


            } catch (MalformedURLException e) {
                return null;
            }
        }
        String targetUrl = spliceUrl.toString();
        record.setTargetUrl(targetUrl);
        return spliceUrl.toString();
    }


    public String generateActivityCode(OpActivityChannel record) {
        String code = "AC" + record.getAccessType() + record.getId();
        record.setCode(code);
        return code;
    }

    @Override
    public boolean update(OpActivityChannel record) {
        this.opActivityChannelMapper.updateByPrimaryKeySelective(record);
        return true;
    }

    @Override
    public OpActivityChannel findById(long id) {
        return this.opActivityChannelMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<OpActivityChannel> findByCond(OpActivityChannelCond cond) {
        return this.opActivityChannelMapper.selectByParams(cond);
    }



    private String getQrCodeUrl(OpActivityChannel record) {
        long id = record.getId();
        //创建HttpClientBuilder
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        //HttpClient
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        String sign =  DigestUtils.md5Hex(urlConfig.getQrCodeToken());

        String sceneId = record.getCode();
        HttpGet httpGet = new HttpGet(urlConfig.getQrCodeBaseUrl() + "/qrCode/createPermanent?sign=" + sign + "&sceneId=" + sceneId);

        //System.out.println(httpGet.getRequestLine());
        try {
            //执行get请求
            HttpResponse httpResponse = closeableHttpClient.execute(httpGet);
            //获取响应消息实体
            HttpEntity entity = httpResponse.getEntity();
            //响应状态
            System.out.println("status:" + httpResponse.getStatusLine());
            //判断响应实体是否为空
            if (entity != null) {
                //System.out.println("contentEncoding:" + entity.getContentEncoding());
                // System.out.println("response content:" + EntityUtils.toString(entity, "GBK"));
                JSONObject rootJsonObject = (JSONObject) JSON.parse(EntityUtils.toString(entity, "GBK"));
                boolean status = rootJsonObject.getBoolean("success");
                //失败
                if(status) {
                    return rootJsonObject.getString("url");
                } else { //成功
                    return null;
                }

            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                //关闭流并释放资源
                closeableHttpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<OpActivityChannel> getActivityAllCreater() {
        return opActivityChannelMapper.getActivityAllCreater();
    }

    @Override
    public boolean delete(List<OpActivityChannel>  activityList) {
        if(EmptyUtil.isNotEmpty(activityList)) {
            for(OpActivityChannel opActivityChannel : activityList) {
                opActivityChannel.setDeleteFlag(OpActivityChannel.DELETE_FLAG_1);
                opActivityChannelMapper.updateByPrimaryKeySelective(opActivityChannel);
            }
        }
        return true;
    }

    @Override
    public Boolean updateUrlsByCode(OpActivityChannel record) {
        buildUrls(record);
        Integer result = opActivityChannelMapper.updateUrlsByCode(record);
        return result > 0;
    }

    @Override
    public Boolean updateUrlsByCodes(List<OpActivityChannel> records) {
        if (CollectionUtils.isNotEmpty(records)) {
            for (OpActivityChannel record : records) {
                buildUrls(record);
            }
        }
        Integer result = opActivityChannelMapper.updateUrlsByCodes(records);
        return result != null && result > 0;
    }

    /**
     * 生成targetUrl和shortUrl或者QRCode
     *
     * @param record
     *
     * @return
     */
    private void buildUrls(OpActivityChannel record) {
        Integer accessType = record.getAccessType();
        if (accessType != null) {
            if (accessType == ACCESS_SHORT_URL) {
                String targetUrl = generateTargetUrl(record);
                String shortUrl = DahanSanTongShortUrlClient.getShortUrl(targetUrl);
                record.setShortUrl(shortUrl);
            }
            if (accessType == ACCESS_QR_CODE) {
                record.setQrCodeUrl(getQrCodeUrl(record));
            }
        }
    }


    //生成小程序二维码
    private String createwxaqrcode(Long id,String path,String type,String accessToken){
        if(EmptyUtil.isEmpty(accessToken)){
            logger.error("createwxaqrcode:获取Token失败,请稍后重试！");
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();

        String getUrl;
        if("0".equals(type)){
            getUrl = "https://api.weixin.qq.com/wxa/getwxacode?access_token=" +accessToken;
        }else{
            getUrl = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" +accessToken;
        }
        /*// 小程序码
        String getwxacodeURl = "https://api.weixin.qq.com/wxa/getwxacode?access_token=" +accessToken;
        // 小程序二维码
        String createwxaqrcodeURl = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" +accessToken;*/
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost(getUrl);
        try{
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("path",path);
            jsonObj.put("width",3400);
            httpPost.setEntity(new StringEntity(jsonObj.toString(),"UTF-8"));
            HttpResponse httpResponse = HttpClient.execute(httpPost);
            //获取响应消息实体
            HttpEntity entity = httpResponse.getEntity();
            if(NullUtil.isNotNull(entity)){
                String contentType = entity.getContentType().getValue();
                if(contentType.contains("application/json")){//非图片
                    throw new BusinessException(EntityUtils.toString(entity,"UTF-8"));
                }
                byte[] bytes = EntityUtils.toByteArray(entity);
                InputStream inputStream = new ByteArrayInputStream(bytes);
                //直接上传到Oss
                String key = PegasusIntegrationFacade.getInstance().getOssUtilBean().uploadFile(null, DateUtil.getCurrTime_YYYYMMDDHHMMSS() + "_" + type + "_" + id, contentType.split("/")[1], inputStream);
                String pathPrefix = PegasusIntegrationFacade.getInstance().getOssUtilBean().getBaseUrl();
                return pathPrefix+key;
            }
        }catch (IOException e){
            e.printStackTrace();
        }finally {
            try{
                HttpClient.close();
            }catch (Exception e){}
        }
        return null;
    }

    //小程序H5生成短链接
    private String createH5ShorLink(Long id,String path,String accessToken){
        if(com.thebeastshop.common.utils.EmptyUtil.isEmpty(accessToken)){
            logger.error("createwxaqrcode:获取Token失败,请稍后重试！");
        }
        JSONObject jsonObj = new JSONObject();
        if(path.indexOf("?") >= 0){
            String orgUrl = path.substring(0,path.indexOf("?"));
            String pathData = path.substring(path.indexOf("?") + 1);
            jsonObj.put("path",orgUrl);
            jsonObj.put("query",pathData);
        }else{
            jsonObj.put("path",path);
            jsonObj.put("query","");
        }
        String schemeUrl = "https://m.thebeastshop.com/openwechat?r=" + Base64Util.encode(jsonObj.toString().getBytes());
        logger.info("url:{}",schemeUrl);
        return schemeUrl;
    }

    private String getAppletToken(){
        String tokenUrl = SCM_ACTIVITY_CHANNEL_APPLET_TOKEN_URL;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpGet httpGet = new HttpGet(tokenUrl);
        try{
            HttpResponse httpResponse = HttpClient.execute(httpGet);
//            if(httpResponse.getStatusLine().getStatusCode() == HttpStatus.OK.value()){
                //获取响应消息实体
                HttpEntity entity = httpResponse.getEntity();
                if(NullUtil.isNotNull(entity)){
                    return EntityUtils.toString(entity,"UTF-8");
                }
//            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                HttpClient.close();
            }catch (Exception e){}
        }
        return null;
    }



   /* public static void main(String args[]){
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpGet httpGet = new HttpGet("http://weixin.thebeastshop.com/token/getAppletToken");
        try{
            HttpResponse httpResponse = HttpClient.execute(httpGet);
            if(httpResponse.getStatusLine().getStatusCode() == HttpStatus.OK.value()){
                //获取响应消息实体
                HttpEntity entity = httpResponse.getEntity();
                if(NullUtil.isNotNull(entity)){
                    String accessToken = EntityUtils.toString(entity,"UTF-8");

                    // 小程序码
                    String getwxacodeURl = "https://api.weixin.qq.com/wxa/getwxacode?access_token=" +accessToken;
                    String path = "pages-activity/yyqx/index";
                    // 小程序二维码
                    HttpClient = httpClientBuilder.build();
                    HttpPost httpPost = new HttpPost(getwxacodeURl);
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("path",path);
                    jsonObj.put("width",3400);
                    httpPost.setEntity(new StringEntity(jsonObj.toString(),"UTF-8"));

                    httpResponse = HttpClient.execute(httpPost);
                    //获取响应消息实体
                    entity = httpResponse.getEntity();
                    if(NullUtil.isNotNull(entity)){
                        String contentType = entity.getContentType().getValue();
                        if(contentType.contains("application/json")){//非图片
                            throw new BusinessException(EntityUtils.toString(entity,"UTF-8"));
                        }
                        byte[] bytes = EntityUtils.toByteArray(entity);
                        InputStream inputStream = new ByteArrayInputStream(bytes);
                        //直接上传到Oss
                        String key = PegasusIntegrationFacade.getInstance().getOssUtilBean().uploadFile(null,"scm_activity_channel_url_yyqx", contentType.split("/")[1], inputStream);
                        String pathPrefix = PegasusIntegrationFacade.getInstance().getOssUtilBean().getBaseUrl();
                        System.out.println(pathPrefix+key);
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                HttpClient.close();
            }catch (Exception e){}
        }


    }*/
}
