package com.thebeastshop.pegasus.report.service.impl;

import com.thebeastshop.pegasus.report.dao.OpAccessLogMapper;
import com.thebeastshop.pegasus.report.model.OpAccessLog;
import com.thebeastshop.pegasus.report.service.OpAccessLogService;
import com.thebeastshop.pegasus.report.vo.OpActivityReportVO;
import com.thebeastshop.pegasus.report.vo.OpReportQueryVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by Administrator on 2016/4/27.
 *
 * @author gongjun
 * @since 2016-04-27
 */
@Service
public class OpAccessLogServiceImpl implements OpAccessLogService {

    @Autowired
    private OpAccessLogMapper opAccessLogMapper;

    @Override
    @Transactional
    public int addAccessLog(OpAccessLog accessLog) {
        return opAccessLogMapper.insert(accessLog);
    }

    @Override
    public List<OpActivityReportVO> queryReportList(OpReportQueryVO reportQueryVO) {
        return opAccessLogMapper.queryReportList(reportQueryVO);
    }

    @Override
    public List<OpAccessLog> findOpAccessLog(OpAccessLog cond) {
        return opAccessLogMapper.findOpAccessLog(cond);
    }
}
