package com.thebeastshop.pegasus.report.service;

import java.util.List;

import com.thebeastshop.pegasus.report.vo.OpActivityChannelCond;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.report.model.OpActivityChannel;

public interface OpActivityChannelService {
	
	 /**
     * 创建活动渠道
     *
     * @param record
     * @return
     */
	@Transactional
    Long create(OpActivityChannel record);
    
    /**
     * 批量创建活动渠道
     *
     * @param record
     * @return
     */
    @Transactional
    boolean create(List<OpActivityChannel> record);

    /**
     * 更新活动渠道
     *
     * @param record
     * @return
     */
    boolean update(OpActivityChannel record);

    /**
     * 根据主键查找活动渠道
     *
     * @param id
     * @return
     */
    OpActivityChannel findById(long id);

    /**
     * 根据条件查找活动渠道
     *
     * @param cond
     * @return
     */
    List<OpActivityChannel> findByCond(OpActivityChannelCond cond);
    
    /**
     * 获取活动所有创建人
     * */
    List<OpActivityChannel> getActivityAllCreater();
    
    /**
     * 删除
     * @param ids
     * @return
     */
    boolean  delete(List<OpActivityChannel>  activityList);

    /**
     * 根据修改后的ios_td和android_td修改目标URL、短链接等
     *
     * @param record
     *
     * @return
     */
    Boolean updateUrlsByCode(OpActivityChannel record);

    /**
     * 批量更新目标URL。短链接
     *
     * @param records 要修改的记录
     *
     * @return
     */
    Boolean updateUrlsByCodes(List<OpActivityChannel> records);
}
