/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.report;

import com.thebeastshop.pegasus.report.model.OpAccessLog;
import com.thebeastshop.pegasus.report.model.OpActivityChannel;
import com.thebeastshop.pegasus.report.service.OpAccessLogService;
import com.thebeastshop.pegasus.report.service.OpActivityChannelService;
import com.thebeastshop.pegasus.report.vo.OpAccessLogVO;
import com.thebeastshop.pegasus.report.vo.OpActivityChannelCond;
import com.thebeastshop.pegasus.report.vo.OpActivityReportVO;
import com.thebeastshop.pegasus.report.vo.OpReportQueryVO;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 访问日志，统计
 * @author Roy.Chen
 * @version $Id: PegasusPublicServiceFacade.java, v 0.1 2015-08-06 18:34
 */
public class PegasusReportFacade {
    private final static Logger log = LoggerFactory.getLogger(PegasusReportFacade.class);

    private static PegasusReportFacade instance;

    @Autowired
    private OpActivityChannelService opActivityChannelService;

    @Autowired
    private OpAccessLogService opAccessLogService;
	

    private PegasusReportFacade() {
    }

    public static PegasusReportFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusReportFacade.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusReportFacade");
                new ClassPathXmlApplicationContext("pegasus-report/spring.xml");
                log.info("[fasade init finish] PegasusReportFacade");
            }
            instance = (PegasusReportFacade) SpringUtil
                    .getBean("pegasusReportFacade");
        }
        return instance;
    }


    public static boolean isAccessTypeShorUrl(OpAccessLogVO accessLogVO) {
        return accessLogVO.getAccessType() == 0;
    }

    public static boolean isAccessTypeQRCode(OpAccessLogVO accessLogVO) {
        return accessLogVO.getAccessType() == 1;
    }

    private void validateAccessLog(OpAccessLogVO accessLogVO) throws ReportBuisnessException {
        if (StringUtils.isEmpty(accessLogVO.getType())) {
            throw new ReportBuisnessException("JSON字段'type'为空");
        }
        if (accessLogVO.getAccessType() == null) {
            throw new ReportBuisnessException("JSON字段'accessType'为空");
        }
        if (PegasusReportFacade.isAccessTypeShorUrl(accessLogVO)) {
            if (StringUtils.isEmpty(accessLogVO.getUrl())) {
                throw new ReportBuisnessException("JSON字段'url'为空");
            }
        }
    }

    /**
     * 添加访问日志
     * @param accessLogVO
     * @return
     */
    public Long addAccessLog(OpAccessLogVO accessLogVO) throws ReportBuisnessException {
        validateAccessLog(accessLogVO);
        OpAccessLog accessLog = new OpAccessLog();
        try {
            PropertyUtils.copyProperties(accessLog, accessLogVO);
        } catch (IllegalAccessException e) {
            log.error("{}", e);
            return null;
        } catch (InvocationTargetException e) {
            log.error("{}", e);
            return null;
        } catch (NoSuchMethodException e) {
            log.error("{}", e);
            return null;
        }
        accessLog.setIsActivity(0);
        String activityCode = accessLogVO.getActivityCode();
        if (StringUtils.isNotEmpty(activityCode)) {
        	OpActivityChannelCond cond = new OpActivityChannelCond();
            cond.setCode(activityCode);
            List<OpActivityChannel> list = opActivityChannelService.findByCond(cond);
            if (list != null && !list.isEmpty()) {
                OpActivityChannel activityChannel = list.get(0);
                setupAccessLogFromActivity(accessLog, activityChannel);
            }
        }
/* 	String ref = accessLogVO.getRef();
        else if (StringUtils.isNotEmpty(ref)) {
            OpAccessLog cond = new OpAccessLog();
            cond.setRef(ref);
            if (accessLogVO.getUserId() != null) {
                cond.setUserId(accessLogVO.getUserId());
            }
            OpActivityChannel lastActivityChannel = findLastActivityChannel(cond);
            if (lastActivityChannel != null) {
                setupAccessLogFromActivity(accessLog, lastActivityChannel);
            }
        }
*/

        opAccessLogService.addAccessLog(accessLog);
        return accessLog.getId();
    }

    public OpActivityChannel findLastActivityChannel(OpAccessLog cond) {
        OpAccessLog log = findLastActivityAccessLog(cond);
        if (log == null) {
            return null;
        }
        String activityCode = log.getActivityCode();
        if (StringUtils.isEmpty(activityCode)) {
            return null;
        }
        OpActivityChannelCond activityChannelCond = new OpActivityChannelCond();
        activityChannelCond.setCode(activityCode);
        List<OpActivityChannel> rets = opActivityChannelService.findByCond(activityChannelCond);
        if (rets == null || rets.isEmpty()) {
            return null;
        }
        return rets.get(0);
    }


    public OpAccessLog findLastActivityAccessLog(OpAccessLog cond) {
        if (cond == null || StringUtils.isNotEmpty(cond.getActivityCode())) {
            return cond;
        }
        List<OpAccessLog> logList = opAccessLogService.findOpAccessLog(cond);
        if (logList == null || logList.isEmpty()) {
            return null;
        }
        OpAccessLog log = logList.get(0);
        String ref = log.getRef();
        Integer userId = log.getUserId();
        OpAccessLog newCond = new OpAccessLog();
        if (StringUtils.isEmpty(ref)) {
            return null;
        }
        newCond.setRef(ref);
        if (userId != null) {
            newCond.setUserId(userId);
        }
        return findLastActivityAccessLog(newCond);
    }

    private void setupAccessLogFromActivity(OpAccessLog accessLog, OpActivityChannel activityChannel) {
        accessLog.setActivityCode(activityChannel.getCode());
        accessLog.setChannelName(activityChannel.getChannelName());
        accessLog.setShortUrl(activityChannel.getShortUrl());
        accessLog.setQrCodeUrl(activityChannel.getQrCodeUrl());
        accessLog.setIsActivity(1);
    }

    public Long create(OpActivityChannel record) {
		return this.opActivityChannelService.create(record);
	}
    
    public boolean create(List<OpActivityChannel> records){
    	return opActivityChannelService.create(records);
    }

	public boolean update(OpActivityChannel record) {
		this.opActivityChannelService.update(record);
		return true;
	}

    /**
     * 根据修改后的ios_td和android_td修改目标URL、短链接等
     *
     * @param record
     *
     * @return
     */
    public Boolean updateUrlsByCode(OpActivityChannel record){
        return this.opActivityChannelService.updateUrlsByCode(record);
    }

    public Boolean updateUrlsByCodes(List<OpActivityChannel> records){
        return opActivityChannelService.updateUrlsByCodes(records);
    }

	public OpActivityChannel findById(long id) {
		return this.opActivityChannelService.findById(id);
	}

	public List<OpActivityChannel> findByCond(OpActivityChannelCond cond) {
		return this.opActivityChannelService.findByCond(cond);
	}

	public List<OpActivityChannel> getActivityAllCreater(){
		return opActivityChannelService.getActivityAllCreater();
	}
	
    public List<OpActivityReportVO> queryReportList(OpReportQueryVO reportQueryVO) {
        return opAccessLogService.queryReportList(reportQueryVO);
    }
    
    public boolean delete(List<OpActivityChannel>  activityList) {
    	return opActivityChannelService.delete(activityList);
    }
}
