/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.report.UrlConfig;
import com.thebeastshop.pegasus.report.dao.OpActivityChannelMapper;
import com.thebeastshop.pegasus.report.model.OpActivityChannel;
import com.thebeastshop.pegasus.report.service.OpActivityChannelService;
import com.thebeastshop.pegasus.report.service.ShortUrlService;
import com.thebeastshop.pegasus.report.shorturl.DahanSanTongShortUrlClient;
import com.thebeastshop.pegasus.report.vo.OpActivityChannelCond;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="opActivityChannelService")
@Transactional
public class OpActivityChannelServiceImpl
implements OpActivityChannelService {
    @Autowired
    private OpActivityChannelMapper opActivityChannelMapper;
    public static final Integer ACCESS_SHORT_URL = 0;
    public static final Integer ACCESS_QR_CODE = 1;
    @Autowired
    private UrlConfig urlConfig;
    @Autowired
    private ShortUrlService shortUrlService;
    private static final Logger logger = LoggerFactory.getLogger(OpActivityChannelService.class);
    @Value(value="${scm.activity.channel.applet.toke.url}")
    private String SCM_ACTIVITY_CHANNEL_APPLET_TOKEN_URL;

    @Override
    public Long create(OpActivityChannel record) {
        Integer accessType = record.getAccessType();
        record.setDeleteFlag(0);
        this.opActivityChannelMapper.insertSelective(record);
        this.generateActivityCode(record);
        if ("2".equals(record.getLinkType())) {
            this.generateTargetUrl(record);
            String normalQrCodeUrl = this.createwxaqrcode(record.getId(), record.getTargetUrl(), "1");
            String specialQrCodeUrl = this.createwxaqrcode(record.getId(), record.getTargetUrl(), "0");
            record.setQrCodeUrl(normalQrCodeUrl + "," + specialQrCodeUrl);
        } else {
            if (accessType == ACCESS_SHORT_URL) {
                String targetUrl = this.generateTargetUrl(record);
                String shortUrl = DahanSanTongShortUrlClient.getShortUrl(targetUrl);
                record.setShortUrl(shortUrl);
            }
            if (accessType == ACCESS_QR_CODE) {
                record.setQrCodeUrl(this.getQrCodeUrl(record));
            }
        }
        record.setCreateTime(new Date());
        this.opActivityChannelMapper.updateByPrimaryKeySelective(record);
        return 1L;
    }

    @Override
    public boolean create(List<OpActivityChannel> records) {
        for (OpActivityChannel record : records) {
            this.create(record);
        }
        return true;
    }

    private String generateTargetUrl(OpActivityChannel record) {
        logger.info("record.getLinkType()", (Object)record.getLinkType());
        StringBuffer spliceUrl = new StringBuffer();
        if ("2".equals(record.getLinkType())) {
            spliceUrl.append(record.getLongUrl());
            if (record.getLongUrl().indexOf("?") >= 0) {
                spliceUrl.append("&_w=" + record.getCode());
            } else {
                spliceUrl.append("?_w=" + record.getCode());
            }
        } else {
            try {
                URL url = new URL(record.getLongUrl());
                String protocol = url.getProtocol();
                String authority = url.getAuthority();
                String path = url.getPath();
                String query = url.getQuery();
                String androidTdHash = record.getAndroidTdHash();
                String iosTdHash = record.getIosTdHash();
                spliceUrl.append(protocol);
                spliceUrl.append("://");
                spliceUrl.append(authority);
                spliceUrl.append(path);
                String acParam = record.getCode().trim();
                String aParam = androidTdHash.trim();
                String iParam = iosTdHash.trim();
                try {
                    acParam = URLEncoder.encode(acParam, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    iParam = URLEncoder.encode(iParam, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    aParam = URLEncoder.encode(aParam, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                spliceUrl.append("?");
                spliceUrl.append("_ac=" + acParam);
                spliceUrl.append("&utm_source=" + acParam);
                if (StringUtils.isNotBlank((String)iParam)) {
                    spliceUrl.append("&_i=" + iParam);
                }
                if (StringUtils.isNotBlank((String)aParam)) {
                    spliceUrl.append("&_a=" + aParam);
                }
                if (StringUtils.isNotEmpty((String)query)) {
                    spliceUrl.append("&" + query);
                }
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String targetUrl = spliceUrl.toString();
        record.setTargetUrl(targetUrl);
        return spliceUrl.toString();
    }

    public String generateActivityCode(OpActivityChannel record) {
        String code = "AC" + record.getAccessType() + record.getId();
        record.setCode(code);
        return code;
    }

    @Override
    public boolean update(OpActivityChannel record) {
        this.opActivityChannelMapper.updateByPrimaryKeySelective(record);
        return true;
    }

    @Override
    public OpActivityChannel findById(long id) {
        return this.opActivityChannelMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<OpActivityChannel> findByCond(OpActivityChannelCond cond) {
        return this.opActivityChannelMapper.selectByParams(cond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQrCodeUrl(OpActivityChannel record) {
        long id = record.getId();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        String sign = DigestUtils.md5Hex((String)this.urlConfig.getQrCodeToken());
        String sceneId = record.getCode();
        HttpGet httpGet = new HttpGet(this.urlConfig.getQrCodeBaseUrl() + "/qrCode/createPermanent?sign=" + sign + "&sceneId=" + sceneId);
        try {
            CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            System.out.println("status:" + httpResponse.getStatusLine());
            if (entity != null) {
                JSONObject rootJsonObject = (JSONObject)JSON.parse((String)EntityUtils.toString((HttpEntity)entity, (String)"GBK"));
                boolean status = rootJsonObject.getBoolean("success");
                if (status) {
                    String string = rootJsonObject.getString("url");
                    return string;
                }
                String string = null;
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<OpActivityChannel> getActivityAllCreater() {
        return this.opActivityChannelMapper.getActivityAllCreater();
    }

    @Override
    public boolean delete(List<OpActivityChannel> activityList) {
        if (EmptyUtil.isNotEmpty(activityList)) {
            for (OpActivityChannel opActivityChannel : activityList) {
                opActivityChannel.setDeleteFlag(1);
                this.opActivityChannelMapper.updateByPrimaryKeySelective(opActivityChannel);
            }
        }
        return true;
    }

    @Override
    public Boolean updateUrlsByCode(OpActivityChannel record) {
        this.buildUrls(record);
        Integer result = this.opActivityChannelMapper.updateUrlsByCode(record);
        return result > 0;
    }

    @Override
    public Boolean updateUrlsByCodes(List<OpActivityChannel> records) {
        Integer result;
        if (CollectionUtils.isNotEmpty(records)) {
            for (OpActivityChannel record : records) {
                this.buildUrls(record);
            }
        }
        return (result = this.opActivityChannelMapper.updateUrlsByCodes(records)) != null && result > 0;
    }

    private void buildUrls(OpActivityChannel record) {
        Integer accessType = record.getAccessType();
        if (accessType != null) {
            if (accessType == ACCESS_SHORT_URL) {
                String targetUrl = this.generateTargetUrl(record);
                String shortUrl = DahanSanTongShortUrlClient.getShortUrl(targetUrl);
                record.setShortUrl(shortUrl);
            }
            if (accessType == ACCESS_QR_CODE) {
                record.setQrCodeUrl(this.getQrCodeUrl(record));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createwxaqrcode(Long id, String path, String type) {
        String accessToken = this.getAppletToken();
        if (EmptyUtil.isEmpty((String)accessToken)) {
            logger.error("createwxaqrcode:\u83b7\u53d6Token\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        String getUrl = "0".equals(type) ? "https://api.weixin.qq.com/wxa/getwxacode?access_token=" + accessToken : "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" + accessToken;
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost(getUrl);
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("path", (Object)path);
            jsonObj.put("width", (Object)3400);
            httpPost.setEntity((HttpEntity)new StringEntity(jsonObj.toString(), "UTF-8"));
            CloseableHttpResponse httpResponse = HttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            if (NullUtil.isNotNull((Object)entity)) {
                String contentType = entity.getContentType().getValue();
                if (contentType.contains("application/json")) {
                    throw new BusinessException(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
                }
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                String key = PegasusIntegrationFacade.getInstance().getOssUtilBean().uploadFile(null, DateUtil.getCurrTime_YYYYMMDDHHMMSS() + "_" + type + "_" + id, contentType.split("/")[1], (InputStream)inputStream);
                String pathPrefix = PegasusIntegrationFacade.getInstance().getOssUtilBean().getBaseUrl();
                String string = pathPrefix + key;
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                HttpClient.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppletToken() {
        String tokenUrl = this.SCM_ACTIVITY_CHANNEL_APPLET_TOKEN_URL;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpGet httpGet = new HttpGet(tokenUrl);
        try {
            HttpEntity entity;
            CloseableHttpResponse httpResponse = HttpClient.execute((HttpUriRequest)httpGet);
            if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.OK.value() && NullUtil.isNotNull((Object)(entity = httpResponse.getEntity()))) {
                String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                HttpClient.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

