/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.report;

import com.thebeastshop.pegasus.report.ReportBuisnessException;
import com.thebeastshop.pegasus.report.SpringUtil;
import com.thebeastshop.pegasus.report.model.OpAccessLog;
import com.thebeastshop.pegasus.report.model.OpActivityChannel;
import com.thebeastshop.pegasus.report.service.OpAccessLogService;
import com.thebeastshop.pegasus.report.service.OpActivityChannelService;
import com.thebeastshop.pegasus.report.vo.OpAccessLogVO;
import com.thebeastshop.pegasus.report.vo.OpActivityChannelCond;
import com.thebeastshop.pegasus.report.vo.OpActivityReportVO;
import com.thebeastshop.pegasus.report.vo.OpReportQueryVO;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PegasusReportFacade {
    private static final Logger log = LoggerFactory.getLogger(PegasusReportFacade.class);
    private static PegasusReportFacade instance;
    @Autowired
    private OpActivityChannelService opActivityChannelService;
    @Autowired
    private OpAccessLogService opAccessLogService;

    private PegasusReportFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusReportFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusReportFacade> clazz = PegasusReportFacade.class;
        synchronized (PegasusReportFacade.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusReportFacade");
                new ClassPathXmlApplicationContext("pegasus-report/spring.xml");
                log.info("[fasade init finish] PegasusReportFacade");
            }
            instance = (PegasusReportFacade)SpringUtil.getBean("pegasusReportFacade");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isAccessTypeShorUrl(OpAccessLogVO accessLogVO) {
        return accessLogVO.getAccessType() == 0;
    }

    public static boolean isAccessTypeQRCode(OpAccessLogVO accessLogVO) {
        return accessLogVO.getAccessType() == 1;
    }

    private void validateAccessLog(OpAccessLogVO accessLogVO) throws ReportBuisnessException {
        if (StringUtils.isEmpty((String)accessLogVO.getType())) {
            throw new ReportBuisnessException("JSON\u5b57\u6bb5'type'\u4e3a\u7a7a");
        }
        if (accessLogVO.getAccessType() == null) {
            throw new ReportBuisnessException("JSON\u5b57\u6bb5'accessType'\u4e3a\u7a7a");
        }
        if (PegasusReportFacade.isAccessTypeShorUrl(accessLogVO) && StringUtils.isEmpty((String)accessLogVO.getUrl())) {
            throw new ReportBuisnessException("JSON\u5b57\u6bb5'url'\u4e3a\u7a7a");
        }
    }

    public Long addAccessLog(OpAccessLogVO accessLogVO) throws ReportBuisnessException {
        this.validateAccessLog(accessLogVO);
        OpAccessLog accessLog = new OpAccessLog();
        try {
            PropertyUtils.copyProperties((Object)accessLog, (Object)accessLogVO);
        }
        catch (IllegalAccessException e) {
            log.error("{}", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error("{}", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            log.error("{}", (Throwable)e);
            return null;
        }
        accessLog.setIsActivity(0);
        String activityCode = accessLogVO.getActivityCode();
        if (StringUtils.isNotEmpty((String)activityCode)) {
            OpActivityChannelCond cond = new OpActivityChannelCond();
            cond.setCode(activityCode);
            List<OpActivityChannel> list = this.opActivityChannelService.findByCond(cond);
            if (list != null && !list.isEmpty()) {
                OpActivityChannel activityChannel = list.get(0);
                this.setupAccessLogFromActivity(accessLog, activityChannel);
            }
        }
        this.opAccessLogService.addAccessLog(accessLog);
        return accessLog.getId();
    }

    public OpActivityChannel findLastActivityChannel(OpAccessLog cond) {
        OpAccessLog log = this.findLastActivityAccessLog(cond);
        if (log == null) {
            return null;
        }
        String activityCode = log.getActivityCode();
        if (StringUtils.isEmpty((String)activityCode)) {
            return null;
        }
        OpActivityChannelCond activityChannelCond = new OpActivityChannelCond();
        activityChannelCond.setCode(activityCode);
        List<OpActivityChannel> rets = this.opActivityChannelService.findByCond(activityChannelCond);
        if (rets == null || rets.isEmpty()) {
            return null;
        }
        return rets.get(0);
    }

    public OpAccessLog findLastActivityAccessLog(OpAccessLog cond) {
        if (cond == null || StringUtils.isNotEmpty((String)cond.getActivityCode())) {
            return cond;
        }
        List<OpAccessLog> logList = this.opAccessLogService.findOpAccessLog(cond);
        if (logList == null || logList.isEmpty()) {
            return null;
        }
        OpAccessLog log = logList.get(0);
        String ref = log.getRef();
        Integer userId = log.getUserId();
        OpAccessLog newCond = new OpAccessLog();
        if (StringUtils.isEmpty((String)ref)) {
            return null;
        }
        newCond.setRef(ref);
        if (userId != null) {
            newCond.setUserId(userId);
        }
        return this.findLastActivityAccessLog(newCond);
    }

    private void setupAccessLogFromActivity(OpAccessLog accessLog, OpActivityChannel activityChannel) {
        accessLog.setActivityCode(activityChannel.getCode());
        accessLog.setChannelName(activityChannel.getChannelName());
        accessLog.setShortUrl(activityChannel.getShortUrl());
        accessLog.setQrCodeUrl(activityChannel.getQrCodeUrl());
        accessLog.setIsActivity(1);
    }

    public Long create(OpActivityChannel record) {
        return this.opActivityChannelService.create(record);
    }

    public boolean create(List<OpActivityChannel> records) {
        return this.opActivityChannelService.create(records);
    }

    public boolean update(OpActivityChannel record) {
        this.opActivityChannelService.update(record);
        return true;
    }

    public Boolean updateUrlsByCode(OpActivityChannel record) {
        return this.opActivityChannelService.updateUrlsByCode(record);
    }

    public Boolean updateUrlsByCodes(List<OpActivityChannel> records) {
        return this.opActivityChannelService.updateUrlsByCodes(records);
    }

    public OpActivityChannel findById(long id) {
        return this.opActivityChannelService.findById(id);
    }

    public List<OpActivityChannel> findByCond(OpActivityChannelCond cond) {
        return this.opActivityChannelService.findByCond(cond);
    }

    public List<OpActivityChannel> getActivityAllCreater() {
        return this.opActivityChannelService.getActivityAllCreater();
    }

    public List<OpActivityReportVO> queryReportList(OpReportQueryVO reportQueryVO) {
        return this.opAccessLogService.queryReportList(reportQueryVO);
    }

    public boolean delete(List<OpActivityChannel> activityList) {
        return this.opActivityChannelService.delete(activityList);
    }
}

