/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.reportservice.handler;

import com.thebeastshop.pegasus.report.LogException;
import com.thebeastshop.pegasus.report.ReportBuisnessException;
import com.thebeastshop.pegasus.reportservice.ErrorCode;
import com.thebeastshop.pegasus.reportservice.JsonResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/**
 * @author fs
 * @version $Id: ApiExceptionHandler.java, v 0.1 2015-08-05 16:31
 * 把BusinessException 转成json 返回
 */
@ControllerAdvice
public class ApiExceptionHandler extends ResponseEntityExceptionHandler {

    private final Logger logger = LoggerFactory.getLogger(ApiExceptionHandler.class);
	
    @ExceptionHandler({Throwable.class })
    protected ResponseEntity<Object> handleInvalidRequest(Exception e, WebRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        List<Charset> charSets=new ArrayList<Charset>();
        charSets.add(Charset.forName("UTF-8"));
        headers.setAcceptCharset(charSets);
        if (e instanceof ReportBuisnessException) {
            logger.error(e.getMessage());
            return handleExceptionInternal(e, JsonResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),e.getMessage()), headers, HttpStatus.OK, request);
        }
        else if(e instanceof LogException){
            logger.error(e.getMessage());
            return handleExceptionInternal(e, JsonResult.ofErrorResult(((LogException) e).getErrorCode(),e.getMessage()), headers, HttpStatus.OK, request);
        }
        logger.error("", e);
        return handleExceptionInternal(e, JsonResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage()+"|| "+e.getMessage()), headers, HttpStatus.OK, request);
    }
}
