package com.thebeastshop.pegasus.reportservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPObject;
import com.thebeastshop.pegasus.report.LogException;
import com.thebeastshop.pegasus.report.PegasusReportFacade;
import com.thebeastshop.pegasus.report.vo.OpAccessLogVO;
import com.thebeastshop.pegasus.reportservice.ErrorCode;
import com.thebeastshop.pegasus.reportservice.JsonResult;
import com.thebeastshop.pegasus.reportservice.utils.MD5Util;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;


/**
 * Created by Administrator on 2016/4/27.
 */
@Controller
@RequestMapping("/report/api")
public class AccessLogController {
    private final static Logger log = LoggerFactory
            .getLogger(AccessLogController.class);

    private PegasusReportFacade pegasusReportFacade = PegasusReportFacade.getInstance();

    private final static String SECRET_KEY = "%Thebeastshop@3$";

    private void validate(String sign, Long ts, String params) throws LogException {
        if (ts == null) {
            throw new LogException(ErrorCode.PARAMS_ILLEGAL.getCode(), "参数ts为空");
        }
        if (sign == null) {
            throw new LogException(ErrorCode.PARAMS_ILLEGAL.getCode(), "参数sign为空");
        }
/*
        Date now = new Date();
        Long expiredTime = 1000L * 60 * 10; // 10分钟
        if (now.getTime() > ts + expiredTime) {
            throw new LogException(ErrorCode.AUTHFAILED_TIMESTAMP_EXPIRED.getCode(), ErrorCode.AUTHFAILED_TIMESTAMP_EXPIRED.getMesage());
        }
*/
        String key = params + "_" + ts + SECRET_KEY;
        String result = MD5Util.MD5(key);
        if (!result.equals(sign)) {
            throw new LogException(ErrorCode.AUTHFAILED_SIGN_ILLEGAL.getCode(), ErrorCode.AUTHFAILED_SIGN_ILLEGAL.getMesage());
        }
    }


    @RequestMapping("log/add")
    @ResponseBody
    public JSONPObject addLog(@RequestParam String params,
                              @RequestParam(value = "ts", required = false) Long ts,
                              @RequestParam(value = "sign", required = false) String sign,
                              HttpServletRequest request,
                              HttpServletResponse response) throws Exception {
        response.setContentType("text/plain");
        String callbackFunName = request.getParameter("callback");//得到js函数名称
        log.info("【add log】 {}", params);
//        String nsign = MD5Util.MD5(params + "_" + ts + SECRET_KEY);
//        log.info("timestamp: " + ts);
//        log.info("current timestamp: " + new Date().getTime());
//        log.info("sign: " + sign);
//        log.info("sign should be: " + nsign);
//        log.info("params: " + params);
//        validate(sign, ts, params);
        JSONObject json = JSONObject.parseObject(params);
        OpAccessLogVO accessLogVO = JSONObject.toJavaObject(json, OpAccessLogVO.class);
        String userName = accessLogVO.getUserName();
        if (StringUtils.isNotEmpty(userName)) {
            userName = URLDecoder.decode(userName, "UTF-8");
            accessLogVO.setUserName(userName);
            log.info("userName: " + userName);
        }

        Long id = pegasusReportFacade.addAccessLog(accessLogVO);
        accessLogVO.setId(id);
        if (id == null || id <= 0) {
            JSONPObject jsonpObject = new JSONPObject(callbackFunName);
            jsonpObject.addParameter(JsonResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), "添加访问日志失败"));
            return jsonpObject;
        }
        Map<String, Object> data = new HashedMap();
        data.put("id", id);
        JsonResult result = JsonResult.ofSuccessResult(data);
        JSONPObject jsonpObject = new JSONPObject(callbackFunName);
        jsonpObject.addParameter(result);

/*
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Headers", "X-Requested-With");
        response.setHeader("Access-Control-Allow-Methods","GET");
        response.setHeader("X-Powered-By", "3.2.1");
        response.setHeader("Content-Type", "application/json;charset=utf-8");
*/
        return jsonpObject;
    }


}
