package com.thebeastshop.pegasus.reportservice;

import org.apache.commons.lang.StringUtils;

/**
 * Created by Administrator on 2016/4/27.
 */
public class JsonResult {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private Integer code;

    private String message;

    private Object data;


    public JsonResult(Integer code,String message ,Object data){
        this.code=code;
        if(StringUtils.isNotBlank(message)){
            this.message=message;
        }
        this.data=data;
    }

    public static JsonResult ofSuccessResult(String message, Object data){
        return new JsonResult(ErrorCode.OPERATION_OK.getCode(), message, data);
    }

    public static JsonResult ofSuccessResult(Object data){
        return new JsonResult(ErrorCode.OPERATION_OK.getCode(), ErrorCode.OPERATION_OK.getMesage(), data);
    }
    public static JsonResult ofErrorResult(Integer code,String message){
        return new JsonResult(code, message, null);
    }

    public Integer getCode() {
        return code;
    }

    public Object getData() {
        return data;
    }

    public String getMessage() {
        return message;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
