package com.thebeastshop.pegasus.merchandise.utils;

import com.thebeastshop.pegasus.merchandise.constants.FieldType;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import org.elasticsearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.lang.reflect.Field;

/**
 * Created by Administrator on 2016/9/6.
 */
public class ReflectionUtil extends McReflectionUtil {


    public static XContentBuilder buildTypeValue(XContentBuilder builder, Object obj) {
        Field[] fields = obj.getClass().getDeclaredFields();
        for (Field field : fields) {
            try {
                Object value = field.get(obj);
                if (value != null) {
                    builder.field(field.getName(), value).field("type", FieldType.type(value.getClass()));
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return builder;
    }

}
