package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuReceiveStandardDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuReceiveStandardService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.List;

@Path("/sku/receive/standard")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsSkuReceiveStandardService")
public class McPcsSkuReceiveStandardServiceImpl implements McPcsSkuReceiveStandardService {

	@Autowired
	private PcsSkuReceiveStandardDomain pcsSkuReceiveStandardDomain;

	@Override
	public List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond) {
		return pcsSkuReceiveStandardDomain.listSkuByCond(cond);
	}

	@Override
	public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(String skuCode) {
		return pcsSkuReceiveStandardDomain.findPcsSkuReceiveStandardBySkuCode(skuCode);
	}

	@Override
	public boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
		return pcsSkuReceiveStandardDomain.createOrEditSkuReceiveStandard(vo);
	}


	@GET
	@Path("all")
	@Override
	public List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule() {
		return pcsSkuReceiveStandardDomain.findAllReceiveStandardRule();
	}

	@GET
	@Path("sku_code/{skuCode}")
	@Override
	public List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(
			@PathParam("skuCode") String skuCode) {
		return pcsSkuReceiveStandardDomain.findSkuReceiveStandardRule(skuCode);
	}

	@Override
	public PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id) {
		return pcsSkuReceiveStandardDomain.findReceiveStandardRuleVOById(id);
	}

	@Override
	public boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo) {
		return pcsSkuReceiveStandardDomain.createReceiveStandardRule(vo);
	}

	@Override
	public boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo) {
		return pcsSkuReceiveStandardDomain.updateReceiveStandardRule(vo);
	}

	@Override
	public boolean deleteReceiveStandardRule(Long id) {
		return pcsSkuReceiveStandardDomain.deleteReceiveStandardRule(id);
	}
}
