package com.thebeastshop.pegasus.merchandise.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryCond;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCategoryMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryRelationVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Service("mcPcsSkuCategoryService")
public class McPcsSkuCategoryServiceImpl implements McPcsSkuCategoryService {

    private final static Logger log = LoggerFactory.getLogger(McPcsSkuCategoryServiceImpl.class);

    @Autowired
    private PcsSkuCategoryDomain pcsSkuCategoryDomain;

    @Autowired
    private PcsSkuDomain pcsSkuDomain;

    @Autowired
    PcsSkuCategoryMapper pcsSkuCategoryMapper;

    @Override
    public Long create(PcsSkuCategoryVO record) {
        return pcsSkuCategoryDomain.create(pcsSkuCategoryDomain.buildFromVO(record));
    }

    @Override
    public Long createBackCategory(PcsSkuCategoryVO record) {
        return pcsSkuCategoryDomain.createBackCategory(pcsSkuCategoryDomain.buildFromVO(record));
    }

    @Override
    public boolean update(PcsSkuCategoryVO vo) {
        PcsSkuCategory record = pcsSkuCategoryDomain.buildFromVO(vo);
        return pcsSkuCategoryDomain.update(record);
    }

    @Override
    public boolean updateBackCategory(PcsSkuCategoryVO vo) {
        PcsSkuCategory record = pcsSkuCategoryDomain.buildFromVO(vo);
        return pcsSkuCategoryDomain.updateBackCategory(record);
    }

    @Override
    public PcsSkuCategoryVO findById(long id) {
        PcsSkuCategory record = pcsSkuCategoryDomain.findById(id);
        PcsSkuCategoryVO vo = pcsSkuCategoryDomain.buildFromModel(record);
        return vo;
    }

    @Override
    public PcsSkuCategoryVO findBackCategoryById(long id) {
        PcsSkuCategory record = pcsSkuCategoryDomain.findBackCategoryById(id);
        PcsSkuCategoryVO vo = pcsSkuCategoryDomain.buildFromModel(record);
        return vo;
    }

    @Override
    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCode(String skuCode) {
        List<PcsSkuCategory> categoryList = pcsSkuCategoryDomain.findFrontCategoriesBySkuCode(skuCode);
        List<PcsSkuCategoryVO> voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    @Override
    public List<PcsSkuCategoryVO> findBackCategoriesBySkuCode(String skuCode) {
        List<PcsSkuCategory> categoryList = pcsSkuCategoryDomain.findBackCategoriesBySkuCode(skuCode);
        List<PcsSkuCategoryVO> voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;
    }

    @Override
    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCodeList(List<String> skuCodeList) {
        List<PcsSkuCategory> categoryList = pcsSkuCategoryDomain.findFrontCategoriesBySkuCodeList(skuCodeList);
        List<PcsSkuCategoryVO> voList = BeanUtil.buildListFrom(categoryList, PcsSkuCategoryVO.class);
        return voList;

    }

    @Override
    public List<PcsSkuCategoryVO> findAllChildrens(long parentId) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findAllChildrens(parentId);
        List<PcsSkuCategoryVO> vos = new ArrayList<PcsSkuCategoryVO>(recordList.size());
        for (PcsSkuCategory record : recordList) {
            PcsSkuCategoryVO vo = pcsSkuCategoryDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findAllBackCategoryChildrens(long parentId) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findAllBackCategoryChildrens(parentId);
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findAll() {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findAll();
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findAllFrontCategories() {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findAllFrontCategories();
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public PcsSkuCategoryVO findByCode(String code) {
        PcsSkuCategory category = pcsSkuCategoryDomain.findByCode(code);
        PcsSkuCategoryVO vo = pcsSkuCategoryDomain.buildFromModel(category);
        return vo;
    }

    @Override
    public List<PcsSkuCategoryVO> findByName(String name) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findByName(name);
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findBackCategoryByName(String name) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findBackCategoryByName(name);
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findByIds(List<Long> ids) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findByIds(ids);
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findBackCategoriesByIds(List<Long> ids) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findBackCategoriesByIds(ids);
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findByCodeAndRightLikeCode(String code) {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findByCodeAndRightLikeCode(code);
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public List<PcsSkuCategoryVO> findSkuCategoryByParentIdIsNull() {
        List<PcsSkuCategory> recordList = pcsSkuCategoryDomain.findSkuCategoryByParentIdIsNull();
        List<PcsSkuCategoryVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryVO.class);
        return vos;
    }

    @Override
    public PcsSkuCategoryVO findByParentID(Long parentID) {
        PcsSkuCategory category = pcsSkuCategoryDomain.findByParentID(parentID);
        PcsSkuCategoryVO vo = pcsSkuCategoryDomain.buildFromModel(category);
        return vo;
    }

    @Override
    public List<Long> findProductIdsBySkuCodes(List<String> skuCodes) {
        return pcsSkuCategoryDomain.findProductIdsBySkuCodes(skuCodes);
    }

    @Override
    public List<Long> findProductIdListByCategoryFrontRelationIds(List<Long> ids) {
        return pcsSkuCategoryDomain.findProductIdListByCategoryFrontRelationIds(ids);
    }

    @Override
    public List<PcsFrontBackCategoryVO> findFrontBackCategoryList(Map<String, Object> params) {
        return pcsSkuCategoryDomain.findFrontBackCategoryList(params);
    }

    @Override
    public List<PcsSkuCategoryVO> findFrontCategoryList(Map<String, Object> params) {
        return pcsSkuCategoryDomain.findFrontCategoryList(params);
    }

    @Override
    public List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params) {
        return pcsSkuCategoryDomain.findBackCategoryList(params);
    }

    @Override
    public List<PcsSkuCategoryRelationVO> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond) {
        List<PcsSkuCategoryRelation> recordList = pcsSkuCategoryDomain.findBackCategoryRelationList(cond);
        List<PcsSkuCategoryRelationVO> vos = BeanUtil.buildListFrom(recordList, PcsSkuCategoryRelationVO.class);
        return vos;
    }

    @Override
    public void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelationVO> relationList) {
        List<PcsSkuCategoryRelation> relations = BeanUtil.buildListFrom(relationList, PcsSkuCategoryRelation.class);
        pcsSkuCategoryDomain.saveOrUpdateBackCategoryRelationList(relations);
    }

    @Override
    public void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = BeanUtil.buildFrom(vo, PcsSkuCategoryRelation.class);
        pcsSkuCategoryDomain.saveOrUpdateBackCategoryRelation(relation);
    }

    @Override
    public Integer addFrontCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = BeanUtil.buildFrom(vo, PcsSkuCategoryRelation.class);
        return pcsSkuCategoryDomain.addFrontCategoryRelation(relation);
    }

    @Override
    public Integer addBackCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = BeanUtil.buildFrom(vo, PcsSkuCategoryRelation.class);
        return pcsSkuCategoryDomain.addBackCategoryRelation(relation);
    }

    @Override
    public Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO vo) {
        return pcsSkuCategoryDomain.addFrontBackCategoryRelation(vo);
    }

    @Override
    public Integer updateBackCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = BeanUtil.buildFrom(vo, PcsSkuCategoryRelation.class);
        return pcsSkuCategoryDomain.updateBackCategoryRelation(relation);
    }

    @Override
    public void updateSkuCategoryRelation(PcsSkuCategoryRelationVO relation) {
        pcsSkuCategoryDomain.updateFrontCategoryRelation(
                BeanUtil.buildFrom(relation, PcsSkuCategoryRelation.class));
    }

    @Override
    public List<PcsSkuCategoryRelationVO> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        List<PcsSkuCategoryRelation> relationList = pcsSkuCategoryDomain.findFrontCategoryRelation(cond);
        List<PcsSkuCategoryRelationVO> vos = BeanUtil.buildListFrom(relationList, PcsSkuCategoryRelationVO.class);
        return vos;
    }

    @Override
    public List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId) {
        return pcsSkuCategoryDomain.findFrontCategoryIdListByBackCategoryId(backCategoryRelationId);
    }

    @Override
    public List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds) {
        return pcsSkuCategoryDomain.findFrontCategoryIdListByBackCategoryIds(backCategoryRelationIds);
    }

    @Override
    public List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryRelationId) {
        return pcsSkuCategoryDomain.findBackCategoryIdListByFrontCategoryId(frontCategoryRelationId);
    }

    @Override
    public Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond) {
        return pcsSkuCategoryDomain.countOfFrontCategoryRelation(cond);
    }

    @Override
    public void updateFrontCategoryRelation(PcsSkuCategoryRelationVO vo) {
        PcsSkuCategoryRelation relation = BeanUtil.buildFrom(vo, PcsSkuCategoryRelation.class);
        pcsSkuCategoryDomain.updateFrontCategoryRelation(relation);
    }

    @Override
    public void deleteFrontCategoryRelationList(List<Long> idList) {
        pcsSkuCategoryDomain.deleteFrontCategoryRelationList(idList);
    }

    @Override
    public void deleteBackCategoryRelationList(List<Long> idList) {
        pcsSkuCategoryDomain.deleteBackCategoryRelationList(idList);
    }

    @Override
    public void synFrontCategoryRelation(String skuCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCode", skuCode);
        List<PcsSkuCategoryVO> backCategoryList = this.findBackCategoryList(params);
        PcsSkuVO sku = pcsSkuDomain.findByCode(skuCode);
        if (sku == null) {
            log.warn("[synFrontCategoryRelation] SKU[{}] not found!", sku);
            return;
        }
        List<Long> backIds = new ArrayList<>();
        for (int i = 0; i < backCategoryList.size(); i++) {
            PcsSkuCategoryVO backCategory = backCategoryList.get(i);
            backIds.add(backCategory.getId());
        }

        List<Long> newFrontCategoryIds = this.findFrontCategoryIdListByBackCategoryIds(backIds);
        log.info("[synFrontCategoryRelation] 同步sku[{}]，相关的后台类目:id[{}], 前台类目:id[{}]",
                skuCode,
                StringUtils.join(backIds, ", "),
                StringUtils.join(newFrontCategoryIds, ", "));

        PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
        cond.setSkuCode(skuCode);
        cond.setNotCategoryIdList(newFrontCategoryIds);
        // 查询SKU关联的前端类目关系
        List<PcsSkuCategoryRelationVO> toDelBackRelationList = this.findFrontCategoryRelation(cond);
        List<Long> toDelIdList = new ArrayList<>();
        for (int i = 0; i < toDelBackRelationList.size(); i++) {
            PcsSkuCategoryRelationVO relation = toDelBackRelationList.get(i);
            toDelIdList.add(relation.getId());
        }
        // 清除该SKU已有的前端类目关系
        this.deleteFrontCategoryRelationList(toDelIdList);
        if (EmptyUtil.isNotEmpty(toDelIdList)) {
            log.info("synFrontCategoryRelation 同步sku[{}]类目时，清除的前台类目:[{}]",
                    skuCode, org.apache.commons.lang3.StringUtils.join(toDelIdList, ", "));
        }
        // 添加或更新SKU前端类目关系
        List<Long> needToAddCategoryIds = new ArrayList<>();
        for (int i = 0; i < newFrontCategoryIds.size(); i++) {
            Long categoryId = newFrontCategoryIds.get(i);
            PcsSkuCategoryRelationVO relation = new PcsSkuCategoryRelationVO();
            relation.setSkuCode(skuCode);
            relation.setCategoryId(categoryId);

            PcsSkuCategoryRelationCond frontCond = new PcsSkuCategoryRelationCond();
            frontCond.setSkuCode(skuCode);
            frontCond.setCategoryId(categoryId);
            List<PcsSkuCategoryRelationVO> list = findFrontCategoryRelation(frontCond);
            if (EmptyUtil.isEmpty(list)) {
                addFrontCategoryRelation(relation);
                needToAddCategoryIds.add(relation.getCategoryId());
            }
        }
        if (EmptyUtil.isNotEmpty(needToAddCategoryIds)) {
            log.info("synFrontCategoryRelation 同步sku[{}]类目时，添加的的前台类目：[{}]",
                    sku.getCode(), StringUtils.join(needToAddCategoryIds, ", "));
        }
//        saveOfUpdateBackCategoryRelationList(relationList);

    }

    @Override
    public void saveFrontCategoryRelationByBack(PcsSkuCategoryRelationVO backCategoryRelation) {
        List<Long> frontCategoryIdList = findFrontCategoryIdListByBackCategoryId(backCategoryRelation.getCategoryId());
        for (int i = 0; i < frontCategoryIdList.size(); i++) {
            Long frontCategoryId = frontCategoryIdList.get(i);
            PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
            cond.setSkuCode(backCategoryRelation.getSkuCode());
            cond.setCategoryId(frontCategoryId);
            Integer ret = countOfFrontCategoryRelation(cond);
            if (ret != null && ret == 0) {
                PcsSkuCategoryRelation relation = new PcsSkuCategoryRelation();
                relation.setSkuCode(backCategoryRelation.getSkuCode());
                relation.setCategoryId(frontCategoryId);
                pcsSkuCategoryDomain.addFrontCategoryRelation(relation);
            }
        }

    }

    @Override
    public void deleteFrontCategoryRelationByBack(PcsSkuCategoryRelationVO backCategoryRelation) {
        List<Long> frontCategoryIdList = findFrontCategoryIdListByBackCategoryId(backCategoryRelation.getCategoryId());
        for (int i = 0; i < frontCategoryIdList.size(); i++) {
            Long frontCategoryId = frontCategoryIdList.get(i);
            PcsSkuCategoryRelationCond cond = new PcsSkuCategoryRelationCond();
            cond.setSkuCode(backCategoryRelation.getSkuCode());
            cond.setCategoryId(frontCategoryId);
            List<PcsSkuCategoryRelation> frontRelationList = pcsSkuCategoryDomain.findFrontCategoryRelation(cond);
            List<Long> idList = new ArrayList<>();
            for (PcsSkuCategoryRelation relation : frontRelationList) {
                idList.add(relation.getId());
            }
            deleteFrontCategoryRelationList(idList);
        }
    }

    @Override
    public List<Long> findProductIdsByCategoryFrontRelationIds(List<Long> ids) {
        return pcsSkuCategoryDomain.findProductIdListByCategoryFrontRelationIds(ids);
    }

    @Override
    public List<PcsSkuCategoryRelationVO> findBackCategoryRelation(PcsSkuCategoryRelationCond cond) {
        List<PcsSkuCategoryRelation> relations = pcsSkuCategoryDomain.findBackCategoryRelationList(cond);
        return BeanUtil.buildListFrom(relations, PcsSkuCategoryRelationVO.class);
    }

    @Override
    public List<PcsFrontBackCategoryVO> findAllFrontBackCategoryList() {
        Map<String, Object> params = new HashMap<>();
        return pcsSkuCategoryDomain.findFrontBackCategoryList(params);
    }

    @Override
    public List<PcsSkuCategoryVO> findAllFrontCategoryList() {
        Map<String, Object> params = new HashMap<>();
        return pcsSkuCategoryDomain.findFrontCategoryList(params);
    }

    @Override
    public List<PcsSkuCategoryVO> findAllBackCategoryList() {
        Map<String, Object> params = new HashMap<>();
        List<PcsSkuCategoryVO> recordList = pcsSkuCategoryDomain.findBackCategoryList(params);
        return  recordList;
    }

	@Override
	public List<PcsSkuCategoryVO> findAllFirstBackCategoryList() {
		return pcsSkuCategoryDomain.findAllFirstBackCategoryList();
	}

	@Override
	public Long createFrontCategory(PcsSkuCategoryVO record) {
		return pcsSkuCategoryDomain.createFrontCategory(pcsSkuCategoryDomain.buildFromVO(record));
	}

	@Override
	public boolean updateFrontCategory(PcsSkuCategoryVO vo) {
		PcsSkuCategory record = pcsSkuCategoryDomain.buildFromVO(vo);
        return pcsSkuCategoryDomain.updateFrontCategory(record);
	}

	@Override
	@Transactional
	public boolean updateFrontBackCategoryRelationByFrontId(PcsFrontBackCategoryVO frontBackCategoryVO) {
		Long frontSkuCategoryId = frontBackCategoryVO.getFrontSkuCategoryId();
		List<Long> backSKuCategoryIdList = frontBackCategoryVO.getBackSKuCategoryIdList();
		if(frontSkuCategoryId != null){
			//删除前台类目对应的后台类目信息
			pcsSkuCategoryDomain.deleteFrontBackCategoryRelationByFrontId(frontSkuCategoryId);
			if(CollectionUtils.isNotEmpty(backSKuCategoryIdList)){
				for(Long id : backSKuCategoryIdList){
					PcsFrontBackCategoryVO vo = new PcsFrontBackCategoryVO();
					vo.setFrontSkuCategoryId(frontSkuCategoryId);
					vo.setBackSKuCategoryId(id);
					pcsSkuCategoryDomain.addFrontBackCategoryRelation(vo);
				}
			}

			return true;
		}

		return false;
	}

	@Override
	public List<PcsFrontBackCategoryVO> findRelationBackCategoryByFrontCategoryId(Long frontId) {
		return pcsSkuCategoryDomain.findRelationBackCategoryByFrontCategoryId(frontId);
	}
    @Override
    public Map<String,PcsSkuCategoryVO> findFirstCategoryBySkucodes(List<String> skuCodes) {


        Map map = new HashMap();
        List<PcsSkuCategoryVO> categoryList = pcsSkuCategoryMapper.findCodePNameBySkuCodeList(skuCodes);
        for(PcsSkuCategoryVO vo:categoryList){
            PcsSkuCategoryVO pcsSkuCategoryVO = new PcsSkuCategoryVO();
            if(vo.getId() != null){
                pcsSkuCategoryVO = pcsSkuCategoryDomain.findFirstCategoryByParentId(vo.getId());
            }
            pcsSkuCategoryVO.setProductName(vo.getProductName());
            map.put(vo.getSkucode(),pcsSkuCategoryVO);
        }
        return map;
    }

    @Override
    public Map<String,PcsSkuCategoryVO> findFirstCategoryIdBySkucodes(List<String> skuCodes) {
        Map map = new HashMap();
        log.info("findFirstCategoryIdBySkucodes skuCodes" + skuCodes);
        List<PcsSkuCategoryVO> categoryList = pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
        log.info("findFirstCategoryIdBySkucodes list" + categoryList);
        if(CollectionUtils.isNotEmpty(categoryList)) {
            for (PcsSkuCategoryVO vo : categoryList) {
                PcsSkuCategoryVO pcsSkuCategoryVO = new PcsSkuCategoryVO();
                log.info("findFirstCategoryIdBySkucodes vo" + vo);
                if(vo != null) {
                    if (vo.getId() != null) {
                        pcsSkuCategoryVO = pcsSkuCategoryDomain.findFirstCategoryByParentId(vo.getId());
                    }
                    map.put(vo.getSkucode(), pcsSkuCategoryVO);
                }
            }
        }
        return map;
    }

    @Override
    public PcsSkuCategoryVO findFirstCategoryById(Long id) {
        PcsSkuCategoryVO pcsSkuCategoryVO = pcsSkuCategoryDomain.findFirstCategoryByParentId(id);
        return pcsSkuCategoryVO;
    }

    @Override
    public Map<Long,PcsSkuCategoryVO> findFirstCategoryByIds(List<Long> ids) {
        Map<Long,PcsSkuCategoryVO> map = new HashMap<>();
        for(Long id : ids){
            PcsSkuCategoryVO pcsSkuCategoryVO = pcsSkuCategoryDomain.findFirstCategoryByParentId(id);
            map.put(id, pcsSkuCategoryVO);
        }
        return map;
    }

    @Override
    public List<Long> findByCondCategory(PcsSkuCategoryCond cond) {
        return pcsSkuCategoryDomain.findByCondCategory(cond);
    }

}
