/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.merchandise.cond.OpProductCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProductMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProductDomain;
import com.thebeastshop.pegasus.merchandise.service.McOpProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpProductExcelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpTagVO;
import com.thebeastshop.pegasus.merchandise.vo.OpWatermarkVO;

/**
 * @author Roy.Chen
 * @version $Id: OpProductServiceImpl.java, v 0.1 2015-08-19 14:17
 */
@Service("mcOpProductService")
public class McOpProductServiceImpl implements McOpProductService {
    private final static Logger LOGGER = LoggerFactory.getLogger(McOpProductServiceImpl.class);

    @Autowired
    private OpProductDomain opProductDomain;
    
    @Autowired
    private OpProductMapper opProductMapper;

    @Override
    public boolean update(final OpProductVO product) {
        return opProductDomain.update(product);
    }

    @Override
    public OpProductVO findById(Long id) {
        return opProductDomain.findById(id);
    }

    @Override
    public List<OpProductVO> findByIds(List<Long> ids) {
        return opProductDomain.findByIds(ids);
    }

    @Override
    public List<Long> findProductIdsByCampaignIds(List<Long> ids) {
        return opProductDomain.findProductIdsByCampaignIds(ids);
    }

    @Override
    public List<OpProductVO> findProdWithWatermarkByIds(List<Long> ids) {
        return opProductDomain.findProdWithWatermarkByIds(ids);
    }

    @Override
    public List<OpProductVO> findProdWithTagByIds(List<Long> ids) {
        return opProductDomain.findProdWithTagByIds(ids);
    }

    @Override
    public List<Long> findProdWatermarkProdIdsByParams(Map<String, Object> params) {
        return opProductDomain.findProdWatermarkProdIdsByParams(params);
    }

    @Override
    public List<Long> findProdTagProdIdsByParams(Map<String, Object> params) {
        return opProductDomain.findProdTagProdIdsByParams(params);
    }

    @Override
    public List<OpProductVO> listProdMat(Map<String, Object> params) {
        List<OpProduct> list = opProductDomain.listProdMat(params);
        return opProductDomain.buildFromModelList(list);
    }

    @Override
    public Long create(OpProductVO prod) {
        opProductDomain.create(prod);
        return prod.getId();
    }

    @Override
    public Long createCombinedProduct(OpProductVO prod) {
        opProductDomain.createCombinedProduct(prod);
        return prod.getId();
    }

    @Override
    public Boolean updateCombinedProduct(OpProductVO prod) {
        return opProductDomain.updateCombinedProduct(prod);
    }

    @Override
    public boolean updateProdAndSku(OpProductVO productVO) {
        return opProductDomain.updateProdAndSku(productVO);
    }

    @Override
    public boolean deleteById(Long id) {
        return opProductDomain.deleteById(id);
    }

    @Override
    public List<OpProductVO> findByCond(OpProductCond cond) {
        return opProductDomain.findByCond(cond);
    }


    @Override
    public List<OpProductVO> findBySkuCode(String skuCode) {
        return opProductDomain.findBySkuCode(skuCode);
    }

    @Override
    public List<OpProductExcelVO> findExportListByCond(OpProductCond cond) {
        return opProductDomain.findExportListByCond(cond);
    }

    @Override
    public List<OpProductVO> findByNameOrCode(String name) {
        return opProductDomain.findByNameOrCode(name);
    }

    @Override
    public List<OpProductVO> findByIds(List<Long> ids, boolean withCategories) {
        return opProductDomain.findByIds(ids,withCategories);
    }

    @Override
    public List<Long> findProductIdsByCodes(List<String> codes) {
        return opProductDomain.findProductIdsByCodes(codes);
    }

    @Override
    public int updateByExampleSelective(OpProductVO vo) {
        return opProductDomain.updateByExampleSelective(vo);
    }

    @Override
    public OpProductVO findProductByCode(String code) {
        return opProductDomain.findProductByCode(code);
    }

    @Override
    public List<OpWatermarkVO> queryWatermarksByProdId(Map<String, Object> params) {
        return opProductDomain.queryWatermarksByProdId(params);
    }

    @Override
    public List<OpTagVO> queryTagsByProdId(Map<String, Object> params) {
        return opProductDomain.queryTagsByProdId(params);
    }

    @Override
    public List<Map> listProdMat(OpProductCond cond) {
        return opProductDomain.listProdMat(cond);
    }

    @Override
    public Boolean isExistsSpecialCategory(Long productId, List<Integer> categoryIds) {
        return opProductDomain.isExistsSpecialCategory(productId, categoryIds);
    }

    @Override
    public Boolean isOnlyExistsSpecialCategory(Long productId, List<Integer> categoryIds) {
        return opProductDomain.isOnlyExistsSpecialCategory(productId, categoryIds);
    }

    @Override
	public Map getBatchUpdateMapByCode(String code) {
		return opProductMapper.getBatchUpdateMapByCode(code);
	}

    @Override
    public List<OpProductVO> findProdWithSpvByNameOrCode(String arg0){
        return opProductDomain.findProdWithSpvByNameOrCode(arg0);
    }

    @Override
    public OpProductVO findCombinedProdbyProdId(Long prodId){
        return opProductDomain.findCombinedProductByProdId(prodId);
    }

    @Override
    public List<OpProductVO> findCombinedProdAuditList(OpProductCond cond){
        return opProductDomain.findCombinedProdAuditList(cond);
    }

    public Boolean auditCombinedProd(OpProductCond cond){
        return opProductDomain.auditCombinedProdByProdId(cond);
    }


    @Override
    public Long getIdByCode(String code) {
        return opProductDomain.getIdByCode(code);
    }

    @Override
    public String getCodeById(Long id) {
        return opProductDomain.getCodeById(id);
    }

    @Override
    public Boolean getCrossBorderFlagListByCode(String code, Integer crossBorderFlag) {
        return opProductDomain.getCrossBorderFlagListByCode(code, crossBorderFlag);
    }
}