package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.dao.IDao;
import pers.richard.ormybatis.service.BaseService;

import com.thebeastshop.pegasus.merchandise.IService.ISupplierService;
import com.thebeastshop.scm.dao.SupplierDao;
import com.thebeastshop.scm.po.Supplier;

@Service
public class SupplierService extends BaseService<Supplier> implements ISupplierService {

	private SupplierDao supplierDao;
	
	@Autowired
	public SupplierService(@Qualifier("supplierDao") IDao dao) {
		super(dao);
		supplierDao = (SupplierDao)super.dao;
	}

	@Override
	public List<Supplier> byNameLike(String value) {
		return supplierDao.byNameLike(value);
	}


}
