package com.thebeastshop.pegasus.merchandise.price;


import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;

/**
 * 价格计算器
 * @author gongjun
 * @since 2016-12-29
 */
public interface PriceCalculator {

    /**
     * 取得上一个价格计算器
     * @return
     */
    PriceCalculator getPrevPriceCalculator();

    /**
     * 取得上一个价格
     * @return
     */
    BigDecimal getPrevPrice(List<PriceCalResultVO> results);

    /**
     * 是否有抢购
     * @return
     */
    boolean getHasRush();

    /**
     * 计算价格
     * @param results 计算价格结果集（收集每一步价格计算结果）
     * @return
     */
    BigDecimal calculate(List<PriceCalResultVO> results);

}
