package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuReceiveStandardMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuReceiveStandardRuleMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuReceiveStandardDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuReceiveStandard;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuReceiveStandardRule;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsSkuReceiveStandardDomain")
public class PcsSkuReceiveStandardDomainImpl implements PcsSkuReceiveStandardDomain {


    @Autowired
    private PcsSkuReceiveStandardMapper pcsSkuReceiveStandardMapper;

    @Autowired
    private PcsSkuReceiveStandardRuleMapper pcsSkuReceiveStandardRuleMapper;

    @Override
    public List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond) {
        return pcsSkuReceiveStandardMapper.listSkuByCond(cond);
    }

    @Override
    @Transactional
    public boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        if(EmptyUtil.isEmpty(vo.getId())){
            return createSkuReceiveStandard(vo);
        }else{
            return editSkuReceiveStandard(vo);
        }
    }

    @Override
    public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(
            String skuCode) {
        return pcsSkuReceiveStandardMapper.findPcsSkuReceiveStandardBySkuCode(skuCode);
    }

    @Override
    @Transactional
    public boolean editSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        updateSkuReciveStandardRule(vo);
        PcsSkuReceiveStandard record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandard.class);
        return pcsSkuReceiveStandardMapper.updateByPrimaryKeySelective(record)==1?true:false;
    }

    @Override
    @Transactional
    public boolean createSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        updateSkuReciveStandardRule(vo);
        PcsSkuReceiveStandard record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandard.class);
        return pcsSkuReceiveStandardMapper.insert(record)==1?true:false;
    }

    private void updateSkuReciveStandardRule(PcsSkuReceiveStandardVO vo){
        pcsSkuReceiveStandardMapper.deleteSkuReceiveStandardRuleBySkuCode(vo.getSkuCode());
        if(EmptyUtil.isNotEmpty(vo.getSkuRuleList())){
            for(PcsSkuReceiveStandardRuleVO skuRule : vo.getSkuRuleList()){
                pcsSkuReceiveStandardMapper.insertSkuReceiveStandardRule(skuRule);
            }
        }
    }

    public List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule(){
        return pcsSkuReceiveStandardRuleMapper.findAllReceiveStandardRule();
    }

    public List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(String skuCode){
        return pcsSkuReceiveStandardRuleMapper.findSkuReceiveStandardRule(skuCode);
    }

    public PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id){
        PcsSkuReceiveStandardRule rule = pcsSkuReceiveStandardRuleMapper.selectByPrimaryKey(id);
        PcsSkuReceiveStandardRuleVO ruleVO = new PcsSkuReceiveStandardRuleVO();
        BeanUtils.copyProperties(rule, ruleVO);
        return ruleVO;
    }

    @Override
    @Transactional
    public boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
        vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_ON);
        PcsSkuReceiveStandardRule record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandardRule.class);
        return pcsSkuReceiveStandardRuleMapper.insert(record)==1?true:false;
    }

    @Override
    @Transactional
    public boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
        PcsSkuReceiveStandardRule record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandardRule.class);
        return pcsSkuReceiveStandardRuleMapper.updateByPrimaryKeySelective(record)==1?true:false;
    }

    @Override
    @Transactional
    public boolean deleteReceiveStandardRule(Long id){
        PcsSkuReceiveStandardRuleVO vo = new PcsSkuReceiveStandardRuleVO();
        vo.setId(id);
        vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_OFF);
        return updateReceiveStandardRule(vo);
    }

}
