package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsCustomizeElementCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsCustomizeElementMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeElementDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsCustomizeElement;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeElementVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsCustomizeElementDomain")
public class PcsCustomizeElementDomainImpl extends AbstractBaseDomain<PcsCustomizeElementVO, PcsCustomizeElement> implements PcsCustomizeElementDomain {


    private final Logger log = LoggerFactory.getLogger(PcsCustomizeElementDomainImpl.class);

    @Autowired
    private PcsCustomizeElementMapper pcsCustomizeElementMapper;

    @Override
    @Transactional
    public Long create(PcsCustomizeElement record) {
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setActive(true);
        pcsCustomizeElementMapper.insertSelective(record);
        return record.getId();
    }

    @Override
    @Transactional
    public boolean update(PcsCustomizeElement record) {
        record.setUpdateTime(new Date());
        return pcsCustomizeElementMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public List<PcsCustomizeElementVO> findByCode(String code) {
        return pcsCustomizeElementMapper.findByCode(code);
    }

    @Override
    public List<PcsCustomizeElementVO> findByCond(PcsCustomizeElementCond cond) {
        return pcsCustomizeElementMapper.findByCond(cond);
    }

}
