package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpSpvPriceChangeMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpSpvPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.model.OpSpvPriceChange;
import com.thebeastshop.pegasus.merchandise.model.OpSpvPriceChangeExample;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvPriceChangeVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-10-28
 */
@Component("opSpvPriceChangeDomain")
public class OpSpvPriceChangeDomainImpl extends AbstractBaseDomain<OpSpvPriceChangeVO, OpSpvPriceChange>
        implements OpSpvPriceChangeDomain {

    @Autowired
    private OpSpvPriceChangeMapper opSpvPriceChangeMapper;

    @Override
    public int create(OpSpvPriceChange spvPriceChange) {
        return opSpvPriceChangeMapper.insert(spvPriceChange);
    }

    @Override
    public int update(OpSpvPriceChange spvPriceChange) {
        return opSpvPriceChangeMapper.updateByPrimaryKeySelective(spvPriceChange);
    }

    @Override
    public int updateBySpvId(Map map) {
        return opSpvPriceChangeMapper.updateBySpvId(map);
    }

    @Override
    public OpSpvPriceChange getCurrentAduitPrice(Long spvId) {
        OpSpvPriceChangeExample example = new OpSpvPriceChangeExample();
        example.createCriteria()
                .andSpvIdEqualTo(spvId)
                .andIsCurrentEqualTo(1);
        List<OpSpvPriceChange> list = opSpvPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public int updatePriceChangeStatusByProductId(Long productId ,Integer changeStatus){
        final Map<String, Object> params = new HashMap<>();
        params.put("changeStatus", changeStatus);
        params.put("productId", productId);
        return opSpvPriceChangeMapper.updateChangeStatusByProductId(params);
    }
}
