package com.thebeastshop.pegasus.merchandise.domain;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplier;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierBusinessCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierManufacturer;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierPurchaseCategory;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierManufacturerVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.merchandise.vo.SupplierBrandRelation;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface PcsSupplierDomain extends BaseDomain<PcsSupplierVO, PcsSupplier> {

    /**
     * 创建供应商
     *
     * @param record
     * @return
     */
    Long create(PcsSupplier record, boolean saveDraft);

    /**
     * 更新供应商
     *
     * @param record
     * @return
     */
    Boolean update(PcsSupplier record, boolean saveDraft);

    /**
     * 根据ID查找供应商
     *
     * @param id
     * @return
     */
    PcsSupplier findById(Long id);

    /**
     * 根据供应商名称和状态查找供应商
     *
     * @param cond
     * @return
     */
    List<PcsSupplierVO> findByCond(PcsSupplierCond cond);

    /**
     * 根据条件查找供应商
     *
     * @param cond
     * @return
     */
    List<PcsSupplier> findByCriteria(PcsSupplierCond cond);

    /**
     * 根据名称查找供应商
     *
     * @param name
     * @return
     */
    List<PcsSupplier> findByName(String name);

    /**
     * 根据id集合查找供应商
     *
     * @param ids
     * @return
     */
    List<PcsSupplier> findByIds(List<Long> ids);

    /**
     * 供应商审核
     * @param id
     * @param isPass
     * @return
     */
    Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type);

    long countByCond(PcsSupplierCond cond);
    
    /**
     * 查询供应商和品牌关联关系
     *
     * @param cond
     * @return
     */
    List<SupplierBrandRelation> findSupplierBrandRelation();
    
    
    Integer addSupplierBusinessCategory(PcsSupplierBusinessCategory supplierBusinessCategory);
    
    Integer addSupplierPurchaseCategory(PcsSupplierPurchaseCategory supplierPurchaseCategory);

    int deleteBusinessCategoryBySupplierId(Integer supplierId);
    
    int deletePurchaseCategoryBySupplierId(Integer supplierId);

    List<String> findBusinessCategoryBySupplierId(Integer supplierId);
    
    List<String> findPurchaseCategoryBySupplierId(Integer supplierId);
    
    
    public Boolean update(PcsSupplier record); 
    
    Integer addFactory(PcsSupplierManufacturer pcsSupplierManufacturer);
    
    /**
     * 删除供应商下的工厂
     * @param supplierId
     * @return
     */
    int deleteFactoryBySupplierId(Integer supplierId);
    
    /**
     * 查询供应商下的所有制造商
     * @param supplierId
     * @return
     */
    List<PcsSupplierManufacturerVO> findManufacturersBySupplierId(Integer supplierId);
}
