/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.client.CampaignClient;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignCondVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignProductCondVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignSectionProductVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignSectionVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.utils.ApiUtils;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.DateRange;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.service.McOpProductService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.service.impl.BasePsServiceImpl;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsChnProdSaleSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.collect.Maps;
import org.forest.core.ForestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/pub/product")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPsProductService")
public class McPsProductServiceImpl
extends BasePsServiceImpl<PsProductVO>
implements McPsProductService {
    private static final Logger LOGGER = LoggerFactory.getLogger(McPsProductServiceImpl.class);
    @Autowired
    private ForestConfiguration forestConfiguration;
    private CampaignClient campaignClient;
    @Autowired
    private ProductClient client;
    @Autowired
    private McPcsSkuCategoryService mcPcsSkuCategoryService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private McPsSkuService mcPsSkuService;
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McOpProductService mcOpProductService;
    private static final String specialNum = "462";
    private static final String special481Num = "481";
    private static final String special482Num = "482";
    private static final String special463Num = "463";
    private static final String special503Num = "503";
    private static final Map<String, BigDecimal> specialProdMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> specialSkuMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special481ProdMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special481SkuMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special482ProdMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special482SkuMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special463ProdMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special463SkuMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special503ProdMap = new HashMap<String, BigDecimal>();
    private static final Map<String, BigDecimal> special503SkuMap = new HashMap<String, BigDecimal>();

    static {
        specialProdMap.put("PROD001014105", new BigDecimal(499));
        specialProdMap.put("PROD001013171", new BigDecimal(499));
        specialProdMap.put("PROD001016880", new BigDecimal(499));
        specialProdMap.put("PROD001016881", new BigDecimal(499));
        specialProdMap.put("PROD001016628", new BigDecimal(599));
        specialProdMap.put("PROD001016627", new BigDecimal(599));
        specialProdMap.put("PROD001015528", new BigDecimal(1399));
        specialProdMap.put("PROD001015529", new BigDecimal(1999));
        specialSkuMap.put("411160162", new BigDecimal(499));
        specialSkuMap.put("411160172", new BigDecimal(599));
        specialSkuMap.put("S00300000013492", new BigDecimal(499));
        specialSkuMap.put("S00300000013493", new BigDecimal(599));
        specialSkuMap.put("S00300000013958", new BigDecimal(499));
        specialSkuMap.put("S00300000013959", new BigDecimal(599));
        specialSkuMap.put("S00300000013954", new BigDecimal(499));
        specialSkuMap.put("S00300000013955", new BigDecimal(599));
        specialSkuMap.put("411161992", new BigDecimal(599));
        specialSkuMap.put("411162002", new BigDecimal(699));
        specialSkuMap.put("411162012", new BigDecimal(599));
        specialSkuMap.put("411162022", new BigDecimal(699));
        specialSkuMap.put("412160542", new BigDecimal(1399));
        specialSkuMap.put("412160552", new BigDecimal(1499));
        specialSkuMap.put("412160582", new BigDecimal(1999));
        specialSkuMap.put("412160592", new BigDecimal(2199));
        special481ProdMap.put("PROD001013069", new BigDecimal(60));
        special481ProdMap.put("PROD001013065", new BigDecimal(60));
        special481ProdMap.put("PROD001013068", new BigDecimal(60));
        special481ProdMap.put("PROD001013067", new BigDecimal(60));
        special481SkuMap.put("17035071", new BigDecimal(169));
        special481SkuMap.put("17035073", new BigDecimal(169));
        special481SkuMap.put("17035076", new BigDecimal(169));
        special481SkuMap.put("16036075", new BigDecimal(169));
        special482ProdMap.put("PROD001013910", new BigDecimal(78));
        special482SkuMap.put("17035081", new BigDecimal(263));
        special463ProdMap.put("PROD001015182", new BigDecimal(299));
        special463ProdMap.put("PROD001015184", new BigDecimal(299));
        special463ProdMap.put("PROD001015185", new BigDecimal(299));
        special463SkuMap.put("411161282", new BigDecimal(799));
        special463SkuMap.put("411161292", new BigDecimal(899));
        special463SkuMap.put("411161302", new BigDecimal(799));
        special463SkuMap.put("411161312", new BigDecimal(899));
        special463SkuMap.put("411161322", new BigDecimal(799));
        special463SkuMap.put("411161332", new BigDecimal(899));
        special503ProdMap.put("PROD001016628", new BigDecimal(599));
        special503ProdMap.put("PROD001016627", new BigDecimal(599));
        special503SkuMap.put("411161992", new BigDecimal(599));
        special503SkuMap.put("411162002", new BigDecimal(699));
        special503SkuMap.put("411162012", new BigDecimal(599));
        special503SkuMap.put("411162022", new BigDecimal(699));
    }

    @Autowired
    public void init() {
        this.campaignClient = (CampaignClient)this.forestConfiguration.createInstance(CampaignClient.class);
    }

    @Override
    public AbstractESClient<PsProductVO> getESClient() {
        return this.client;
    }

    @GET
    @Path(value="name/{name}")
    public List<PsProductVO> findByProdName(@PathParam(value="name") String name) {
        return this.client.findByField("name", name);
    }

    @GET
    @Path(value="code/{code}")
    public List<PsProductVO> findByProdCode(@PathParam(value="code") String code) {
        return this.client.findByField("code", code);
    }

    public PsProductVO findByProdId(Long prodId) {
        PsProductCond cond = new PsProductCond();
        cond.setId(prodId.toString());
        List<PsProductVO> prods = this.findByCond(cond);
        if (CollectionUtils.isNotEmpty(prods)) {
            return prods.get(0);
        }
        return null;
    }

    public List<PsProductVO> findByCond(PsProductCond cond) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        if (CollectionUtils.isNotEmpty((Collection)cond.getIds())) {
            params.put("id", cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");
        if (CollectionUtils.isNotEmpty((Collection)cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");
        String primaryUpdateTime = MapUtils.getString((Map)params, (Object)"primaryUpdateTime");
        if (primaryUpdateTime != null) {
            params.remove("primaryUpdateTime");
        }
        if (cond.getMatchCampaign().booleanValue() && CollectionUtils.isEmpty((Collection)cond.getCodes()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cond.getCode()) && CollectionUtils.isEmpty((Collection)cond.getIds())) {
            return new ArrayList<PsProductVO>();
        }
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, (PsMatchCampaignCond)cond, true);
        }
        return productVOList;
    }

    public List<PsProductVO> findByCond(PsProductCond cond, boolean matchGlobalCampaigns) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        if (CollectionUtils.isNotEmpty((Collection)cond.getIds())) {
            params.put("id", cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");
        if (CollectionUtils.isNotEmpty((Collection)cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");
        if (cond.getMatchCampaign().booleanValue() && CollectionUtils.isEmpty((Collection)cond.getCodes()) && CollectionUtils.isEmpty((Collection)cond.getIds())) {
            return new ArrayList<PsProductVO>();
        }
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, (PsMatchCampaignCond)cond, matchGlobalCampaigns);
        }
        return productVOList;
    }

    private void matchProductsCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond, boolean matchGlobalCampaigns) {
        if (matchGlobalCampaigns) {
            StopWatch sw = new StopWatch();
            sw.start();
            ArrayList<CampaignProductCondVO> productCondList = new ArrayList<CampaignProductCondVO>();
            for (PsProductVO productVO : productVOList) {
                CampaignProductCondVO productCondVO = new CampaignProductCondVO();
                productCondVO.setProductId(Long.valueOf(productVO.getId()));
                productCondVO.setCategoryId(productVO.getCategoryId());
                productCondVO.setCrossBorderFlag(productVO.getCrossBorderFlag());
                productCondList.add(productCondVO);
            }
            Map<String, List<PsCampaignVO>> campaignListMap = this.getProductCampaignListMapV2(productCondList, true, cond.getMemberLevel(), cond.getAccessWay());
            for (PsProductVO productVO : productVOList) {
                List<PsCampaignVO> campList = campaignListMap.get(productVO.getId());
                ArrayList<PsCampaignVO> list = new ArrayList<PsCampaignVO>();
                if (CollectionUtils.isNotEmpty(campList)) {
                    list.addAll(campList);
                }
                productVO.setCampaignList(list);
            }
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5339\u914d\u6d3b\u52a8 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        }
        this.matchProductCampaigns(productVOList, cond);
    }

    public Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond) {
        List<PsProductVO> productList = this.findByCond(cond);
        if (EmptyUtil.isEmpty(productList)) {
            return new HashMap<String, List<PsCampaignVO>>();
        }
        HashMap<String, List<PsCampaignVO>> map = new HashMap<String, List<PsCampaignVO>>();
        for (PsProductVO productVO : productList) {
            List prodList = productVO.getCampaignList();
            map.put(productVO.getCode(), prodList);
        }
        return map;
    }

    @Deprecated
    public Map<String, List<PsCampaignVO>> getProductCampaignListMap(List<Long> productIdList, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(Integer.valueOf(1));
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductIdList(productIdList);
        cond.setCategoryId(cateId);
        cond.setFromRedis(Boolean.valueOf(true));
        cond.setContainsGlobal(Boolean.valueOf(containsGlobal));
        String params = JSON.toJSONString((Object)cond);
        ApiResult campaignResult = this.campaignClient.mapListCampaign(params);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            HashMap<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<String, List<PsCampaignVO>>();
            Map campaignVOListMap = (Map)campaignResult.getData();
            for (Long id : campaignVOListMap.keySet()) {
                List campaignVOList = (List)campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = McPsProductServiceImpl.convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<String, List<PsCampaignVO>>();
    }

    public Map<String, List<PsCampaignVO>> getProductCampaignListMapV2(List<CampaignProductCondVO> productCondList, boolean containsGlobal, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(Integer.valueOf(-1));
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductCondList(productCondList);
        cond.setFromRedis(Boolean.valueOf(true));
        cond.setContainsGlobal(Boolean.valueOf(containsGlobal));
        String params = JSON.toJSONString((Object)cond);
        ApiResult campaignResult = this.campaignClient.mapListCampaign_V1_0_1(params);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            HashMap<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<String, List<PsCampaignVO>>();
            Map campaignVOListMap = (Map)campaignResult.getData();
            for (Long id : campaignVOListMap.keySet()) {
                List campaignVOList = (List)campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = McPsProductServiceImpl.convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<String, List<PsCampaignVO>>();
    }

    public static List<PsCampaignVO> convertCampaignList(List<CampaignVO> voList) {
        ArrayList<PsCampaignVO> psList = new ArrayList<PsCampaignVO>();
        for (CampaignVO vo : voList) {
            PsCampaignVO ps = new PsCampaignVO();
            ps.setId(vo.getId());
            ps.setName(vo.getName());
            ps.setTitle(vo.getTitle());
            ps.setState(vo.getState());
            ps.setCumulative(vo.getCumulative());
            ps.setDiscountTypeId(vo.getDiscountTypeId());
            TypeVO dicountType = vo.getDiscountType();
            if (dicountType != null) {
                ps.setDiscountTypeName(dicountType.getName());
            }
            ps.setCrossBorderFlag(vo.getCrossBorderFlag());
            ps.setMemberLevels(vo.getMemberLevels());
            ps.setAccessWayIds(vo.getAccessWayIds());
            ps.setCreateTime(vo.getCreateTime());
            ps.setStartTime(vo.getStartTime());
            ps.setExpireTime(vo.getExpireTime());
            ps.setProductScopeId(vo.getProductScopeId());
            ps.setApprovalState(vo.getApprovalState());
            List campaignSectionVOList = vo.getCampaignSectionList();
            if (EmptyUtil.isNotEmpty((List)campaignSectionVOList)) {
                ArrayList<PsCampaignSectionVO> psCampaignSectionList = new ArrayList<PsCampaignSectionVO>();
                for (CampaignSectionVO campaignSectionVO : campaignSectionVOList) {
                    PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                    psCampaignSectionVO.setId(campaignSectionVO.getId());
                    psCampaignSectionVO.setCampaignId(vo.getId());
                    TypeVO conditionType = campaignSectionVO.getConditionType();
                    if (conditionType != null) {
                        psCampaignSectionVO.setConditionType(conditionType.getId());
                    }
                    psCampaignSectionVO.setLine(campaignSectionVO.getLine());
                    psCampaignSectionVO.setFactorType(campaignSectionVO.getFactorType());
                    psCampaignSectionVO.setFactor(campaignSectionVO.getFactor());
                    psCampaignSectionVO.setRanking(campaignSectionVO.getRanking());
                    List campaignSectionProductVOList = campaignSectionVO.getCampaignSectionProductList();
                    if (EmptyUtil.isNotEmpty((List)campaignSectionProductVOList)) {
                        ArrayList<PsCampaignSectionProductVO> psCampaignSectionProductList = new ArrayList<PsCampaignSectionProductVO>();
                        for (CampaignSectionProductVO campaignSectionProductVO : campaignSectionProductVOList) {
                            PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                            psCampaignSectionProductVO.setId(campaignSectionProductVO.getId());
                            psCampaignSectionProductVO.setCampaignId(vo.getId());
                            psCampaignSectionProductVO.setCampaignSectionId(campaignSectionProductVO.getCampaignSectionId());
                            psCampaignSectionProductVO.setProductId(campaignSectionProductVO.getAdditionalProductId());
                            psCampaignSectionProductVO.setPricePrice(campaignSectionProductVO.getAdditionalProductPrice());
                            psCampaignSectionProductVO.setPriceCount(campaignSectionProductVO.getAdditionalProductCount());
                            psCampaignSectionProductList.add(psCampaignSectionProductVO);
                        }
                        psCampaignSectionVO.setCampaignSectionProducts(psCampaignSectionProductList);
                    }
                    psCampaignSectionList.add(psCampaignSectionVO);
                }
                ps.setCampaignSectionList(psCampaignSectionList);
            }
            psList.add(ps);
        }
        return psList;
    }

    public List<PsCampaignVO> getProductCampaignList(Long productId, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductId(productId);
        cond.setCategoryId(cateId);
        cond.setFromRedis(Boolean.valueOf(true));
        cond.setContainsGlobal(Boolean.valueOf(containsGlobal));
        ApiResult campaignResult = this.campaignClient.listCampaign(cond);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            List campaignVOList = (List)campaignResult.getData();
            List<PsCampaignVO> psCampaignList = McPsProductServiceImpl.convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<PsCampaignVO>();
    }

    public List<PsCampaignVO> getGlobalCampaignList(Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateIds((List)Lists.newArrayList((Object[])new Integer[]{-1}));
        cond.setProductScopes((List)Lists.newArrayList((Object[])new Integer[]{3}));
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setFromRedis(Boolean.valueOf(true));
        ApiResult campaignResult = this.campaignClient.listCampaign(cond);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            List campaignVOList = (List)campaignResult.getData();
            List<PsCampaignVO> psCampaignList = McPsProductServiceImpl.convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<PsCampaignVO>();
    }

    private void matchProductCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond matchCampaignCond) {
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign() != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchProductCampaigns(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay());
        }
    }

    private void matchProductCampaigns(List<PsProductVO> productVOList, Integer memberLavel, Integer accessWay) {
        for (PsProductVO productVO : productVOList) {
            List campaignList = productVO.getCampaignList();
            if (EmptyUtil.isEmpty((List)campaignList)) continue;
            List<PsCampaignVO> matchedCampaignList = this.matchCampaignList(campaignList, productVO, memberLavel, accessWay);
            productVO.setCampaignList(matchedCampaignList);
        }
    }

    public List<PsCampaignVO> matchCampaignList(List<PsCampaignVO> campaignList, PsProductVO productVO, Integer memberLavel, Integer accessWay) {
        ArrayList<PsCampaignVO> results = new ArrayList<PsCampaignVO>();
        for (PsCampaignVO campaignVO : campaignList) {
            boolean cbFlag;
            int awId = accessWay == null ? -1 : accessWay;
            int mlId = memberLavel == null ? -1 : memberLavel;
            boolean bl = cbFlag = productVO.getCrossBorderFlag() != null && productVO.getCrossBorderFlag() == 1;
            if (!campaignVO.match(awId, mlId, cbFlag)) continue;
            results.add(campaignVO);
        }
        return results;
    }

    public List<PsProductVO> findByFields(Map<String, Object> params) {
        return this.client.findByFields(params, SearchType.ANDLIKE);
    }

    public List<PsProductVO> findByNameOrNameCN(Map<String, Object> params) {
        return this.client.findByFields(params, SearchType.ORLIKE);
    }

    public List<PsProductVO> calculateDiscountPrice(List<PsProductVO> productList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        for (PsProductVO productVO : productList) {
            this.calulateProductDiscountPrice(productVO, memberLevel, accessWay, discountAmount);
        }
        return productList;
    }

    public PsSkuVO calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond) {
        BigDecimal originalPrice = new BigDecimal(String.valueOf(skuVO.getSalesPrice()));
        if (cond.getMatchCampaign() != null && cond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(Arrays.asList(productVO), cond, true);
            List campaignList = productVO.getCampaignList();
            skuVO.setCampaignList(campaignList);
            boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
            BigDecimal targetPrice = this.calculateDiscountPriceSpecial((Boolean)allowVipDiscount, originalPrice, (List<PsCampaignVO>)campaignList, cond.getMemberLevel(), cond.getAccessWay(), cond.getDiscount(), skuVO);
            skuVO.setDiscountPrice(targetPrice);
        }
        return skuVO;
    }

    public PsSkuVO calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond) {
        PsProductVO productVO = this.findProdBySkuCode(skuVO.getSkuCode());
        if (productVO == null) {
            return skuVO;
        }
        this.calculateDiscountPrice(productVO, skuVO, cond);
        return skuVO;
    }

    public PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond) {
        if (productVO == null) {
            return spvVO;
        }
        BigDecimal originalPrice = new BigDecimal(String.valueOf(spvVO.getSalesPrice()));
        if (cond.getMatchCampaign() != null && cond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(Arrays.asList(productVO), cond, true);
            List campaignList = productVO.getCampaignList();
            boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
            BigDecimal targetPrice = this.calculateDiscountPriceSpecial((Boolean)allowVipDiscount, originalPrice, (List<PsCampaignVO>)campaignList, cond.getMemberLevel(), cond.getAccessWay(), cond.getDiscount(), spvVO);
            spvVO.setDiscountPrice(targetPrice);
        }
        return spvVO;
    }

    public PsProductVO calculateDiscountPrice(PsProductVO product, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        return this.calulateProductDiscountPrice(product, memberLevel, accessWay, discountAmount);
    }

    private PsProductVO calulateProductDiscountPrice(PsProductVO productVO, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        List campaignList = productVO.getCampaignList();
        BigDecimal originalPrice = productVO.getListPrice();
        boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
        BigDecimal targetPrice = this.calculateDiscountPrice(productVO, allowVipDiscount, originalPrice, campaignList, memberLevel, accessWay, discountAmount);
        productVO.setDiscountPrice(targetPrice);
        return productVO;
    }

    private BigDecimal calculateDiscountPrice(PsProductVO productVO, Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        BigDecimal targetPrice = originalPrice;
        for (PsCampaignVO campaign : campaignList) {
            List sectionList;
            if (campaign.getState() == null || campaign.getState() != 1 || campaign.getDiscountTypeId() != 1 || campaign.getStartTime() == null || campaign.getExpireTime() == null) continue;
            Date now = new Date();
            if (campaign.getStartTime().after(now) || campaign.getExpireTime().before(now) || CollectionUtils.isEmpty((Collection)(sectionList = campaign.getCampaignSectionList()))) continue;
            PsCampaignSectionVO section = (PsCampaignSectionVO)sectionList.get(0);
            Long campaignId = campaign.getId();
            LOGGER.info("===\u5217\u8868\u4ef7\u53c2\u6570\u4e3a campaignId= {},code= {}", (Object)campaignId, (Object)productVO.getCode());
            if (specialNum.equals(String.valueOf(campaignId)) && specialProdMap.containsKey(productVO.getCode())) {
                targetPrice = specialProdMap.get(productVO.getCode());
                LOGGER.info("===\u7279\u6b8a\u5217\u8868\u4ef7\u53c2\u6570\u4e3a targetPrice= {}", (Object)targetPrice);
                continue;
            }
            if (special481Num.equals(String.valueOf(campaignId)) && special481ProdMap.containsKey(productVO.getCode())) {
                targetPrice = special481ProdMap.get(productVO.getCode());
                LOGGER.info("===481\u7279\u6b8a\u5217\u8868\u4ef7\u53c2\u6570\u4e3a targetPrice= {}", (Object)targetPrice);
                continue;
            }
            if (special482Num.equals(String.valueOf(campaignId)) && special482ProdMap.containsKey(productVO.getCode())) {
                targetPrice = special482ProdMap.get(productVO.getCode());
                LOGGER.info("===482\u7279\u6b8a\u5217\u8868\u4ef7\u53c2\u6570\u4e3a targetPrice= {}", (Object)targetPrice);
                continue;
            }
            if (special463Num.equals(String.valueOf(campaignId)) && special463ProdMap.containsKey(productVO.getCode())) {
                targetPrice = special463ProdMap.get(productVO.getCode());
                LOGGER.info("===463\u7279\u6b8a\u5217\u8868\u4ef7\u53c2\u6570\u4e3a targetPrice= {}", (Object)targetPrice);
                continue;
            }
            if (special503Num.equals(String.valueOf(campaignId)) && special503ProdMap.containsKey(productVO.getCode())) {
                targetPrice = special503ProdMap.get(productVO.getCode());
                continue;
            }
            BigDecimal factor = section.getFactor();
            Integer factorType = section.getFactorType();
            if (factor == null || factorType == null) continue;
            if (factorType.equals(1)) {
                targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
                continue;
            }
            if (!factorType.equals(2)) continue;
            targetPrice = factor;
        }
        if (allowVipDiscount != null && allowVipDiscount.booleanValue() && discountAmount != null) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        LOGGER.info("===\u6700\u7ec8\u4ef7\u683c targetPrice= {}", (Object)targetPrice);
        return targetPrice;
    }

    private BigDecimal calculateDiscountPriceSpecial(Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount, PsSpvVO spvVO) {
        if (discountAmount == null) {
            throw new PublicException("\u4f1a\u5458\u6298\u6263\u7387\u53c2\u6570\u6ca1\u6709\u4f20");
        }
        BigDecimal targetPrice = originalPrice;
        for (PsCampaignVO campaign : campaignList) {
            List sectionList;
            if (campaign.getState() == null || campaign.getState() != 1 || campaign.getDiscountTypeId() != 1 || campaign.getStartTime() == null || campaign.getExpireTime() == null) continue;
            Date now = new Date();
            if (campaign.getStartTime().after(now) || campaign.getExpireTime().before(now) || CollectionUtils.isEmpty((Collection)(sectionList = campaign.getCampaignSectionList()))) continue;
            PsCampaignSectionVO section = (PsCampaignSectionVO)sectionList.get(0);
            Long campaignId = campaign.getId();
            if (spvVO.getCombined() != null && spvVO.getCombined().booleanValue()) {
                String skuCode = spvVO.getSkuCode();
                if (specialNum.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                    if (!specialSkuMap.containsKey(skuCode)) continue;
                    LOGGER.info("===\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)specialSkuMap.get(skuCode));
                    targetPrice = specialSkuMap.get(skuCode);
                    continue;
                }
                if (special481Num.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===481\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                    if (!special481SkuMap.containsKey(skuCode)) continue;
                    LOGGER.info("===481\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)special481SkuMap.get(skuCode));
                    targetPrice = special481SkuMap.get(skuCode);
                    continue;
                }
                if (special482Num.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===482\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                    if (!special482SkuMap.containsKey(skuCode)) continue;
                    LOGGER.info("===482\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)special482SkuMap.get(skuCode));
                    targetPrice = special482SkuMap.get(skuCode);
                    continue;
                }
                if (special463Num.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===463\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                    if (!special463SkuMap.containsKey(skuCode)) continue;
                    LOGGER.info("===463\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)special463SkuMap.get(skuCode));
                    targetPrice = special463SkuMap.get(skuCode);
                    continue;
                }
                if (!special503Num.equals(String.valueOf(campaignId)) || !special503SkuMap.containsKey(skuCode)) continue;
                targetPrice = special503SkuMap.get(skuCode);
                continue;
            }
            BigDecimal factor = section.getFactor();
            Integer factorType = section.getFactorType();
            if (factor == null || factorType == null) continue;
            if (factorType.equals(1)) {
                targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
                continue;
            }
            if (!factorType.equals(2)) continue;
            targetPrice = factor;
        }
        if (allowVipDiscount != null && allowVipDiscount.booleanValue()) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        return targetPrice;
    }

    private BigDecimal calculateDiscountPriceSpecial(Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount, PsSkuVO skuVO) {
        BigDecimal targetPrice = originalPrice;
        for (PsCampaignVO campaign : campaignList) {
            List sectionList;
            if (campaign.getState() == null || campaign.getState() != 1 || campaign.getDiscountTypeId() != 1 || campaign.getStartTime() == null || campaign.getExpireTime() == null) continue;
            Date now = new Date();
            if (campaign.getStartTime().after(now) || campaign.getExpireTime().before(now) || CollectionUtils.isEmpty((Collection)(sectionList = campaign.getCampaignSectionList()))) continue;
            PsCampaignSectionVO section = (PsCampaignSectionVO)sectionList.get(0);
            Long campaignId = campaign.getId();
            String skuCode = skuVO.getSkuCode();
            if (specialNum.equals(String.valueOf(campaignId))) {
                LOGGER.info("===\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (!specialSkuMap.containsKey(skuCode)) continue;
                LOGGER.info("===\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)specialSkuMap.get(skuCode));
                targetPrice = specialSkuMap.get(skuCode);
                continue;
            }
            if (special481Num.equals(String.valueOf(campaignId))) {
                LOGGER.info("===481\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (!special481SkuMap.containsKey(skuCode)) continue;
                LOGGER.info("===481\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)special481SkuMap.get(skuCode));
                targetPrice = special481SkuMap.get(skuCode);
                continue;
            }
            if (special482Num.equals(String.valueOf(campaignId))) {
                LOGGER.info("===482\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (!special482SkuMap.containsKey(skuCode)) continue;
                LOGGER.info("===482\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)special482SkuMap.get(skuCode));
                targetPrice = special482SkuMap.get(skuCode);
                continue;
            }
            if (special463Num.equals(String.valueOf(campaignId))) {
                LOGGER.info("===463\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (!special463SkuMap.containsKey(skuCode)) continue;
                LOGGER.info("===463\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", (Object)special463SkuMap.get(skuCode));
                targetPrice = special463SkuMap.get(skuCode);
                continue;
            }
            if (special503Num.equals(String.valueOf(campaignId))) {
                if (!special503SkuMap.containsKey(skuCode)) continue;
                targetPrice = special503SkuMap.get(skuCode);
                continue;
            }
            BigDecimal factor = section.getFactor();
            Integer factorType = section.getFactorType();
            if (factor == null || factorType == null) continue;
            if (factorType.equals(1)) {
                targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
                continue;
            }
            if (!factorType.equals(2)) continue;
            targetPrice = factor;
        }
        if (allowVipDiscount != null && allowVipDiscount.booleanValue()) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        return targetPrice;
    }

    public boolean updateBySkuCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return true;
        }
        if (skuCodes.size() > 100) {
            int all = skuCodes.size() / 100;
            int i = 0;
            while (i < all) {
                List<String> subSkuCodes = skuCodes.subList(i * 100, (i + 1) * 100);
                if (!this.updateBySkuCodes100(subSkuCodes)) {
                    throw new PublicException("\u66f4\u65b0prod updateTime \u51fa\u9519");
                }
                ++i;
            }
            if (skuCodes.size() > all * 100) {
                List<String> subSkuCodes = skuCodes.subList(all * 100, skuCodes.size());
                this.updateBySkuCodes100(subSkuCodes);
            }
            return true;
        }
        return this.updateBySkuCodes100(skuCodes);
    }

    private boolean updateBySkuCodes100(List<String> skuCodes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodes", skuCodes);
        params.put("pagenum", Integer.MAX_VALUE);
        List updateProds = this.client.findByFields(params, SearchType.OR);
        for (PsProductVO updateProd : updateProds) {
            List prodSkus;
            if (CollectionUtils.isEmpty((Collection)updateProd.getSkuCodes()) || CollectionUtils.isEmpty((Collection)(prodSkus = this.mcPsSkuService.findBySkuCodes(updateProd.getSkuCodes())))) continue;
            PsSkuVO psSkuVO = (PsSkuVO)prodSkus.get(0);
            if (updateProd.getSkuCodes().size() == 1) {
                updateProd.setListPrice(new BigDecimal(psSkuVO.getSalesPrice()));
            } else {
                for (PsSkuVO prodSku : prodSkus) {
                    if (!(updateProd.getListPrice().doubleValue() > prodSku.getSalesPrice())) continue;
                    updateProd.setListPrice(new BigDecimal(prodSku.getSalesPrice()).setScale(2, 5));
                }
            }
            updateProd.setCategoryId(psSkuVO.getCategoryId());
            updateProd.setCategoryCode(this.mcPcsSkuCategoryService.findById(psSkuVO.getCategoryId().longValue()).getCode());
        }
        if (CollectionUtils.isEmpty(updateProds)) {
            return true;
        }
        return this.update(updateProds);
    }

    public PsProductVO updateCategory(PsProductVO updateProd) {
        PsSkuVO psSkuVO = this.mcPsSkuService.findBySkuCode((String)updateProd.getSkuCodes().get(0));
        if (NumberUtil.isNullOrZero((Number)psSkuVO.getCategoryId())) {
            return updateProd;
        }
        updateProd.setCategoryId(psSkuVO.getCategoryId());
        return updateProd;
    }

    public PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.canSkus", skuCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("skuCodes", skuCode);
        params.put("onShelfChnCodes", chnCode);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return (PsProductVO)fs.get(0);
    }

    public PsProductVO findProdBySkuCode(String skuCode) {
        return this.findProdBySkuCode(skuCode, false);
    }

    public PsProductVO findProdBySkuCode(String skuCode, Boolean combined) {
        List fs;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodes", skuCode);
        if (combined != null) {
            params.put("combined", combined != false ? 1 : 0);
        }
        if (CollectionUtils.isEmpty(fs = this.client.findByFields(params, SearchType.ANDLIKE))) {
            return null;
        }
        return (PsProductVO)fs.get(0);
    }

    public PsProductVO findProdBySpvId(Long spvId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("spvId", spvId);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return (PsProductVO)fs.get(0);
    }

    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode) {
        List categories = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        ArrayList<Long> cateIds = new ArrayList<Long>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryId", cateIds);
        int currpage = 1;
        params.put("pagenum", 20);
        params.put("currpage", currpage);
        ArrayList seqList = new ArrayList();
        ArrayList<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        ArrayList<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
        params.put("sort", seqList);
        ArrayList<PsProductVO> productVOs = new ArrayList<PsProductVO>(100);
        List prodVos = this.client.findByFields(params, SearchType.ANDLIKE);
        productVOs.addAll(prodVos);
        while (prodVos.size() == 20) {
            params.put("currpage", ++currpage);
            params.put("pagenum", 20);
            params.put("sort", seqList);
            prodVos = this.client.findByFields(params, SearchType.ANDLIKE);
            productVOs.addAll(prodVos);
        }
        return productVOs;
    }

    public List<PsProductVO> findListPageByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("code", codes);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        ArrayList seqList = new ArrayList();
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchListPageCampaigns(productVOList, matchCampaignCond);
            productVOList = this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    public List<PsProductVO> findByProdSearchCondVO(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},prodSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        String key = prodSearchCondVO.getKeywords();
        String labels = prodSearchCondVO.getLabels();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> slMap = new HashMap<String, String>();
        if (isCrossBorder.booleanValue()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            LOGGER.info("\u662f\u5426\u6d77\u6dd8\u5546\u54c1\u67e5\u8be2\u7684\u53c2\u6570    params={} from={},size={},isCrossBorder={}", new Object[]{params, from, size, isCrossBorder});
            selectMap.put("isCrossBorder", isCrossBorder);
            List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
                this.matchListPageCampaigns(productVOList, matchCampaignCond);
                this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        if (!Strings.isNullOrEmpty((String)labels)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            LOGGER.info("\u6807\u7b7e\u67e5\u8be2\u7684\u53c2\u6570    params={} from={},size={},psTags={}", new Object[]{params, from, size, labels});
            selectMap.put("labels", labels);
            List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
                this.matchListPageCampaigns(productVOList, matchCampaignCond);
                this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        if (Strings.isNullOrEmpty((String)key)) {
            ArrayList categoriesList = new ArrayList();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    categoriesList.addAll(category);
                }
            }
            ArrayList<Long> cateIds = new ArrayList<Long>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
            if (!isNew.booleanValue() && CollectionUtils.isEmpty(cateIds)) {
                return Collections.emptyList();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            if (isNew.booleanValue()) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    Date end = new Date();
                    dateRange.setEnd(end);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    ((Calendar)calendar).add(5, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }
            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();
            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");
            if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
                seqMap.put("saleStartDate", "desc");
            } else if ("create_time".equals(sortField)) {
                seqMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                seqMap.put("listPrice", sortOrder);
            }
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);
            params.put("sort", seqMap);
            List<PsProductVO> productVOList = this.client.findByFieldWithProdSearchCondVO(params, SearchType.ANDLIKE, from, size);
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
                this.matchListPageCampaigns(productVOList, matchCampaignCond);
                this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");
        LOGGER.info("\u5173\u952e\u5b57\u67e5\u8be2\u7684\u53c2\u6570    params={} from={},size={},key={}", new Object[]{params, from, size, key});
        List<PsProductVO> productVOList = this.client.findByFieldWithKeyWords(params, SearchType.ANDLIKE, key, from, size);
        LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchListPageCampaigns(productVOList, matchCampaignCond);
            this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        sw.stop();
        LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return productVOList;
    }

    private void matchListPageCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond) {
        Integer memberLavel = cond.getMemberLevel();
        Integer accessWay = cond.getAccessWay();
        List<PsCampaignVO> globalCampaigns = this.getGlobalCampaignList(memberLavel, accessWay);
        for (PsProductVO psProductVO : productVOList) {
            List campaignList = psProductVO.getCampaignList();
            psProductVO.getCampaignList().addAll(globalCampaigns);
            List<PsCampaignVO> matchedCampaignList = this.matchCampaignList(campaignList, psProductVO, memberLavel, accessWay);
            psProductVO.setCampaignList(matchedCampaignList);
        }
    }

    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }
        List categories = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        ArrayList<Long> cateIds = new ArrayList<Long>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        ArrayList seqList = new ArrayList();
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        String fieldName = categories.size() > 1 ? "sort1" : "sort2";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        seqMap.put("_script", map);
        map.put("script", "frontCategorySort");
        map.put("params", paramsMap);
        paramsMap.put("categoryIds", cateIds);
        paramsMap.put("fieldName", fieldName);
        map.put("order", "asc");
        map.put("mode", "min");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchListPageCampaigns(productVOList, matchCampaignCond);
            productVOList = this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    public List<PsProductVO> findByChnCodeCateCodeCreateTime(String chnCode, Map<String, Date> dateRange, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        LinkedHashMap sortRootMap = new LinkedHashMap();
        HashMap<String, Object> sortSoldOut = new HashMap<String, Object>();
        sortRootMap.put("stocks.soldOut", sortSoldOut);
        sortSoldOut.put("order", "asc");
        sortSoldOut.put("mode", "min");
        HashMap<String, String> soldOutNestedFilter = new HashMap<String, String>();
        sortSoldOut.put("nested_filter", soldOutNestedFilter);
        soldOutNestedFilter.put("stocks.chnCode", chnCode);
        HashMap<String, Object> sortCreateTime = new HashMap<String, Object>();
        sortRootMap.put("channelProdInfo.createTime", sortCreateTime);
        sortCreateTime.put("order", "desc");
        sortCreateTime.put("mode", "min");
        HashMap createTimeNestedFilter = new HashMap();
        sortCreateTime.put("nested_filter", createTimeNestedFilter);
        HashMap rangeMap = new HashMap();
        createTimeNestedFilter.put("range", rangeMap);
        HashMap<String, Date> createTimeRangeMap = new HashMap<String, Date>();
        rangeMap.put("channelProdInfo.createTime", createTimeRangeMap);
        createTimeRangeMap.put("from", dateRange.get("createTimeStart"));
        createTimeRangeMap.put("to", dateRange.get("createTimeEnd"));
        params.put("sort", sortRootMap);
        HashMap<String, Object> chanelProdTime = new HashMap<String, Object>();
        chanelProdTime.put("createTimeStart", dateRange.get("createTimeStart"));
        chanelProdTime.put("createTimeEnd", dateRange.get("createTimeEnd"));
        chanelProdTime.put("channelCode", chnCode);
        params.put("chanelProdTime", chanelProdTime);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, matchCampaignCond, true);
            this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    public List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode) {
        ArrayList<PsProductVO> allProds = new ArrayList<PsProductVO>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryCode", cateCode);
        List productVOs = this.client.findByFields(params, SearchType.AND);
        if (CollectionUtils.isNotEmpty(productVOs)) {
            allProds.addAll(productVOs);
        }
        params.remove("categoryCode");
        params.put("categoryCodePRE", String.valueOf(cateCode) + "_");
        List productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isNotEmpty(productVOList)) {
            allProds.addAll(productVOList);
        }
        return allProds;
    }

    public PsProductVO findProdByCode(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        for (PsProductVO vo : fs) {
            vo.setCampaignList((List)Lists.newArrayList());
        }
        return (PsProductVO)fs.get(0);
    }

    public Map<String, PsProductVO> mapByProdIds(List<String> prodIds) {
        if (CollectionUtils.isNotEmpty(prodIds)) {
            HashMap rt = Maps.newHashMapWithExpectedSize((int)prodIds.size());
            PsProductCond cond = new PsProductCond();
            cond.setIds(prodIds);
            List<PsProductVO> prods = this.findByCond(cond);
            for (PsProductVO prod : prods) {
                rt.put(prod.getId(), prod);
            }
            return rt;
        }
        return null;
    }

    public PsProductVO getProductDetailByCode(String chnCode, String productCode, PsMatchCampaignCond matchCampaignCond) {
        List skuList;
        List spvList;
        if (matchCampaignCond == null) {
            throw new PublicException("\u672a\u4f20\u6d3b\u52a8\u5339\u914d\u6761\u4ef6");
        }
        HashedMap params = new HashedMap();
        params.put("code", productCode);
        List list = this.client.findByFields((Map<String, Object>)params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(list)) {
            params = new HashedMap();
            params.put("skuCode", productCode);
            params.put("combined", 0);
            list = this.client.findByFields((Map<String, Object>)params, SearchType.ANDLIKE);
            if (CollectionUtils.isEmpty(list)) {
                params = new HashedMap();
                params.put("skuCode", productCode);
                params.put("combined", 1);
                list = this.client.findByFields((Map<String, Object>)params, SearchType.ANDLIKE);
                if (CollectionUtils.isEmpty(list)) {
                    return null;
                }
            }
        }
        PsProductVO psProductVO = (PsProductVO)list.get(0);
        if (matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(Arrays.asList(psProductVO), matchCampaignCond, true);
            this.calculateDiscountPrice(psProductVO, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        if (CollectionUtils.isEmpty((Collection)(spvList = psProductVO.getSpvList()))) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5546\u54c1\u4e2dSPV\u5217\u8868\u4e3a\u7a7a");
            return psProductVO;
        }
        String productIdStr = psProductVO.getId();
        Long productId = Long.valueOf(productIdStr);
        HashedMap skuMap = new HashedMap();
        List skuCodes = psProductVO.getSkuCodes();
        if (CollectionUtils.isEmpty((Collection)skuCodes)) {
            LOGGER.warn("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5546\u54c1\u4e2dSKU CODE\u5217\u8868\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)(skuList = this.mcPsSkuService.findBySkuCodes(skuCodes)))) {
            LOGGER.warn("\u672a\u627e\u5230\u4efb\u4f55SKU");
        }
        for (PsSkuVO skuVO : skuList) {
            skuMap.put(skuVO.getSkuCode(), skuVO);
        }
        Map<String, String> canSaleSkuMap = this.getCanSaleSkuMap(chnCode, psProductVO);
        Map<String, String> canSeeSkuMap = this.getCanSeeSkuMap(chnCode, psProductVO);
        ArrayList<PsSpvVO> newSpvList = new ArrayList<PsSpvVO>();
        for (PsSpvVO spvVO : spvList) {
            spvVO.setProductId(productId);
            spvVO.setProductCode(psProductVO.getCode());
            if (psProductVO.getCombined().booleanValue()) {
                this.buildCombinedSpv(psProductVO, spvVO, (Map<String, PsSkuVO>)skuMap, matchCampaignCond);
            } else {
                this.buildSingleSpv(psProductVO, spvVO, (Map<String, PsSkuVO>)skuMap, matchCampaignCond);
            }
            if (this.isSpvAvailable(canSaleSkuMap, canSeeSkuMap, spvVO)) {
                this.calculateDiscountPrice(psProductVO, spvVO, matchCampaignCond);
                newSpvList.add(spvVO);
            }
            psProductVO.setSpvList(newSpvList);
        }
        return psProductVO;
    }

    private void buildCombinedSpv(PsProductVO productVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        this.calculateDiscountPrice(productVO, spvVO, matchCampaignCond);
        List skuCombinationList = spvVO.getSkuCombinationList();
        if (CollectionUtils.isEmpty((Collection)skuCombinationList)) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u7ec4\u5408SPV\u4e2d\u7684SKU\u7ec4\u5408\u4e3a\u7a7a");
            return;
        }
        for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
            String skuCode = skuCombinationVO.getSubSkuCode();
            PsSkuVO skuVO = this.getSkuFromCodeOrCache(skuCode, skuMap);
            skuCombinationVO.setSubSkuVO(skuVO);
        }
    }

    private void buildSingleSpv(PsProductVO psProductVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        String skuCode = spvVO.getSkuCode();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)skuCode)) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5355\u54c1SPV\u4e2d\u7684SKU CODE\u4e3a\u7a7a");
            return;
        }
        PsSkuVO skuVO = this.getSkuFromCodeOrCache(skuCode, skuMap);
        skuVO = this.calculateDiscountPrice(skuVO, matchCampaignCond);
        spvVO.setSkuVO(skuVO);
        spvVO.setSalesPrice(new BigDecimal(skuVO.getSalesPrice()));
        spvVO.setCostPrice(skuVO.getCostPrice());
        spvVO.setDiscountPrice(skuVO.getDiscountPrice());
        String skuCategoryDesc = psProductVO.getSkuCategoryDesc();
        String skuCateName = skuVO.getSkuCateName();
        if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{skuCategoryDesc}) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)skuCateName)) {
            PsAttributeValuePairVO attributeValuePairVO = new PsAttributeValuePairVO();
            attributeValuePairVO.setCombined(Boolean.valueOf(false));
            attributeValuePairVO.setAttrName(skuCategoryDesc);
            attributeValuePairVO.setValue(skuCateName);
            spvVO.setAttributeValuePairList(Arrays.asList(attributeValuePairVO));
        }
    }

    private boolean isSpvAvailable(Map<String, String> canSaleMap, Map<String, String> canSeeMap, PsSpvVO spvVO) {
        if (spvVO.getCombined().booleanValue()) {
            List skuCombinationList = spvVO.getSkuCombinationList();
            for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                if (this.isSkuAvailable(canSaleMap, canSeeMap, skuCombinationVO.getSubSkuCode())) continue;
                return false;
            }
            return true;
        }
        return this.isSkuAvailable(canSaleMap, canSeeMap, spvVO.getSkuCode());
    }

    private boolean isSkuAvailable(Map<String, String> canSaleMap, Map<String, String> canSeeMap, String skuCode) {
        return canSaleMap.containsKey(skuCode) && canSeeMap.containsKey(skuCode);
    }

    private PsSkuVO getSkuFromCodeOrCache(String skuCode, Map<String, PsSkuVO> skuMap) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)skuCode)) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5355\u54c1SPV\u4e2d\u7684SKU CODE\u4e3a\u7a7a");
            return null;
        }
        PsSkuVO skuVO = skuMap.get(skuCode);
        if (skuVO == null) {
            LOGGER.warn("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5355\u54c1SPV\u4e2d\u7684SKU[{}]\u672a\u80fd\u5728SKU CODE\u4e2d\u627e\u5230", (Object)skuCode);
            skuVO = this.mcPsSkuService.findBySkuCode(skuCode);
        }
        return skuVO;
    }

    private Map<String, String> getCanSeeSkuMap(String chnCode, PsProductVO psProductVO) {
        HashedMap canSeeSkuMap = new HashedMap();
        List canSeeSkuList = psProductVO.getChnCanSeeSKu();
        if (CollectionUtils.isEmpty((Collection)canSeeSkuList)) {
            return canSeeSkuMap;
        }
        PsChnProdSaleSkuVO canSeeSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSeeSkuList) {
            if (!StringUtils.equals((String)chnProdSaleSkuVO.getChnCode(), (String)chnCode)) continue;
            canSeeSku = chnProdSaleSkuVO;
            break;
        }
        if (canSeeSku != null) {
            for (String skuCode : canSeeSku.getCanSkus()) {
                canSeeSkuMap.put(skuCode, skuCode);
            }
        }
        return canSeeSkuMap;
    }

    private Map<String, String> getCanSaleSkuMap(String chnCode, PsProductVO psProductVO) {
        HashedMap canSaleSkuMap = new HashedMap();
        List canSaleSkuList = psProductVO.getChnCanSaleSKu();
        if (CollectionUtils.isEmpty((Collection)canSaleSkuList)) {
            return canSaleSkuMap;
        }
        PsChnProdSaleSkuVO canSaleSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSaleSkuList) {
            if (!StringUtils.equals((String)chnProdSaleSkuVO.getChnCode(), (String)chnCode)) continue;
            canSaleSku = chnProdSaleSkuVO;
            break;
        }
        if (canSaleSku != null) {
            for (String skuCode : canSaleSku.getCanSkus()) {
                canSaleSkuMap.put(skuCode, skuCode);
            }
        }
        return canSaleSkuMap;
    }
}

