/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSupplierDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplier;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierBusinessCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierPurchaseCategory;
import com.thebeastshop.pegasus.merchandise.service.McPcsSupplierService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.merchandise.vo.SupplierBrandRelation;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/supplier")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsSupplierService")
public class McPcsSupplierServiceImpl
implements McPcsSupplierService {
    @Autowired
    private PcsSupplierDomain pcsSupplierDomain;

    @POST
    public Long create(PcsSupplierVO vo, boolean saveDraft) {
        Long supplierId = this.pcsSupplierDomain.create((PcsSupplier)this.pcsSupplierDomain.buildFromVO(vo), saveDraft);
        this.addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
        this.addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
        return supplierId;
    }

    public Long createSupplier(PcsSupplierVO vo) {
        Long supplierId = this.pcsSupplierDomain.create((PcsSupplier)this.pcsSupplierDomain.buildFromVO(vo), vo.isSaveDraft());
        this.addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
        this.addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
        return supplierId;
    }

    @PUT
    public Boolean update(PcsSupplierVO vo, boolean saveDraft) {
        Long supplierId = vo.getId();
        this.addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
        this.addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
        return this.pcsSupplierDomain.update((PcsSupplier)this.pcsSupplierDomain.buildFromVO(vo), saveDraft);
    }

    public Boolean updateSupplier(PcsSupplierVO vo) {
        if (vo.isSaveDraft()) {
            Long supplierId = vo.getId();
            this.addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
            this.addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
        }
        return this.pcsSupplierDomain.update((PcsSupplier)this.pcsSupplierDomain.buildFromVO(vo), vo.isSaveDraft());
    }

    @GET
    @Path(value="{id:\\d+}")
    public PcsSupplierVO findById(@PathParam(value="id") Long id) {
        PcsSupplier record = this.pcsSupplierDomain.findById(id);
        PcsSupplierVO vo = (PcsSupplierVO)this.pcsSupplierDomain.buildFromModel(record);
        if (vo != null) {
            vo.setCategoryList(this.pcsSupplierDomain.findBusinessCategoryBySupplierId(vo != null ? Integer.valueOf(id.intValue()) : null));
            vo.setPurchaseCategoryList(this.pcsSupplierDomain.findPurchaseCategoryBySupplierId(vo != null ? Integer.valueOf(id.intValue()) : null));
        }
        return vo;
    }

    public List<PcsSupplierVO> findByCond(PcsSupplierCond cond) {
        List<PcsSupplierVO> recordList = this.pcsSupplierDomain.findByCond(cond);
        return recordList;
    }

    public List<PcsSupplierVO> findByCriteria(PcsSupplierCond cond) {
        List<PcsSupplier> recordList = this.pcsSupplierDomain.findByCriteria(cond);
        ArrayList<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = (PcsSupplierVO)this.pcsSupplierDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @GET
    @Path(value="name/{name}")
    public List<PcsSupplierVO> findByName(@PathParam(value="name") String name) {
        List<PcsSupplier> recordList = this.pcsSupplierDomain.findByName(name);
        ArrayList<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = (PcsSupplierVO)this.pcsSupplierDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsSupplierVO> findByIds(List<Long> ids) {
        List<PcsSupplier> recordList = this.pcsSupplierDomain.findByIds(ids);
        ArrayList<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = (PcsSupplierVO)this.pcsSupplierDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type) {
        return this.pcsSupplierDomain.audiSupplier(userId, id, isPass, type);
    }

    public long countByCond(PcsSupplierCond cond) {
        return this.pcsSupplierDomain.countByCond(cond);
    }

    public List<SupplierBrandRelation> findSupplierBrandRelation() {
        return null;
    }

    public List<Integer> addPurchaseCategory(Integer supplierId, List<String> categoryList) {
        this.pcsSupplierDomain.deletePurchaseCategoryBySupplierId(supplierId);
        if (EmptyUtil.isNotEmpty(categoryList)) {
            for (String categoryId : categoryList) {
                PcsSupplierPurchaseCategory supplierBusinessCategory = new PcsSupplierPurchaseCategory();
                supplierBusinessCategory.setPurchaseCategory(categoryId);
                supplierBusinessCategory.setSupplierId(supplierId);
                this.pcsSupplierDomain.addSupplierPurchaseCategory(supplierBusinessCategory);
            }
        }
        return null;
    }

    public List<Integer> addBusinessCategory(Integer supplierId, List<String> categoryList) {
        this.pcsSupplierDomain.deleteBusinessCategoryBySupplierId(supplierId);
        if (EmptyUtil.isNotEmpty(categoryList)) {
            for (String categoryId : categoryList) {
                PcsSupplierBusinessCategory supplierBusinessCategory = new PcsSupplierBusinessCategory();
                supplierBusinessCategory.setBusinessCategory(categoryId);
                supplierBusinessCategory.setSupplierId(supplierId);
                this.pcsSupplierDomain.addSupplierBusinessCategory(supplierBusinessCategory);
            }
        }
        return null;
    }
}

