/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsSku;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcPcsSkuService")
public class McPcsSkuServiceImpl
implements McPcsSkuService {
    @Autowired
    private PcsSkuDomain pcsSkuDomain;
    @Autowired
    private PcsSkuSalesPriceChangeDomain pcsSkuSalesPriceChangeDomain;

    public Long create(PcsSkuVO vo) {
        return this.pcsSkuDomain.create((PcsSku)this.pcsSkuDomain.buildFromVO(vo));
    }

    public List<Long> createSkus(List<PcsSkuVO> list) {
        ArrayList<PcsSku> skuList = new ArrayList<PcsSku>();
        for (PcsSkuVO pcsSkuVO : list) {
            pcsSkuVO.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
            skuList.add((PcsSku)this.pcsSkuDomain.buildFromVO(pcsSkuVO));
        }
        return this.pcsSkuDomain.createSkus(skuList);
    }

    public boolean update(PcsSkuVO vo) {
        return this.pcsSkuDomain.update((PcsSku)this.pcsSkuDomain.buildFromVO(vo));
    }

    public PcsSkuVO findById(long id) {
        PcsSku record = this.pcsSkuDomain.findById(id);
        PcsSkuVO vo = (PcsSkuVO)this.pcsSkuDomain.buildFromModel(record);
        return vo;
    }

    public PcsSkuVO findByCode(String code) {
        return this.pcsSkuDomain.findByCode(code);
    }

    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories) {
        return this.pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories);
    }

    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories, boolean withBuyerName) {
        return this.pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories, withBuyerName);
    }

    public List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode) {
        return this.pcsSkuDomain.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }

    public Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode) {
        return this.pcsSkuDomain.findSkuCanSaleAndCanSeeInfo(channelCode, skuCode);
    }

    public List<PcsSkuVO> findByNameOrCode(String nameCode) {
        return this.pcsSkuDomain.findByNameOrCode(nameCode);
    }

    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.findByCond(cond);
    }

    public List<PcsSkuVO> findByCondForExport(PcsSkuCond cond) {
        return this.pcsSkuDomain.findByCondForExport(cond);
    }

    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.findSkuTagByCond(cond);
    }

    public Boolean canUpdateSkuSalesPrice(String code) {
        PcsSkuVO vo = this.pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuDomain.canUpdateSalesPrice(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
        return this.pcsSkuDomain.auditSkuSalesPriceChange(code, isPass, type);
    }

    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return this.pcsSkuDomain.findSkuSalesPriceChangeByCodeAndProcessing(code);
    }

    public List<PcsSkuVO> findSkuByCodes(List<String> codes) {
        return this.pcsSkuDomain.findByCodes(codes);
    }

    public List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories) {
        return this.pcsSkuDomain.findByCodes(codes, withCategories);
    }

    public List<PcsSkuVO> findSkuByCodesWithCategories(List<String> codes, boolean withCategories) {
        return this.pcsSkuDomain.findByCodes(codes, withCategories);
    }

    public Boolean convertSku(PcsSkuVO sku, long skuCustomMadeId) {
        PcsSku pcsSku = (PcsSku)this.pcsSkuDomain.buildFromVO(sku);
        return this.pcsSkuDomain.convertSku(pcsSku, skuCustomMadeId);
    }

    public List<PcsSkuInfoVO> allSkuInfo() {
        return this.pcsSkuDomain.allSkuInfo();
    }

    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return this.pcsSkuDomain.findStockByCode(skuCode);
    }

    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return this.pcsSkuDomain.findChannelSkuForNoDistribute(cond);
    }

    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId) {
        this.pcsSkuDomain.setSkuChannel(skuCodeList, channelCodeList, operatorId);
    }

    public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
        return this.pcsSkuDomain.findSkuByIds(ids);
    }

    public Boolean canUpdateCostPrice(String code) {
        PcsSkuVO vo = this.pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuDomain.canUpdateCostPrice(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public Boolean canUpdateSupplier(String code) {
        PcsSkuVO vo = this.pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuDomain.canUpdateSupplier(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public long countSkuByCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.countSkuByCond(cond);
    }

    public String getCrossBorderFlagByCodes(List<String> codes) {
        return this.pcsSkuDomain.getCrossBorderFlagByCodes(codes);
    }

    public Integer updateSkuCategoryNameByCode(String skuCategoryName, String skuCode) {
        return this.pcsSkuDomain.updateSkuCategoryNameByCode(skuCategoryName, skuCode);
    }

    public List<Integer> getSalesPriceByCodes(List<String> codes) {
        return this.pcsSkuDomain.getSalesPriceByCodes(codes);
    }

    public List<Map> getSalesPriceByProdId(Long prodId) {
        return this.pcsSkuDomain.getSalesPriceByProdId(prodId);
    }

    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
        return this.pcsSkuDomain.findSkuAuditByIds(ids);
    }

    public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
        return this.pcsSkuDomain.selectByBarCode(barCode);
    }

    public List<PcsSkuVO> findSkuBySupplierId(Long supplierId) {
        return this.pcsSkuDomain.findSkuBySupplierId(supplierId);
    }

    public boolean updatePrdcRecipeSkuCost(PcsSkuVO vo) {
        int skuStatus = vo.getSkuStatus();
        String skuCode = vo.getCode();
        PcsSku pcsSku = new PcsSku();
        pcsSku.setId(vo.getId());
        switch (skuStatus) {
            case 0: {
                pcsSku.setCostPrice(vo.getCostPrice());
                pcsSku.setOldCostPrice(vo.getOldCostPrice());
            }
            case 1: {
                pcsSku.setSkuStatus(1);
                List<PcsSkuCostPriceChange> costPriceChangeList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 1);
                if (!EmptyUtil.isNotEmpty(costPriceChangeList)) break;
                PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
                pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange.setChangeTime(new Date());
                pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
                this.pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
                break;
            }
            case 2: {
                pcsSku.setSkuStatus(1);
                PcsSkuCostPriceChange pcsSkuCostPriceChange = new PcsSkuCostPriceChange();
                pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
                pcsSkuCostPriceChange.setSkuCode(skuCode);
                pcsSkuCostPriceChange.setChangeTime(new Date());
                this.pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange);
                break;
            }
            case 3: {
                pcsSku.setSkuStatus(1);
                List<PcsSkuCostPriceChange> costPriceChangeList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 4);
                if (!EmptyUtil.isNotEmpty(costPriceChangeList)) break;
                PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
                pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange.setChangeTime(new Date());
                pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
                this.pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
                break;
            }
            case 9: {
                pcsSku.setSkuStatus(1);
                PcsSkuCostPriceChange pcsSkuCostPriceChange1 = new PcsSkuCostPriceChange();
                pcsSkuCostPriceChange1.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange1.setNewPrice(vo.getCostPrice());
                pcsSkuCostPriceChange1.setSkuCode(skuCode);
                pcsSkuCostPriceChange1.setChangeTime(new Date());
                this.pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange1);
                break;
            }
        }
        this.pcsSkuDomain.updateSku(pcsSku);
        return false;
    }

    public int updateSku(PcsSkuVO vo) {
        PcsSku pcsSku = new PcsSku();
        BeanUtils.copyProperties((Object)vo, (Object)pcsSku);
        return this.pcsSkuDomain.updateSku(pcsSku);
    }

    public boolean costPriceNeedApproval(PcsSkuVO vo) {
        PcsSku pcsSku = new PcsSku();
        BeanUtils.copyProperties((Object)vo, (Object)pcsSku);
        return this.pcsSkuDomain.costPriceNeedApproval(pcsSku);
    }
}

