/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsBuyerDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsBusinessCategoryPermission;
import com.thebeastshop.pegasus.merchandise.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.merchandise.model.PcsPurchaseCategoryPermission;
import com.thebeastshop.pegasus.merchandise.service.McPcsBuyerInfoService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Path(value="/buyer")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsBuyerInfoService")
public class McPcsBuyerInfoServiceImpl
implements McPcsBuyerInfoService {
    @Autowired
    private PcsBuyerDomain pcsBuyerDomain;

    @GET
    @Path(value="{id:\\d+}")
    public PcsBuyerInfoVO getBuyerInfoById(@PathParam(value="id") Long id) {
        int n;
        ArrayList<String> categoryList = new ArrayList<String>();
        PcsBuyerInfoVO pcsBuyerInfoVO = this.pcsBuyerDomain.getBuyerInfoById(id);
        if (EmptyUtil.isNotEmpty((String)pcsBuyerInfoVO.getBussinessCategory())) {
            String[] array;
            String[] stringArray = array = pcsBuyerInfoVO.getBussinessCategory().split(",");
            n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String categoryId = stringArray[n2];
                categoryList.add(categoryId);
                ++n2;
            }
        }
        pcsBuyerInfoVO.setCategoryList(categoryList);
        ArrayList<String> purchaseCategoryList = new ArrayList<String>();
        if (EmptyUtil.isNotEmpty((String)pcsBuyerInfoVO.getPurchaseCategory())) {
            String[] array;
            String[] stringArray = array = pcsBuyerInfoVO.getPurchaseCategory().split(",");
            int n3 = array.length;
            n = 0;
            while (n < n3) {
                String categoryId = stringArray[n];
                purchaseCategoryList.add(categoryId);
                ++n;
            }
        }
        pcsBuyerInfoVO.setPurchaseCategoryList(purchaseCategoryList);
        return pcsBuyerInfoVO;
    }

    @GET
    @Path(value="all")
    public List<PcsBuyerInfoVO> getAllBuyers() {
        return this.pcsBuyerDomain.getAllBuyers();
    }

    public List<Map<String, String>> getAllBuyerInfos() {
        return this.pcsBuyerDomain.getAllBuyerInfos();
    }

    public List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond) {
        List<PcsBuyerInfo> list = this.pcsBuyerDomain.getBuyerByCond(cond);
        return BeanUtil.buildListFrom(list, PcsBuyerInfoVO.class);
    }

    @POST
    public Boolean newBuyer(PcsBuyerInfoVO vo) {
        PcsBuyerInfo buyer = (PcsBuyerInfo)BeanUtil.buildFrom((Object)vo, PcsBuyerInfo.class);
        return this.pcsBuyerDomain.newBuyer(buyer);
    }

    @PUT
    public Boolean updateBuyerInfo(PcsBuyerInfoVO vo) {
        PcsBuyerInfo buyer = (PcsBuyerInfo)BeanUtil.buildFrom((Object)vo, PcsBuyerInfo.class);
        return this.pcsBuyerDomain.updateBuyerInfo(buyer);
    }

    @GET
    @Path(value="category/buyer_id/{id:\\d+}")
    public UserInfo findCategoryManagerByBuyer(Integer buyerId) {
        return this.pcsBuyerDomain.findCategoryManagerByBuyer(buyerId);
    }

    @Transactional
    public List<Integer> addPurchaseCategoryPermission(Integer userId, List<String> categoryList) {
        this.pcsBuyerDomain.deletePurchaseCategoryPermByUserId(userId);
        if (EmptyUtil.isNotEmpty(categoryList)) {
            for (String categoryId : categoryList) {
                PcsPurchaseCategoryPermission purchaseCategoryPermission = new PcsPurchaseCategoryPermission();
                purchaseCategoryPermission.setOperatorId(userId);
                purchaseCategoryPermission.setPurchaseCategoryId(Integer.parseInt(categoryId));
                this.pcsBuyerDomain.addPurchaseCategoryPermission(purchaseCategoryPermission);
            }
        }
        return null;
    }

    @Transactional
    public List<Integer> addBusinessCategoryPermission(Integer userId, List<String> categoryList) {
        this.pcsBuyerDomain.deleteBusinessCategoryPermByUserId(userId);
        if (EmptyUtil.isNotEmpty(categoryList)) {
            for (String categoryId : categoryList) {
                PcsBusinessCategoryPermission businessCategoryPermission = new PcsBusinessCategoryPermission();
                businessCategoryPermission.setOperatorId(userId);
                businessCategoryPermission.setBusinessCategoryId(Integer.parseInt(categoryId));
                this.pcsBuyerDomain.addBusinessCategoryPermission(businessCategoryPermission);
            }
        }
        return null;
    }
}

