/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsBrandDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsBrand;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/brand")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsBrandService")
public class McPcsBrandServiceImpl
implements McPcsBrandService {
    @Autowired
    private PcsBrandDomain pcsBrandDomain;

    public Long create(PcsBrandVO record, boolean saveDraft) {
        return this.pcsBrandDomain.create((PcsBrand)this.pcsBrandDomain.buildFromVO(record), saveDraft);
    }

    @POST
    @Path(value="")
    public Long createBrand(PcsBrandVO vo) {
        return this.pcsBrandDomain.create((PcsBrand)this.pcsBrandDomain.buildFromVO(vo), vo.isSaveDraft());
    }

    public boolean update(PcsBrandVO record, boolean saveDraft) {
        return this.pcsBrandDomain.update((PcsBrand)this.pcsBrandDomain.buildFromVO(record), saveDraft);
    }

    @PUT
    @Path(value="")
    public boolean updateBrand(PcsBrandVO vo) {
        return this.pcsBrandDomain.update((PcsBrand)this.pcsBrandDomain.buildFromVO(vo), vo.isSaveDraft());
    }

    @GET
    @Path(value="{id:\\d=}")
    public PcsBrandVO findById(@PathParam(value="id") long id) {
        return (PcsBrandVO)this.pcsBrandDomain.buildFromModel(this.pcsBrandDomain.findById(id));
    }

    public List<PcsBrandVO> findByCond(PcsBrandCond cond) {
        return this.pcsBrandDomain.findByCond(cond);
    }

    @GET
    @Path(value="name/{name}")
    public List<PcsBrandVO> findByName(@PathParam(value="name") String name) {
        return BeanUtil.buildListFrom(this.pcsBrandDomain.findByName(name), PcsBrandVO.class);
    }

    public List<PcsBrandVO> findByIds(List<Long> ids) {
        return BeanUtil.buildListFrom(this.pcsBrandDomain.findByIds(ids), PcsBrandVO.class);
    }

    public Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type) {
        return this.pcsBrandDomain.auditBrand(userId, id, isPass, type);
    }

    public long countByCond(PcsBrandCond cond) {
        return this.pcsBrandDomain.countByCond(cond);
    }
}

