/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.client.SkuESClient;
import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.domain.PsSkuDomain;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="psSkuDomain")
public class PsSKuDomainmpl
implements PsSkuDomain {
    private static final Logger log = LoggerFactory.getLogger(PsSKuDomainmpl.class);
    @Autowired
    private SkuESClient client;

    @Override
    public boolean create(PsSkuVO vo) {
        return this.client.create(vo);
    }

    @Override
    public boolean update(PsSkuVO vo) {
        return this.client.update(vo);
    }

    @Override
    public boolean update(List<PsSkuVO> vos) {
        return this.client.update(vos);
    }

    @Override
    public boolean deleteBySkuCode(String skuCode) {
        return this.client.deleteByPrimaryKey(skuCode);
    }

    @Override
    public List<PsSkuVO> findBySkuName(String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuName", name);
        params.put("skuNameCN", name);
        return this.client.findByFields(params, SearchType.OR);
    }

    @Override
    public PsSkuVO findBySkuCode(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", code);
        List skuVOs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(skuVOs)) {
            return null;
        }
        return (PsSkuVO)skuVOs.get(0);
    }

    @Override
    public List<PsSkuVO> findBySkuCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pagenum", Integer.MAX_VALUE);
        int _page_max = 100;
        if (codes.size() > _page_max) {
            int length = codes.size();
            int len = length / _page_max;
            ArrayList<PsSkuVO> allSkus = new ArrayList<PsSkuVO>(codes.size());
            int i = 0;
            while (i < len) {
                params.put("skuCode", codes.subList(_page_max * i, _page_max * (i + 1)));
                params.put("pagenum", Integer.MAX_VALUE);
                allSkus.addAll(this.client.findByFields(params, SearchType.OR));
                ++i;
            }
            if (length % _page_max > 0) {
                params.put("skuCode", codes.subList(_page_max * len, length));
                params.put("pagenum", Integer.MAX_VALUE);
                allSkus.addAll(this.client.findByFields(params, SearchType.OR));
            }
            return allSkus;
        }
        params.put("skuCode", codes);
        return this.client.findByFields(params, SearchType.OR);
    }

    @Override
    public List<PsSkuVO> findBySuppIds(List<Long> suppIds) {
        if (CollectionUtils.isEmpty(suppIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("supplierId", suppIds);
        return this.client.findByFields(params, SearchType.OR);
    }

    @Override
    public List<PsSkuVO> findByBrandIds(List<Long> brandIds) {
        if (CollectionUtils.isEmpty(brandIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("brandId", brandIds);
        return this.client.findByFields(params, SearchType.OR);
    }

    @Override
    public List<PsSkuVO> findByCateIds(List<Long> cateIds) {
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", cateIds);
        return this.client.findByFields(params, SearchType.OR);
    }

    @Override
    public List<PsSkuVO> findByCond(PsSkuCond cond) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        return this.client.findByFields(params, SearchType.ANDLIKE);
    }

    @Override
    public List<PsSkuVO> findAll() {
        return this.client.findAllByField(null, null);
    }

    @Override
    public boolean create(List<PsSkuVO> vos) {
        return this.client.create(vos);
    }

    private PsSkuVO validateSkuCode(String skuCode) {
        PsSkuVO vos = this.findBySkuCode(skuCode);
        if (vos == null) {
            throw new PublicException("PB0002", "SKU \u4e0d\u5b58\u5728");
        }
        return vos;
    }

    @Override
    public List<PsSkuVO> findByCodeName(String codeName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", codeName);
        params.put("skuName", codeName);
        params.put("skuNameCN", codeName);
        params.put("pagenum", 100);
        return this.client.findByFields(params, SearchType.ORLIKE);
    }

    @Override
    public List<PsSkuVO> findByCodeName(String codeName, Integer currpage, Integer pagenum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", codeName);
        params.put("skuName", codeName);
        params.put("skuNameCN", codeName);
        params.put("pagenum", pagenum);
        return this.client.findByFields(params, SearchType.ORLIKE);
    }

    @Override
    public Map<String, PsSkuVO> mapBySkuCodes(List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            HashMap rt = Maps.newHashMapWithExpectedSize((int)codes.size());
            List<PsSkuVO> skus = this.findBySkuCodes(codes);
            for (PsSkuVO sku : skus) {
                rt.put(sku.getSkuCode(), sku);
            }
            return rt;
        }
        return null;
    }

    @Override
    public List<PcsSkuVO> findSkuBySupplierId(Long supplierId) {
        return null;
    }
}

